/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.ref;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.entity.ZSSEntities;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.client.SyncConfigPacket;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.WarpPoint;

public class Config {
    public static Configuration config;
    public static boolean isBuffBarEnabled;
    public static boolean isBuffBarHorizontal;
    public static boolean isBuffBarLeft;
    public static boolean showSecretMessage;
    public static boolean isComboHudEnabled;
    private static int hitsToDisplay;
    public static boolean allowVanillaControls;
    public static boolean requireDoubleTap;
    public static boolean isItemModeEnabled;
    public static boolean isItemModeTop;
    public static boolean isItemModeLeft;
    private static int resetNotesInterval;
    public static boolean enableHookshotSound;
    public static boolean enableAutoTarget;
    public static boolean canTargetPlayers;
    public static boolean isMagicMeterTextEnabled;
    public static boolean isMagicMeterEnabled;
    public static int magicMeterOffsetX;
    public static int magicMeterOffsetY;
    public static boolean isMagicMeterHorizontal;
    public static boolean isMagicMeterCenteredX;
    public static boolean isMagicMeterLeft;
    public static boolean isMagicMeterTop;
    public static int magicMeterWidth;
    public static int magicMeterIncrements;
    private static boolean enableOffhandMaster;
    private static String[] swords;
    private static String[] weapons;
    private static String[] forbidden_swords;
    private static String[] forbidden_weapons;
    private static boolean enableStunPlayer;
    private static boolean enableSwingSpeed;
    private static int baseSwingSpeed;
    private static boolean enableHardcoreZeldaFanMode;
    private static boolean enableSecretStoneLift;
    private static boolean enableVanillaLift;
    private static boolean enableVanillaSmash;
    private static boolean alwaysPickupHearts;
    private static float bossHealthFactor;
    private static int bossNumber;
    private static boolean enableJarUpdates;
    private static float keeseCursedChance;
    private static float keeseSwarmChance;
    private static int keeseSwarmSize;
    private static int sacredRefreshRate;
    private static int skulltulaRewardRate;
    private static boolean disableVanillaBuffs;
    private static boolean npcsAreInvulnerable;
    private static int naviRange;
    private static int naviFrequency;
    private static boolean arrowsConsumeFlame;
    private static int bombFuseTime;
    private static boolean onlyBombSecretStone;
    private static boolean bombsGriefAdventure;
    private static boolean enableDekuDenude;
    private static boolean enableDinIgnite;
    private static boolean enableDinMelt;
    private static boolean disableAllUnenchantables;
    private static boolean enableMegaSmashQuake;
    private static int heroBowUpgradeCost;
    private static boolean enableFireArrowIgnite;
    private static boolean enableFireArrowMelt;
    private static boolean enableLightArrowNoClip;
    private static boolean enableAutoBombArrows;
    private static int hookshotRange;
    private static boolean enableHookableOnly;
    private static boolean enableHookshotBreakBlocks;
    private static boolean medallionsAffectPlayers;
    private static int rodUpgradeCost;
    private static int temperedRequiredKills;
    private static boolean allMasterSwordsProvidePower;
    private static int numSkelKeyUses;
    private static int slingshotUpgradeOne;
    private static int slingshotUpgradeTwo;
    private static int whipRange;
    public static boolean enableStartingGear;
    public static boolean enableAutoEquip;
    public static boolean enableLinksHouse;
    public static boolean enableOrb;
    public static boolean enableFullSet;
    public static boolean enableTunic;
    public static boolean enableSword;
    public static boolean enableNavi;
    private static int maxBonusHearts;
    private static boolean allowDisarmorPlayer;
    private static float disarmTimingBonus;
    private static float disarmPenalty;
    private static boolean allowUnlimitedNayru;
    private static int maxMagicPoints;
    private static boolean requireFullHealth;
    private static int minSongIntervalStorm;
    private static int minSongIntervalSun;
    private static boolean avoidModBlocks;
    private static boolean enableWindows;
    private static boolean enableBossDungeons;
    private static boolean randomizeBossDungeons;
    private static int minBossDistance;
    private static int minBossDistanceNether;
    private static int minLandDistance;
    private static int minDistanceNether;
    private static int minOceanDistance;
    private static int genAttemptsPerChunk;
    private static float secretRoomChance;
    private static int mainDungeonDifficulty;
    private static int genAttemptsPerChunkNether;
    private static float secretRoomChanceNether;
    private static int netherDungeonDifficulty;
    private static float fairySpawnerChance;
    private static int resetSpawnerTime;
    private static boolean disableStructureGen;
    private static int noGenX;
    private static int noGenZ;
    private static float ancientTabletGenChance;
    private static int ancientTabletGenDistance;
    private static boolean enableBombFlowerGen;
    private static boolean allowJarsInWater;
    private static float jarGenChance;
    private static int jarsPerCluster;
    private static float jarGenChanceSub;
    private static int jarsPerClusterSub;
    private static int jarClustersPerChunkSub;
    private static float jarGenChanceNether;
    private static int jarsPerClusterNether;
    private static int jarClustersPerChunkNether;
    private static float gossipStoneRate;
    private static boolean enablePillarGen;
    private static int maxPillarRange;
    private static int minBrokenPillarDistance;
    private static int minSongPillarDistance;
    private static float masterSwordChance;
    private static float lockedChestChance;
    private static float doubleChestChance;
    private static float barredRoomChance;
    private static float heartPieceChance;
    private static float randomBossItemChance;
    private static int minNumChestItems;
    private static int bombWeight;
    private static int bombBagWeight;
    private static int heartPieceWeight;
    private static int bigKeyWeight;
    private static int smallKeyWeight;
    private static int lockedLootWeight;
    private static Set<Byte> lootableOrbs;
    private static float grassDropChance;
    private static float jarDropChance;
    private static float creeperDrop;
    private static int mobConsumableFrequency;
    private static boolean enableOrbDrops;
    private static float randomDropChance;
    private static float genericMobDropChance;
    private static Map<Byte, Float> orbDropChance;
    private static int powerDropRate;
    private static float vanillaWhipLootChance;
    private static float globalWhipLootChance;
    private static boolean hurtOnSteal;
    private static boolean enableTradeBombBag;
    private static int bombBagPrice;
    private static boolean enableTradeBomb;
    private static boolean enableArrowTrades;
    private static float maskBuyChance;
    private static int friendTradesRequired;
    private static float roomSpawnMobChance;
    private static float mobVariantChance;
    private static int minDaysToSpawnDarknut;
    private static int minDaysToSpawnWizzrobe;
    private static final String WARP_LOCATIONS_KEY = "Default Warp Locations: one per line with format 'song_name:[dimension_id,x,y,z]'";
    private static Map<AbstractZeldaSong, WarpPoint> warp_defaults;

    public static void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory().getAbsolutePath() + "/zeldaswordskills.cfg"));
        config.load();
        ZSSItems.initConfig(config);
        String category = "client";
        config.addCustomCategoryComment(category, "This category contains client side settings; i.e. they are not synchronized with the server.");
        isBuffBarEnabled = config.get(category, "[Buff HUD] Whether the buff bar should be displayed at all times", true).getBoolean(true);
        isBuffBarHorizontal = config.get(category, "[Buff HUD] Whether the buff bar should be displayed horizontally", true).getBoolean(true);
        isBuffBarLeft = config.get(category, "[Buff HUD] Whether the buff bar should be displayed on the left side of the screen", false).getBoolean(false);
        showSecretMessage = config.get(category, "[Chat] Whether to show a chat message when striking secret blocks", false).getBoolean(false);
        isComboHudEnabled = config.get(category, "[Combo HUD] Whether the combo hit counter will display by default (toggle in game: 'v')", true).getBoolean(true);
        hitsToDisplay = MathHelper.func_76125_a((int)config.get(category, "[Combo HUD] Max hits to display in Combo HUD [0-12]", 3).getInt(), (int)0, (int)12);
        allowVanillaControls = config.get(category, "[Controls] Whether to use vanilla movement keys to activate skills such as Dodge and Parry", true).getBoolean(true);
        requireDoubleTap = config.get(category, "[Controls] Whether Dodge and Parry require double-tap or not (double-tap always required with vanilla control scheme)", true).getBoolean(true);
        isItemModeEnabled = config.get(category, "[Item Mode HUD] Enable item mode HUD display (if disabled, mode may still be viewed in the item's tooltip)", true).getBoolean(true);
        isItemModeTop = config.get(category, "[Item Mode HUD] Whether the item mode icon should be displayed on the top or bottom of the screen", true).getBoolean(true);
        isItemModeLeft = config.get(category, "[Item Mode HUD] Whether the item mode icon should be displayed on the left or right side of the screen", true).getBoolean(true);
        resetNotesInterval = MathHelper.func_76125_a((int)config.get(category, "[Song GUI] Number of ticks allowed between notes before played notes are cleared [5-100]", 30).getInt(), (int)5, (int)100);
        enableHookshotSound = config.get(category, "[Sound] Whether to play the 'itembreak' sound when the hookshot misses", true).getBoolean(true);
        enableAutoTarget = config.get(category, "[Targeting] Whether auto-targeting is enabled or not (toggle in game: '.')", true).getBoolean(true);
        canTargetPlayers = config.get(category, "[Targeting] Whether players can be targeted (toggle in game: '.' while sneaking)", true).getBoolean(true);
        category = "Magic Meter";
        config.addCustomCategoryComment(category, "Magic meter can be configured to display anywhere on the screen using the offset X and Y.\nOffsets are in relation to its initial position, which is either in one of the four corners\nof the screen, or at the top or bottom with the left-most edge at the center of the screen.\n\nDefault maximum width is 75 which is the same width as the hunger bar when the player has\ngained magic points equal to or greater than 50 times the number of increments required.\nE.g., at 2 increments, the meter for a player with 100 mp will be at maximum width.\n===============================================\nCommon Settings\n===============================================\nAbove Hunger Bar, from right to left: x=91, y=-40, orientation=true, centered=true, left=false, top=false\nAbove Hunger Bar, from left to right: x=10, y=-40, orientation=true, centered=true, left=true, top=false\nAny Corner: x=0, y=0, centered=false (top, left, and orientation may be any value)");
        isMagicMeterTextEnabled = config.get(category, "Enable text display of current Magic Points", false).getBoolean(false);
        isMagicMeterEnabled = config.get(category, "Enable the Magic Meter HUD display", true).getBoolean(true);
        magicMeterOffsetX = config.get(category, "[Offset: X] Moves the Meter left (-) or right (+) this number of pixels", 91).getInt();
        magicMeterOffsetY = config.get(category, "[Offset: Y] Moves the Meter up (-) or down (+) this number of pixels", -40).getInt();
        isMagicMeterHorizontal = config.get(category, "[Orientation] True for a horizontal magic meter, or false for a vertical one", true).getBoolean(true);
        isMagicMeterCenteredX = config.get(category, "[Position: Centered] Whether the horizontal position is relative to the center of the screen (+ is to the right, - is to the left)", true).getBoolean(true);
        isMagicMeterLeft = config.get(category, "[Position: Left] Whether the horizontal position is relative to the left side of the screen (offsetX should usually be negative if false)", false).getBoolean(false);
        isMagicMeterTop = config.get(category, "[Position: Top] Whether the vertical position is relative to the top of the screen (offsetY should be negative if false)", false).getBoolean(false);
        magicMeterWidth = config.get(category, "[Width: Max] Maximum width of the magic meter [25-100]", 75).getInt();
        magicMeterIncrements = config.get(category, "[Width: Increment] Number of increments required to max out the magic meter, where each increment is 50 magic points [1-10]", 2).getInt();
        enableOffhandMaster = config.get("Mod Support", "[BattleGear2] Allow Master Swords to be held in the off-hand", false).getBoolean(false);
        swords = config.get("Weapon Registry", "[Allowed Swords] Enter items as modid:registered_item_name, each on a separate line between the '<' and '>'", new String[0], "Register an item so that it is considered a SWORD by ZSS, i.e. it be used with skills that\nrequire swords, as well as other interactions that require swords, such as cutting grass.\nAll swords are also considered WEAPONS.").getStringList();
        Arrays.sort(swords);
        weapons = config.get("Weapon Registry", "[Allowed Weapons] Enter items as modid:registered_item_name, each on a separate line between the '<' and '>'", new String[0], "Register an item as a generic melee WEAPON. This means it can be used for all\nskills except those that specifically require a sword, as well as some other things.").getStringList();
        Arrays.sort(weapons);
        String[] forbidden = new String[]{"battlegear2:dagger.wood", "battlegear2:dagger.stone", "battlegear2:dagger.gold", "battlegear2:dagger.iron", "battlegear2:dagger.diamond", "battlegear2:mace.wood", "battlegear2:mace.stone", "battlegear2:mace.gold", "battlegear2:mace.iron", "battlegear2:mace.diamond", "battlegear2:spear.wood", "battlegear2:spear.stone", "battlegear2:spear.gold", "battlegear2:spear.iron", "battlegear2:spear.diamond", "battlegear2:waraxe.wood", "battlegear2:waraxe.stone", "battlegear2:waraxe.gold", "battlegear2:waraxe.iron", "battlegear2:waraxe.diamond"};
        forbidden_swords = config.get("Weapon Registry", "[Forbidden Swords] Enter items as modid:registered_item_name, each on a separate line between the '<' and '>'", forbidden, "Forbid one or more items from acting as SWORDs, e.g. if a mod item extends ItemSword but is not really a sword").getStringList();
        Arrays.sort(forbidden_swords);
        forbidden_weapons = config.get("Weapon Registry", "[Forbidden Weapons] Enter items as modid:registered_item_name, each on a separate line between the '<' and '>'", new String[0], "Forbid one or more items from acting as WEAPONs, e.g. if an item is added by IMC and you don't want it to be usable with skills.\nNote that this will also prevent the item from behaving as a SWORD.").getStringList();
        Arrays.sort(forbidden_weapons);
        enableStunPlayer = config.get("General", "Whether players can be stunned; if false, item use is still interrupted", false).getBoolean(false);
        enableSwingSpeed = config.get("General", "Whether the swing speed timer prevents all left-clicks, or only items that use swing speeds", true).getBoolean(true);
        baseSwingSpeed = MathHelper.func_76125_a((int)config.get("General", "Default swing speed (anti-left-click-spam): Sets base number of ticks between each left-click (0 to disable)[0-20]", 0).getInt(), (int)0, (int)20);
        enableSecretStoneLift = config.get("General", "Whether regular (i.e. breakable) secret stone blocks can be picked up using appropriate items (e.g. gauntlets)", false).getBoolean(false);
        enableVanillaLift = config.get("General", "Whether vanilla blocks can be picked up using appropriate items (e.g. gauntlets)", true).getBoolean(true);
        enableVanillaSmash = config.get("General", "Whether vanilla blocks can be smashed using appropriate items (e.g. hammers)", true).getBoolean(true);
        alwaysPickupHearts = config.get("General", "Always pick up small hearts regardless of health", false).getBoolean(false);
        enableHardcoreZeldaFanMode = config.get("General", "Hardcore Zelda Fan: Start with only 3 hearts (applies a -14 max health modifier, so it can be enabled or disabled at any time)", false).getBoolean(false);
        bossHealthFactor = 0.01f * (float)MathHelper.func_76125_a((int)config.get("General", "[Boss] Boss health multiplier, as a percent increase per difficulty level (does not apply to real bosses) [100-500]", 250).getInt(), (int)100, (int)500);
        bossNumber = MathHelper.func_76125_a((int)config.get("General", "[Boss] Number of boss mobs to spawn in Boss Dungeons (does not apply to real bosses) [1-8]", 4).getInt(), (int)1, (int)8);
        enableJarUpdates = config.get("General", "[Ceramic Jars] Whether ceramic jar tile entities update each tick, allowing them to store dropped items", true).getBoolean(true);
        keeseCursedChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("General", "[Mobs][Keese] Chance of a Cursed Keese spawning instead of a normal Keese (0 to disable)[0-100]", 25).getInt(), (int)0, (int)100);
        keeseSwarmChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("General", "[Mobs][Keese] Chance of Keese spawning in a swarm (0 to disable)[0-100]", 25).getInt(), (int)0, (int)100);
        keeseSwarmSize = MathHelper.func_76125_a((int)config.get("General", "[Mobs][Keese] Maximum number of Keese that can spawn in a swarm [4-16]", 6).getInt(), (int)4, (int)16);
        sacredRefreshRate = MathHelper.func_76125_a((int)config.get("General", "[Sacred Flames] Number of days before flame rekindles itself (0 to disable) [0-30]", 7).getInt(), (int)0, (int)30);
        skulltulaRewardRate = MathHelper.func_76125_a((int)config.get("General", "[Skulltula Tokens] Number of days between each recurring reward for completing the quest (0 to disable recurring reward) [0-30]", 7).getInt(), (int)0, (int)30);
        disableVanillaBuffs = config.get("General", "[Mob Buff] Disable all buffs (resistances and weaknesses) for vanilla mobs", false).getBoolean(false);
        npcsAreInvulnerable = config.get("General", "[NPC] Sets whether Zelda NPCs are invulnerable or not", true).getBoolean(true);
        naviRange = MathHelper.func_76125_a((int)config.get("General", "Range at which Navi can sense secret rooms, in blocks (0 to disable) [0-10]", 4).getInt(), (int)0, (int)10);
        naviFrequency = MathHelper.func_76125_a((int)config.get("General", "[NPC][Navi] Frequency with which Navi checks the proximity for secret rooms, in ticks [20-200]", 50).getInt(), (int)20, (int)200);
        arrowsConsumeFlame = config.get("Item", "[Arrows] Whether transforming arrows with the Sacred Flames has a chance to consume the flame", true).getBoolean(true);
        bombFuseTime = MathHelper.func_76125_a((int)config.get("Item", "[Bombs] Minimum fuse time; set to 0 to disable held bomb ticks [0-128]", 56).getInt(), (int)0, (int)128);
        onlyBombSecretStone = config.get("Item", "[Bombs] Whether bombs are non-griefing, i.e. can only destroy secret stone", false).getBoolean(false);
        enableDekuDenude = config.get("Item", "[Deku Leaf] Allow Deku Leaf whirlwind to destroy leaves", true).getBoolean(true);
        enableDinIgnite = config.get("Item", "[Din's Fire] Whether Din's Fire can set blocks on fire", false).getBoolean(false);
        enableDinMelt = config.get("Item", "[Din's Fire] Whether Din's Fire can melt unbreakable ice blocks", true).getBoolean(true);
        disableAllUnenchantables = config.get("Item", "[Enchantments] Disable the vanilla behavior allowing unenchantable items to be enchanted using the anvil", false).getBoolean(false);
        enableMegaSmashQuake = config.get("Item", "[Hammer] True to allow the Megaton Hammer to break Quake Stone (also requires player to have Golden Gauntlets in inventory)", true).getBoolean(true);
        heroBowUpgradeCost = MathHelper.func_76125_a((int)config.get("Item", "[Hero's Bow] Cost (in emeralds) to upgrade, per level [128 - 640]", 192).getInt(), (int)128, (int)640);
        enableFireArrowIgnite = config.get("Item", "[Hero's Bow] Whether the fire arrow can ignite affected blocks", true).getBoolean(true);
        enableFireArrowMelt = config.get("Item", "[Hero's Bow] Whether the fire arrow can melt unbreakable ice blocks", false).getBoolean(false);
        enableLightArrowNoClip = config.get("Item", "[Hero's Bow] Whether the light arrow can penetrate blocks", true).getBoolean(true);
        enableAutoBombArrows = config.get("Item", "[Hero's Bow] Whether to automate bomb arrow firing when sneaking", true).getBoolean(true);
        hookshotRange = MathHelper.func_76125_a((int)config.get("Item", "[Hookshot] Max range of non-extended hookshots [4-16]", 8).getInt(), (int)4, (int)16);
        enableHookableOnly = config.get("Item", "[Hookshot] Whether hookshots are allowed to interact ONLY with IHookable blocks - great for adventure maps!", false).getBoolean(false);
        enableHookshotBreakBlocks = config.get("Item", "[Hookshot] Whether hookshots are allowed to destroy certain blocks such as glass", true).getBoolean(true);
        medallionsAffectPlayers = config.get("Item", "[Magic Medallions] True if Ether and Quake medallions can affect players", true).getBoolean(true);
        rodUpgradeCost = MathHelper.func_76125_a((int)config.get("Item", "[Magic Rods] Cost (in emeralds) to upgrade (note that the Tornado Rod costs 3/4 this value) [128-1280]", 768).getInt(), (int)128, (int)1280);
        temperedRequiredKills = MathHelper.func_76125_a((int)config.get("Item", "[Master Sword] Number of mobs that need to be killed to upgrade the Tempered Sword [100-1000]", 300).getInt(), (int)100, (int)1000);
        allMasterSwordsProvidePower = config.get("Item", "[Master Sword] Whether ALL master swords provide power when placed in a Sword Pedestal", true).getBoolean(true);
        numSkelKeyUses = MathHelper.func_76125_a((int)config.get("Item", "[Skeleton Key] Number of locked chests which can be opened before key breaks (0 for no limit) [0-500]", 50).getInt(), (int)0, (int)500);
        slingshotUpgradeOne = MathHelper.func_76125_a((int)config.get("Item", "[Slingshot] Cost (in emeralds) for first upgrade [64- 320]", 128).getInt(), (int)64, (int)320);
        slingshotUpgradeTwo = MathHelper.func_76125_a((int)config.get("Item", "[Slingshot] Cost (in emeralds) for second upgrade [128 - 640]", 320).getInt(), (int)128, (int)640);
        whipRange = MathHelper.func_76125_a((int)config.get("Item", "[Whip] Range, in blocks, of the standard whip [4-12]", 6).getInt(), (int)4, (int)12);
        enableStartingGear = config.get("Bonus Gear", "Enable bonus starting equipment", true).getBoolean(true);
        enableAutoEquip = config.get("Bonus Gear", "Automatically equip starting equipment", true).getBoolean(true);
        enableLinksHouse = config.get("Bonus Gear", "Begin the game with Link's House - place it anywhere you like!", true).getBoolean(true);
        enableOrb = config.get("Bonus Gear", "Grants a single Basic Sword skill orb", true).getBoolean(true);
        enableFullSet = config.get("Bonus Gear", "Grants a full set of Kokiri clothing: hat, tunic, trousers, boots", true).getBoolean(true);
        enableTunic = config.get("Bonus Gear", "Grants only a Kokiri Tunic (if full set is disabled)", true).getBoolean(true);
        enableSword = config.get("Bonus Gear", "Grants a Kokiri sword", true).getBoolean(true);
        enableNavi = config.get("Bonus Gear", "Start the game with Navi in a bottle (you can always acquire her later if false)", false).getBoolean(false);
        maxBonusHearts = MathHelper.func_76125_a((int)config.get("Skills", "Max Bonus Hearts [0-50]", 20).getInt(), (int)0, (int)50);
        allowDisarmorPlayer = config.get("Skills", "[Back Slice] Allow Back Slice to potentially knock off player armor", true).getBoolean(true);
        disarmTimingBonus = 0.001f * (float)MathHelper.func_76125_a((int)config.get("Skills", "[Parry] Bonus to disarm based on timing: tenths of a percent added per tick remaining on the timer [0-50]", 25).getInt(), (int)0, (int)15);
        disarmPenalty = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Skills", "[Parry] Penalty to disarm chance: percent per Parry level of the opponent, default negates defender's skill bonus so disarm is based entirely on timing [0-20]", 10).getInt(), (int)0, (int)20);
        maxMagicPoints = MathHelper.func_76125_a((int)config.get("Skills", "[Magic] Maximum magic points attainable [50-1000]", 250).getInt(), (int)50, (int)1000);
        allowUnlimitedNayru = config.get("Skills", "[Magic] Allow Nayru's Love to be activated even when magic bar is unlimited (such as after drinking a Chateau Romani)", false).getBoolean(false);
        requireFullHealth = config.get("Skills", "[Super Spin Attack | Sword Beam] True to require a completely full health bar to use, or false to allow a small amount to be missing per level", false).getBoolean(false);
        avoidModBlocks = config.get("Dungeon Generation", "Whether to prevent ZSS structures from generating if any non-vanilla blocks are detected", true).getBoolean(true);
        enableWindows = config.get("Dungeon Generation", "[Boss Dungeon] Whether boss dungeons are allowed to have windows or not", true).getBoolean(true);
        enableBossDungeons = config.get("Dungeon Generation", "[Boss Dungeon] Enable Boss Dungeon generation", true).getBoolean(true);
        randomizeBossDungeons = config.get("Dungeon Generation", "[Boss Dungeon] Ignore biome settings and randomize boss dungeon / boss key locations", false).getBoolean(false);
        mainDungeonDifficulty = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Overworld] Adjust secret rooms so they are more hidden [1 = less, 3 = most]", 2).getInt(), (int)1, (int)3);
        secretRoomChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Overworld] Chance (as a percent) per iteration of secret room generating [1-100]", 80).getInt(), (int)1, (int)100);
        minLandDistance = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Overworld] Minimum number of blocks between land-based secret rooms [2-16]", 6).getInt(), (int)2, (int)16);
        minOceanDistance = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Overworld] Minimum number of blocks between ocean-based secret rooms [2-32]", 6).getInt(), (int)2, (int)32);
        minBossDistance = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Overworld] Minimum number of chunks between Boss Dungeons [8-128]", 24).getInt(), (int)8, (int)128);
        genAttemptsPerChunk = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Overworld] Secret room generation attempts per chunk (0 to disable) [0-20]", 12).getInt(), (int)0, (int)20);
        netherDungeonDifficulty = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Nether] Adjust secret rooms so they are more hidden [1 = less, 3 = most]", 2).getInt(), (int)1, (int)3);
        secretRoomChanceNether = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Nether] Chance (as a percent) per iteration of secret room generating [1-100]", 80).getInt(), (int)1, (int)100);
        minDistanceNether = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Nether] Minimum number of blocks between land-based secret rooms [2-16]", 6).getInt(), (int)2, (int)16);
        minBossDistanceNether = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Nether] Minimum number of chunks between Boss Dungeons [8-64]", 12).getInt(), (int)8, (int)64);
        genAttemptsPerChunkNether = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[Nether] Secret room generation attempts per chunk (0 to disable) [0-20]", 12).getInt(), (int)0, (int)20);
        fairySpawnerChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Dungeon Generation", "Chance (as a percent) for certain dungeons to have fairy spawners [0-100]", 10).getInt(), (int)0, (int)100);
        resetSpawnerTime = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "Maximum number of days required for fairies to replenish [2-10]", 7).getInt(), (int)2, (int)10);
        disableStructureGen = config.get("Dungeon Generation", "[No-Gen] Disable structure and feature generation entirely within a specified zone", false).getBoolean(false);
        noGenX = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[No-Gen] Starting chunk coordinate X for the structure free zone [max is +/- 1875000]", 0).getInt(), (int)-1875000, (int)1875000);
        noGenZ = MathHelper.func_76125_a((int)config.get("Dungeon Generation", "[No-Gen] Starting chunk coordinate Z for the structure free zone [max is +/- 1875000]", 0).getInt(), (int)-1875000, (int)1875000);
        ancientTabletGenChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("WorldGen", "[Ancient Tablet] Chance that a random tablet will spawn when a boss dungeon is defeated [0-100]", 20).getInt(), (int)0, (int)100);
        enableBombFlowerGen = config.get("WorldGen", "[Bomb Flowers] Enable bomb flower generation", true).getBoolean(true);
        allowJarsInWater = config.get("WorldGen", "[Ceramic Jars][Surface] Allow ceramic jars to generate in water", true).getBoolean(true);
        jarGenChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Surface] Chance of generating a jar cluster in a given chunk [0-100]", 50).getInt(), (int)0, (int)100);
        jarsPerCluster = MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Surface] Max number of jars per jar cluster [2-20]", 8).getInt(), (int)2, (int)20);
        jarGenChanceSub = 0.01f * (float)MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Underground] Chance for each jar cluster to generate [0-100]", 65).getInt(), (int)0, (int)100);
        jarsPerClusterSub = MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Underground] Max number of jars per cluster [2-20]", 8).getInt(), (int)2, (int)20);
        jarClustersPerChunkSub = MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Underground] Max number of jar clusters per chunk [1-20]", 10).getInt(), (int)1, (int)20);
        jarGenChanceNether = 0.01f * (float)MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Nether] Chance for each jar cluster to generate [0-100]", 50).getInt(), (int)0, (int)100);
        jarsPerClusterNether = MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Nether] Max number of jars per cluster [2-20]", 8).getInt(), (int)2, (int)20);
        jarClustersPerChunkNether = MathHelper.func_76125_a((int)config.get("WorldGen", "[Ceramic Jars][Nether] Max number of jar clusters per chunk [1-20]", 8).getInt(), (int)1, (int)20);
        gossipStoneRate = 1.0E-4f * (float)MathHelper.func_76125_a((int)config.get("WorldGen", "[Gossip Stones] Chance per chunk of a Gossip Stone generating (100 = 1% chance)[0-500]", 50).getInt(), (int)0, (int)500);
        enablePillarGen = config.get("WorldGen", "[Song Pillars] Enable song and broken pillar generation", true).getBoolean(true);
        maxPillarRange = MathHelper.func_76125_a((int)config.get("WorldGen", "[Song Pillars] Maximum search range; reduce if new chunks are loading too slowly [16-64]", 64).getInt(), (int)16, (int)64);
        minBrokenPillarDistance = MathHelper.func_76125_a((int)config.get("WorldGen", "[Song Pillars] Minimum number of chunks between broken pillars [4-128]", 32).getInt(), (int)4, (int)128);
        minSongPillarDistance = MathHelper.func_76125_a((int)config.get("WorldGen", "[Song Pillars] Minimum number of chunks between song pillars [8-128]", 64).getInt(), (int)8, (int)128);
        masterSwordChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Loot", "Chance (as a percent) of a Forest Temple containing a Master Sword [1-100]", 33).getInt(), (int)1, (int)100);
        lockedChestChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Loot", "Chance (as a percent) a chest will be locked [10-50]", 33).getInt(), (int)10, (int)50);
        doubleChestChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Loot", "Chance (as a percent) a secret room may have two chests [0-25]", 10).getInt(), (int)0, (int)25);
        barredRoomChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Loot", "Chance that a secret room's entrance will be barred by some obstacle [1-50]", 25).getInt(), (int)1, (int)50);
        heartPieceChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Loot", "Chance (as a percent) of a heart piece generating in secret room chests [0-100]", 15).getInt(), (int)0, (int)100);
        randomBossItemChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Loot", "Chance (as a percent) of a random boss-level item being added to locked chest loot table [0-50]", 25).getInt(), (int)0, (int)50);
        minNumChestItems = MathHelper.func_76125_a((int)config.get("Loot", "Minimum number of random chest contents for first chest [1-10]", 4).getInt(), (int)1, (int)10);
        bombWeight = MathHelper.func_76125_a((int)config.get("Loot", "Weight: Bomb [1-10]", 5).getInt(), (int)1, (int)10);
        bombBagWeight = MathHelper.func_76125_a((int)config.get("Loot", "Weight: Bomb Bag (locked chest weight only) [1-10]", 3).getInt(), (int)1, (int)10);
        heartPieceWeight = MathHelper.func_76125_a((int)config.get("Loot", "Weight: Heart Piece (vanilla chests only) [1-10]", 1).getInt(), (int)1, (int)10);
        bigKeyWeight = MathHelper.func_76125_a((int)config.get("Loot", "Weight: Key, Big [1-10]", 4).getInt(), (int)1, (int)10);
        smallKeyWeight = MathHelper.func_76125_a((int)config.get("Loot", "Weight: Key, Small [1-10]", 4).getInt(), (int)1, (int)10);
        lockedLootWeight = MathHelper.func_76125_a((int)config.get("Loot", "Weight: Locked Chest Content [1-10]", 3).getInt(), (int)1, (int)10);
        grassDropChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "Chance (as a percent) of loot dropping from grass [0-100]", 15).getInt(), (int)0, (int)100);
        jarDropChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "Chance (as a percent) of loot dropping from empty jars when broken [0-100]", 20).getInt(), (int)0, (int)100);
        creeperDrop = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "Chance (as a percent) for creepers to drop bombs [0-100]", 10).getInt(), (int)0, (int)100);
        mobConsumableFrequency = MathHelper.func_76125_a((int)config.get("Drops", "Frequency of small heart and magic jar drops from mobs [zero to disable; 1 = rare, 10 = very common]", 5).getInt(), (int)0, (int)10);
        enableOrbDrops = config.get("Drops", "[Skill Orbs] Enable skill orbs to drop as loot from mobs", true).getBoolean(true);
        randomDropChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "[Skill Orbs] Chance (as a percent) for specified mobs to drop a random orb [0-100]", 10).getInt(), (int)0, (int)100);
        genericMobDropChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "[Skill Orbs] Chance (as a percent) for random mobs to drop a random orb [0-100]", 1).getInt(), (int)0, (int)100);
        orbDropChance = new HashMap<Byte, Float>(SkillBase.getNumSkills());
        for (SkillBase skill : SkillBase.getSkills()) {
            if (skill.canDrop()) {
                int i = MathHelper.func_76125_a((int)config.get("drops", "Chance (in tenths of a percent) for " + skill.getDisplayName() + " (0 to disable) [0-10]", 5).getInt(), (int)0, (int)10);
                orbDropChance.put(skill.getId(), Float.valueOf(0.001f * (float)i));
            }
            if (!skill.isLoot() || !config.get("Loot", "[Skill Orbs] Whether " + skill.getDisplayName() + " orbs may appear as random loot, such as in Boss chests", true).getBoolean(true)) continue;
            lootableOrbs.add(skill.getId());
        }
        powerDropRate = Math.max(config.get("Drops", "[Piece of Power] Approximate number of enemies you need to kill before a piece of power drops [minimum 20]", 50).getInt(), 20);
        vanillaWhipLootChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "[Whip] Chance that loot may be snatched from various vanilla mobs, using a whip (0 to disable)[0-100]", 15).getInt(), (int)0, (int)100);
        globalWhipLootChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Drops", "[Whip] All whip-stealing chances are multiplied by this value, as a percentage, including any added by other mods (0 disables ALL whip stealing!)[0-500]", 100).getInt(), (int)0, (int)500);
        hurtOnSteal = config.get("Drops", "[Whip] Whether to inflict damage to entities when stealing an item (IEntityLootable entities determine this separately)", true).getBoolean(true);
        friendTradesRequired = Math.max(config.get("Trade", "Number of unlocked trades required before a villager considers you 'friend' [3+]", 6).getInt(), 3);
        enableTradeBombBag = config.get("Trade", "[Bomb Bag] Allow Barnes to sell bomb bags (checked each time Barnes is shown a bomb)", true).getBoolean(true);
        bombBagPrice = MathHelper.func_76125_a((int)config.get("Trade", "[Bomb Bag] Cost of a bomb bag at Barnes' shop (only applied to new trades) [32-64]", 64).getInt(), (int)32, (int)64);
        enableTradeBomb = config.get("Trade", "[Bombs] Enable random villager trades for bombs", true).getBoolean(true);
        enableArrowTrades = config.get("Trade", "[Hero's Bow] Whether magic arrows (fire, ice, light) can be purchased", true).getBoolean(true);
        maskBuyChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Trade", "[Masks] Chance that a villager will be interested in purchasing a random mask [1-50]", 15).getInt(), (int)1, (int)50);
        config.addCustomCategoryComment("Mob Spawns", "Mobs use the 'Biome Type' lists to populate their individual spawn settings the first time the game is loaded.\nChanging the type lists after this point has no effect UNLESS you also delete the mob spawn locations in the\nconfig - this will force them to re-populate the next time the game is loaded.\nAlternatively, you may add new biomes directly to the individual mob spawn entries and completely ignore biome type.");
        roomSpawnMobChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Mob Spawns", "Chance that a random mob will spawn inside of secret rooms (0 to disable) [0-100]", 25).getInt(), (int)0, (int)100);
        mobVariantChance = 0.01f * (float)MathHelper.func_76125_a((int)config.get("Mob Spawns", "Chance that mobs with subtypes spawn with a random variation instead of being determined solely by BiomeType [0-100]", 20).getInt(), (int)0, (int)100);
        minDaysToSpawnDarknut = 24000 * MathHelper.func_76125_a((int)config.get("Mob Spawns", "Minimum number of days required to pass before Darknuts may spawn [0-30]", 7).getInt(), (int)0, (int)30);
        minDaysToSpawnWizzrobe = 24000 * MathHelper.func_76125_a((int)config.get("Mob Spawns", "Minimum number of days required to pass before Wizzrobes may spawn [0-30]", 7).getInt(), (int)0, (int)30);
        config.addCustomCategoryComment("Map Making", "Configuration settings related to map making; none of these have any impact on normal play.");
        config.save();
    }

    public static void postInit() {
        String[] warp_locations;
        WeaponRegistry.INSTANCE.registerItems(swords, "Config", true);
        WeaponRegistry.INSTANCE.registerItems(weapons, "Config", false);
        WeaponRegistry.INSTANCE.forbidItems(forbidden_swords, "Config", true);
        WeaponRegistry.INSTANCE.forbidItems(forbidden_weapons, "Config", false);
        BiomeType.postInit(config);
        BossType.postInit(config);
        ZSSEntities.postInit(config);
        minSongIntervalStorm = MathHelper.func_76125_a((int)config.get("Songs", "[Song of Storms] Time required between each use of the song (by anybody) [0-24000]", 600).getInt(), (int)0, (int)24000);
        minSongIntervalSun = MathHelper.func_76125_a((int)config.get("Songs", "[Sun's Song] Time required between each use of the song (by anybody) [0-24000]", 1200).getInt(), (int)0, (int)24000);
        for (AbstractZeldaSong song : ZeldaSongs.getRegisteredSongs()) {
            if (config.get("Songs", "Whether " + song.getDisplayName() + "'s main effect is enabled (does not affect notification of Song Blocks or Entities)", true).getBoolean(true)) continue;
            song.setIsEnabled(false);
        }
        for (String entry : warp_locations = config.get("Map Making", WARP_LOCATIONS_KEY, new String[0]).getStringList()) {
            String[] split = entry.split(":");
            if (split.length != 2) {
                ZSSMain.logger.warn("Invalid default warp location entry: " + entry);
                continue;
            }
            AbstractZeldaSong song = ZeldaSongs.getSongByName(split[0]);
            WarpPoint warp = WarpPoint.fromString(split[1]);
            if (song == null) {
                ZSSMain.logger.warn("Default warp location entry contained invalid song name: " + split[0]);
                continue;
            }
            if (warp == null) {
                ZSSMain.logger.warn("Default warp location entry contained invalid warp point entry: " + split[1] + "\nExpected format is [dimension_id, x, y, z]");
                continue;
            }
            warp_defaults.put(song, warp);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int getHitsToDisplay() {
        return hitsToDisplay;
    }

    public static boolean toggleAutoTarget() {
        enableAutoTarget = !enableAutoTarget;
        return enableAutoTarget;
    }

    public static boolean toggleTargetPlayers() {
        canTargetPlayers = !canTargetPlayers;
        return canTargetPlayers;
    }

    public static int getNoteResetInterval() {
        return resetNotesInterval;
    }

    public static boolean allowOffhandMaster() {
        return enableOffhandMaster;
    }

    public static boolean canPlayersBeStunned() {
        return enableStunPlayer;
    }

    public static boolean affectAllSwings() {
        return enableSwingSpeed;
    }

    public static int getBaseSwingSpeed() {
        return baseSwingSpeed;
    }

    public static boolean canLiftSecretStone() {
        return enableSecretStoneLift;
    }

    public static boolean canLiftVanilla() {
        return enableVanillaLift;
    }

    public static boolean canSmashVanilla() {
        return enableVanillaSmash;
    }

    public static boolean alwaysPickupHearts() {
        return alwaysPickupHearts;
    }

    public static boolean isHardcoreZeldaFan() {
        return enableHardcoreZeldaFanMode;
    }

    public static float getBossHealthFactor() {
        return bossHealthFactor;
    }

    public static int getNumBosses() {
        return bossNumber;
    }

    public static boolean doJarsUpdate() {
        return enableJarUpdates;
    }

    public static int getSacredFlameRefreshRate() {
        return sacredRefreshRate;
    }

    public static int getSkulltulaRewardRate() {
        return skulltulaRewardRate;
    }

    public static boolean areVanillaBuffsDisabled() {
        return disableVanillaBuffs;
    }

    public static boolean areNpcsInvulnerable() {
        return npcsAreInvulnerable;
    }

    public static int getNaviRange() {
        return naviRange;
    }

    public static int getNaviFrequency() {
        return naviFrequency;
    }

    public static float getKeeseCursedChance() {
        return keeseCursedChance;
    }

    public static float getKeeseSwarmChance() {
        return keeseSwarmChance;
    }

    public static int getKeeseSwarmSize() {
        return keeseSwarmSize;
    }

    public static boolean getArrowsConsumeFlame() {
        return arrowsConsumeFlame;
    }

    public static boolean onlyBombSecretStone() {
        return onlyBombSecretStone;
    }

    public static boolean canGriefAdventure() {
        return bombsGriefAdventure;
    }

    public static int getBombFuseTime() {
        return bombFuseTime;
    }

    public static boolean canDekuDenude() {
        return enableDekuDenude;
    }

    public static boolean isDinIgniteEnabled() {
        return enableDinIgnite;
    }

    public static boolean isDinMeltEnabled() {
        return enableDinMelt;
    }

    public static boolean areUnenchantablesDisabled() {
        return disableAllUnenchantables;
    }

    public static boolean allowMegaSmashQuakeStone() {
        return enableMegaSmashQuake;
    }

    public static int getHeroBowUpgradeCost() {
        return heroBowUpgradeCost;
    }

    public static boolean enableFireArrowIgnite() {
        return enableFireArrowIgnite;
    }

    public static boolean enableFireArrowMelt() {
        return enableFireArrowMelt;
    }

    public static boolean enableLightArrowNoClip() {
        return enableLightArrowNoClip;
    }

    public static boolean enableAutoBombArrows() {
        return enableAutoBombArrows;
    }

    public static int getHookshotRange() {
        return hookshotRange;
    }

    public static boolean allowHookableOnly() {
        return enableHookableOnly;
    }

    public static boolean canHookshotBreakBlocks() {
        return enableHookshotBreakBlocks;
    }

    public static boolean doMedallionsDamagePlayers() {
        return medallionsAffectPlayers;
    }

    public static int getRodUpgradeCost() {
        return rodUpgradeCost;
    }

    public static int getRequiredKills() {
        return temperedRequiredKills - 1;
    }

    public static boolean getMasterSwordsProvidePower() {
        return allMasterSwordsProvidePower;
    }

    public static int getNumSkelKeyUses() {
        return numSkelKeyUses;
    }

    public static int getSlingshotCostOne() {
        return slingshotUpgradeOne;
    }

    public static int getSlingshotCostTwo() {
        return slingshotUpgradeTwo;
    }

    public static int getWhipRange() {
        return whipRange;
    }

    public static byte getMaxBonusHearts() {
        return (byte)maxBonusHearts;
    }

    public static boolean canDisarmorPlayers() {
        return allowDisarmorPlayer;
    }

    public static float getDisarmPenalty() {
        return disarmPenalty;
    }

    public static float getDisarmTimingBonus() {
        return disarmTimingBonus;
    }

    public static boolean allowUnlimitedNayru() {
        return allowUnlimitedNayru;
    }

    public static int getMaxMagicPoints() {
        return maxMagicPoints;
    }

    public static float getHealthAllowance(int level) {
        return requireFullHealth ? 0.0f : 0.6f * (float)level;
    }

    public static int getMinIntervalStorm() {
        return minSongIntervalStorm;
    }

    public static int getMinIntervalSun() {
        return minSongIntervalSun;
    }

    public static boolean avoidModBlocks() {
        return avoidModBlocks;
    }

    public static boolean areWindowsEnabled() {
        return enableWindows;
    }

    public static boolean areBossDungeonsEnabled() {
        return enableBossDungeons;
    }

    public static boolean areBossDungeonsRandom() {
        return randomizeBossDungeons;
    }

    public static int getMinBossDistance() {
        return minBossDistance;
    }

    public static int getMinLandDistance() {
        return minLandDistance;
    }

    public static int getMinOceanDistance() {
        return minOceanDistance;
    }

    public static int getAttemptsPerChunk() {
        return genAttemptsPerChunk;
    }

    public static float getSecretRoomChance() {
        return secretRoomChance;
    }

    public static int getMainDungeonDifficulty() {
        return mainDungeonDifficulty;
    }

    public static int getNetherMinBossDistance() {
        return minBossDistanceNether;
    }

    public static int getNetherMinDistance() {
        return minDistanceNether;
    }

    public static int getNetherAttemptsPerChunk() {
        return genAttemptsPerChunkNether;
    }

    public static float getNetherSecretRoomChance() {
        return secretRoomChanceNether;
    }

    public static int getNetherDungeonDifficulty() {
        return netherDungeonDifficulty;
    }

    public static float getFairySpawnerChance() {
        return fairySpawnerChance;
    }

    public static int getDaysToRespawn() {
        return resetSpawnerTime;
    }

    public static boolean isGenEnabledAt(int chunkX, int chunkZ) {
        if (disableStructureGen) {
            return chunkX < noGenX || chunkZ < noGenZ;
        }
        return true;
    }

    public static float getAncientTabletGenChance() {
        return ancientTabletGenChance;
    }

    public static int getAncientTabletGenDistance() {
        return ancientTabletGenDistance;
    }

    public static boolean doBombFlowerGen() {
        return enableBombFlowerGen;
    }

    public static boolean genJarsInWater() {
        return allowJarsInWater;
    }

    public static float getJarGenChance() {
        return jarGenChance;
    }

    public static int getJarsPerCluster() {
        return jarsPerCluster;
    }

    public static float getJarGenChanceSub() {
        return jarGenChanceSub;
    }

    public static int getJarClustersPerChunkSub() {
        return jarClustersPerChunkSub;
    }

    public static int getJarsPerClusterSub() {
        return jarsPerClusterSub;
    }

    public static float getJarGenChanceNether() {
        return jarGenChanceNether;
    }

    public static int getJarClustersPerChunkNether() {
        return jarClustersPerChunkNether;
    }

    public static int getJarsPerClusterNether() {
        return jarsPerClusterNether;
    }

    public static float getGossipStoneRate() {
        return gossipStoneRate;
    }

    public static boolean doPillarGen() {
        return enablePillarGen;
    }

    public static int getPillarRange() {
        return maxPillarRange;
    }

    public static int getBrokenPillarMin() {
        return minBrokenPillarDistance;
    }

    public static int getSongPillarMin() {
        return minSongPillarDistance;
    }

    public static float getMasterSwordChance() {
        return masterSwordChance;
    }

    public static float getLockedChestChance() {
        return lockedChestChance;
    }

    public static float getDoubleChestChance() {
        return doubleChestChance;
    }

    public static float getBarredRoomChance() {
        return barredRoomChance;
    }

    public static float getHeartPieceChance() {
        return heartPieceChance;
    }

    public static float getRandomBossItemChance() {
        return randomBossItemChance;
    }

    public static int getMinNumItems() {
        return minNumChestItems;
    }

    public static int getBombWeight() {
        return bombWeight;
    }

    public static int getBombBagWeight() {
        return bombBagWeight;
    }

    public static int getHeartWeight() {
        return heartPieceWeight;
    }

    public static int getBigKeyWeight() {
        return bigKeyWeight;
    }

    public static int getSmallKeyWeight() {
        return smallKeyWeight;
    }

    public static int getLockedLootWeight() {
        return lockedLootWeight;
    }

    public static boolean isLootableSkill(SkillBase skill) {
        return lootableOrbs.contains(skill.getId());
    }

    public static float getGrassDropChance() {
        return grassDropChance;
    }

    public static float getJarDropChance() {
        return jarDropChance;
    }

    public static float getCreeperDropChance() {
        return creeperDrop;
    }

    public static int getMobConsumableFrequency() {
        return mobConsumableFrequency;
    }

    public static boolean areOrbDropsEnabled() {
        return enableOrbDrops;
    }

    public static float getChanceForRandomDrop() {
        return randomDropChance;
    }

    public static float getRandomMobDropChance() {
        return genericMobDropChance;
    }

    public static float getDropChance(int orbID) {
        return orbDropChance.containsKey((byte)orbID) ? orbDropChance.get((byte)orbID).floatValue() : 0.0f;
    }

    public static int getPowerDropRate() {
        return powerDropRate;
    }

    public static float getVanillaWhipLootChance() {
        return vanillaWhipLootChance;
    }

    public static float getWhipLootMultiplier() {
        return globalWhipLootChance;
    }

    public static boolean getHurtOnSteal() {
        return hurtOnSteal;
    }

    public static boolean enableTradeBomb() {
        return enableTradeBomb;
    }

    public static boolean enableTradeBombBag() {
        return enableTradeBombBag;
    }

    public static int getBombBagPrice() {
        return bombBagPrice;
    }

    public static boolean areArrowTradesEnabled() {
        return enableArrowTrades;
    }

    public static float getMaskBuyChance() {
        return maskBuyChance;
    }

    public static int getFriendTradesRequired() {
        return friendTradesRequired;
    }

    public static float getRoomSpawnMobChance() {
        return roomSpawnMobChance;
    }

    public static boolean areMobVariantsAllowed() {
        return mobVariantChance > 0.0f;
    }

    public static float getMobVariantChance() {
        return mobVariantChance;
    }

    public static int getTimeToSpawnDarknut() {
        return minDaysToSpawnDarknut;
    }

    public static int getTimeToSpawnWizzrobe() {
        return minDaysToSpawnWizzrobe;
    }

    public static WarpPoint getDefaultWarpPoint(AbstractZeldaSong song) {
        return warp_defaults.get(song);
    }

    public static WarpPoint setDefaultWarpPoint(AbstractZeldaSong song, WarpPoint warp) {
        Integer meta = BlockWarpStone.reverseLookup.get(song);
        if (meta != null) {
            WarpPoint previous = warp_defaults.put(song, warp);
            if (warp.equals(previous)) {
                return null;
            }
            Config.saveDefaultWarpPoints();
            return previous;
        }
        ZSSMain.logger.warn("Attempted to set default warp point for non-warp song: " + song.getDisplayName());
        return null;
    }

    private static void saveDefaultWarpPoints() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<AbstractZeldaSong, WarpPoint> entry : warp_defaults.entrySet()) {
            builder.append(entry.getKey().getUnlocalizedName()).append(":").append(entry.getValue().toString()).append("\n");
        }
        Property prop = config.get("Map Making", WARP_LOCATIONS_KEY, new String[0]);
        prop.set(builder.toString().split("\n"));
        config.getCategory("Map Making").put(WARP_LOCATIONS_KEY, prop);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void syncClientSettings(SyncConfigPacket msg) {
        if (!msg.isMessageValid()) {
            ZSSMain.logger.error("Invalid SyncConfigPacket attempting to process!");
            return;
        }
        enableOffhandMaster = msg.enableOffhandMaster;
        enableStunPlayer = msg.enableStunPlayer;
        enableSwingSpeed = msg.enableSwingSpeed;
        enableSecretStoneLift = msg.enableSecretStoneLift;
        enableVanillaLift = msg.enableVanillaLift;
        enableVanillaSmash = msg.enableVanillaSmash;
        disableAllUnenchantables = msg.disableAllUnenchantables;
        enableHookableOnly = msg.enableHookableOnly;
        requireFullHealth = msg.requireFullHealth;
        baseSwingSpeed = msg.baseSwingSpeed;
        bombFuseTime = msg.bombFuseTime;
        hookshotRange = msg.hookshotRange;
        whipRange = msg.whipRange;
        allMasterSwordsProvidePower = msg.allMasterSwordsProvidePower;
    }

    static {
        swords = new String[0];
        weapons = new String[0];
        forbidden_swords = new String[0];
        forbidden_weapons = new String[0];
        lootableOrbs = new HashSet<Byte>();
        warp_defaults = new HashMap<AbstractZeldaSong, WarpPoint>();
    }
}

