/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.network.server;

import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.MovingObjectPosition;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.network.AbstractMessage;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Dash;

public class DashImpactPacket
extends AbstractMessage.AbstractServerMessage<DashImpactPacket> {
    private byte hitType;
    private int entityId;

    public DashImpactPacket() {
    }

    public DashImpactPacket(EntityPlayer player, MovingObjectPosition mop) {
        this.hitType = (byte)mop.field_72313_a.ordinal();
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            this.entityId = mop.field_72308_g.func_145782_y();
        }
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.hitType = buffer.readByte();
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            this.entityId = buffer.readInt();
        }
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeByte((int)this.hitType);
        if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
            buffer.writeInt(this.entityId);
        }
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        Dash dash = (Dash)ZSSPlayerSkills.get(player).getActiveSkill(SkillBase.dash);
        if (dash != null && dash.isActive()) {
            MovingObjectPosition mop = null;
            if (this.hitType == MovingObjectPosition.MovingObjectType.ENTITY.ordinal()) {
                Entity entityHit = player.field_70170_p.func_73045_a(this.entityId);
                if (entityHit != null) {
                    mop = new MovingObjectPosition(entityHit);
                } else {
                    ZSSMain.logger.warn("Could not retrieve valid entity for MovingObjectPosition while handling Dash Packet!");
                }
            }
            dash.onImpact(player.field_70170_p, player, mop);
        }
    }
}

