/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import zeldaswordskills.api.block.IQuakeBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.block.BlockAncientTablet;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.EntityEtherLightning;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ISpawnParticles;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.PacketISpawnParticles;
import zeldaswordskills.ref.Config;

public class ItemMedallion
extends Item
implements ISpawnParticles {
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public ItemMedallion() {
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "_" + BlockAncientTablet.EnumType.byMetadata(stack.func_77960_j()).getName();
    }

    public int func_77626_a(ItemStack stack) {
        return BlockAncientTablet.EnumType.byMetadata(stack.func_77960_j()).getItemUseDuration();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int requiredTicks = this.func_77626_a(stack);
        if (requiredTicks > 0) {
            player.func_71008_a(stack, requiredTicks);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 4 == 0) {
            for (int i = 0; i < 4; ++i) {
                player.field_70170_p.func_72869_a("witchMagic", player.field_70165_t + player.field_70170_p.field_73012_v.nextGaussian() * 0.13, player.field_70163_u + (double)(player.field_70131_O / 2.0f) + player.field_70170_p.field_73012_v.nextGaussian() * 0.13, player.field_70161_v + player.field_70170_p.field_73012_v.nextGaussian() * 0.13, 0.0, 0.0, 0.0);
            }
        }
        if (count % 10 == 0) {
            // empty if block
        }
        if (count == 1) {
            if (!ZSSPlayerInfo.get(player).useMagic(40.0f)) {
                player.func_85030_a("zeldaswordskills:magic_failure", 1.0f, 1.0f);
            } else if (!player.field_70170_p.field_72995_K) {
                this.onItemUseFinish(stack, player.field_70170_p, player);
            }
        }
    }

    private void onItemUseFinish(ItemStack stack, World world, EntityPlayer player) {
        BlockAncientTablet.EnumType type = BlockAncientTablet.EnumType.byMetadata(stack.func_77960_j());
        switch (type) {
            case ETHER: {
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + world.field_73012_v.nextFloat() * 0.2f);
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "random.explode", 2.0f, 0.5f + world.field_73012_v.nextFloat() * 0.2f);
                this.affectEntities(world, player, type, 8.0f);
                if (!(world instanceof WorldServer) || !world.func_72896_J() && !world.func_72911_I()) break;
                WorldInfo worldinfo = ((WorldServer)world).func_72912_H();
                worldinfo.func_76084_b(false);
                worldinfo.func_76080_g(0);
                worldinfo.func_76069_a(false);
                worldinfo.func_76090_f(0);
                break;
            }
            case QUAKE: {
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                PacketDispatcher.sendToAllAround(new PacketISpawnParticles(player, 8.0f), (Entity)player, 64.0);
                this.affectBlocks(world, player, type, 8.0f);
                this.affectEntities(world, player, type, 8.0f);
                break;
            }
        }
    }

    private void affectEntities(World world, EntityPlayer player, BlockAncientTablet.EnumType type, float radius) {
        List list = world.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b((double)radius, (double)radius, (double)radius));
        block4: for (EntityLivingBase entity : list) {
            if (!this.canAffectEntity(player, entity)) continue;
            switch (type) {
                case ETHER: {
                    if (world.field_72995_K) break;
                    world.func_72942_c((Entity)new EntityEtherLightning(world, (EntityLivingBase)player, entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
                    break;
                }
                case QUAKE: {
                    if (!entity.field_70122_E) break;
                    if (world.field_72995_K) {
                        for (int i = 0; i < 4; ++i) {
                            world.func_72869_a("explode", entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v, 0.0, 0.0, 0.0);
                        }
                        continue block4;
                    }
                    int duration = world.field_73012_v.nextInt(20) + world.field_73012_v.nextInt(20) + 20;
                    DamageSource quakeSource = new DamageUtils.DamageSourceQuakeIndirect("quake", null, (Entity)player, duration, 0).func_82726_p().func_76348_h();
                    entity.func_70097_a(quakeSource, 10.0f);
                    world.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    private boolean canAffectEntity(EntityPlayer player, EntityLivingBase target) {
        if (target instanceof IMob || target instanceof EntityPlayer && Config.doMedallionsDamagePlayers()) {
            return target != player && !target.func_142014_c((EntityLivingBase)player);
        }
        return false;
    }

    private void affectBlocks(World world, EntityPlayer player, BlockAncientTablet.EnumType type, float radius) {
        if (type != BlockAncientTablet.EnumType.QUAKE) {
            return;
        }
        int r = MathHelper.func_76123_f((float)radius);
        int ry = Math.max(1, r / 2);
        int dx = MathHelper.func_76128_c((double)player.field_70165_t);
        int dy = MathHelper.func_76128_c((double)player.field_70163_u);
        int dz = MathHelper.func_76128_c((double)player.field_70161_v);
        for (int i = 0; i <= r; ++i) {
            for (int j = -ry; j <= ry; ++j) {
                for (int k = 0; k <= r; ++k) {
                    this.affectBlockAt(world, player, dx + i, dy + j, dz + k);
                    this.affectBlockAt(world, player, dx + i, dy + j, dz - k);
                    this.affectBlockAt(world, player, dx - i, dy + j, dz + k);
                    this.affectBlockAt(world, player, dx - i, dy + j, dz - k);
                }
            }
        }
    }

    private void affectBlockAt(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K) {
            this.spawnParticlesAt(world, x, y, z);
        } else {
            Block block = world.func_147439_a(x, y, z);
            if (block instanceof IQuakeBlock) {
                ((IQuakeBlock)block).handleQuakeEffect(world, x, y, z, player);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, EntityPlayer player, ItemStack stack, double x, double y, double z, float r) {
        if (stack.func_77960_j() != BlockAncientTablet.EnumType.QUAKE.ordinal()) {
            return;
        }
        this.affectBlocks(world, player, BlockAncientTablet.EnumType.QUAKE, r);
        this.affectEntities(world, player, BlockAncientTablet.EnumType.QUAKE, r);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticlesAt(World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z)) {
            return;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        if (block.func_149688_o() != Material.field_151579_a) {
            String particle = "blockcrack_" + Block.func_149682_b((Block)block) + "_" + world.func_72805_g(x, y - 1, z);
            for (int n = 0; n < 4; ++n) {
                double dx = (float)x + world.field_73012_v.nextFloat() - 0.5f;
                double dy = (float)y + world.field_73012_v.nextFloat() * 0.2f;
                double dz = (float)z + world.field_73012_v.nextFloat() - 0.5f;
                world.func_72869_a(particle, dx, dy, dz, world.field_73012_v.nextGaussian(), 0.0, world.field_73012_v.nextGaussian());
            }
            if (world.field_73012_v.nextInt(8) == 0) {
                world.func_72908_a((double)x, (double)y, (double)z, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (BlockAncientTablet.EnumType type : BlockAncientTablet.EnumType.values()) {
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.icons.get(damage % this.icons.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new ArrayList<IIcon>(BlockAncientTablet.EnumType.values().length);
        for (BlockAncientTablet.EnumType type : BlockAncientTablet.EnumType.values()) {
            this.icons.add(register.func_94245_a("zeldaswordskills:medallion_" + type.getName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isHeld) {
        BlockAncientTablet.EnumType type = BlockAncientTablet.EnumType.byMetadata(stack.func_77960_j());
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip.zss.medallion" + type.getName() + ".desc.0")));
    }
}

