/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.ISongTeacher;
import zeldaswordskills.api.item.IRightClickEntity;
import zeldaswordskills.block.BlockSongInscription;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;

public class ItemInstrument
extends Item
implements IRightClickEntity {
    private static final Map<Class<? extends EntityLiving>, Map<String, AbstractZeldaSong>> teachersForClass = new HashMap<Class<? extends EntityLiving>, Map<String, AbstractZeldaSong>>();
    @SideOnly(value=Side.CLIENT)
    private List<IIcon> icons;

    public ItemInstrument() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("zss.instrument");
        this.func_77637_a(ZSSCreativeTabs.tabMisc);
    }

    public Instrument getInstrument(ItemStack stack) {
        return Instrument.values()[stack.func_77960_j() % Instrument.values().length];
    }

    public int getSongStrength(ItemStack stack) {
        return this.getInstrument(stack).getPower();
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (this.getInstrument(stack) == Instrument.OCARINA_FAIRY) {
            player.func_71029_a((StatBase)ZSSAchievements.ocarinaCraft);
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        return block instanceof BlockWarpStone || block instanceof BlockSongInscription;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            ZSSPlayerSongs songs = ZSSPlayerSongs.get(player);
            if (songs.preventSongGui) {
                songs.preventSongGui = false;
            } else if (songs.songToLearn != null) {
                player.openGui((Object)ZSSMain.instance, 5, player.field_70170_p, 0, 0, 0);
            } else {
                player.openGui((Object)ZSSMain.instance, this.getInstrument(stack).getGuiId(), world, 0, 0, 0);
            }
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            if (this.isScarecrowAt(world, x, y, z) && ZSSPlayerSongs.get(player).canOpenScarecrowGui(true)) {
                player.openGui((Object)ZSSMain.instance, 4, world, x, y, z);
            } else {
                player.openGui((Object)ZSSMain.instance, this.getInstrument(stack).getGuiId(), world, x, y, z);
            }
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return true;
    }

    @Override
    public boolean onRightClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityLiving) {
            return this.handleRightClickEntity(stack, player, (EntityLiving)entity);
        }
        return false;
    }

    private boolean handleRightClickEntity(ItemStack stack, EntityPlayer player, EntityLiving entity) {
        ISongTeacher.TeachingResult result = null;
        if (entity instanceof ISongTeacher) {
            result = ((ISongTeacher)entity).getTeachingResult(stack, player);
        } else if (!player.func_70093_af() && entity.func_94056_bM() && teachersForClass.containsKey(entity.getClass())) {
            Map<String, AbstractZeldaSong> teacherSongs = teachersForClass.get(entity.getClass());
            result = new ISongTeacher.TeachingResult(teacherSongs.get(entity.func_94057_bL()), true, true);
        }
        if (result != null) {
            if (player.field_70170_p.field_72995_K && result.songToLearn != null) {
                ZSSPlayerSongs.get((EntityPlayer)player).songToLearn = result.songToLearn;
                if (result.displayChat) {
                    if (ZSSPlayerSongs.get(player).isSongKnown(result.songToLearn)) {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.ocarina.review", new ChatComponentTranslation(result.songToLearn.getTranslationString(), new Object[0]));
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.ocarina.learn", new ChatComponentTranslation(result.songToLearn.getTranslationString(), new Object[0]));
                    }
                }
            }
            return result.cancel;
        }
        return false;
    }

    private boolean isScarecrowAt(World world, int x, int y, int z) {
        int i = 0;
        while (i < 2 && world.func_147439_a(x, y, z) == Blocks.field_150407_cf) {
            ++i;
            ++y;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockPumpkin) {
            --y;
            for (int dy = i; dy < 2; ++dy) {
                if (world.func_147439_a(x, y - dy, z) == Blocks.field_150407_cf) continue;
                return false;
            }
            if (world.func_147439_a(x + 1, y, z) == Blocks.field_150407_cf && world.func_147439_a(x - 1, y, z) == Blocks.field_150407_cf) {
                return true;
            }
            if (world.func_147439_a(x, y, z + 1) == Blocks.field_150407_cf && world.func_147439_a(x, y, z - 1) == Blocks.field_150407_cf) {
                return true;
            }
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + Instrument.values()[stack.func_77960_j() % Instrument.values().length].unlocalizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.icons.get(damage % this.icons.size());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Instrument instrument : Instrument.values()) {
            list.add(new ItemStack(item, 1, instrument.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new ArrayList<IIcon>(Instrument.values().length);
        for (Instrument instrument : Instrument.values()) {
            this.icons.add(register.func_94245_a("zeldaswordskills:" + instrument.getUnlocalizedName()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip.zss.instrument." + this.getInstrument(stack).getUnlocalizedName() + ".desc")));
    }

    static {
        HashMap<String, AbstractZeldaSong> teacherSongs = new HashMap<String, AbstractZeldaSong>();
        teacherSongs.put("Guru-Guru", ZeldaSongs.songStorms);
        teacherSongs.put("Impa", ZeldaSongs.songZeldasLullaby);
        teacherSongs.put("Malon", ZeldaSongs.songEpona);
        teacherSongs.put("Saria", ZeldaSongs.songSaria);
        teachersForClass.put(EntityVillager.class, teacherSongs);
    }

    public static enum Instrument {
        OCARINA_FAIRY("ocarina_fairy", 3, 1),
        OCARINA_TIME("ocarina_time", 3, 5);

        private final String unlocalizedName;
        private final int guiId;
        private final int power;

        private Instrument(String name, int guiId, int power) {
            this.unlocalizedName = name;
            this.guiId = guiId;
            this.power = Math.min(power, 5);
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public int getGuiId() {
            return this.guiId;
        }

        public int getPower() {
            return this.power;
        }
    }
}

