/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityHookShot;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemHookShot
extends Item
implements IUnenchantable {
    protected static final String[] shotNames = new String[]{"Hookshot", "Clawshot", "Multishot"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemHookShot() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabTools);
        this.func_77664_n();
    }

    public IHookable.HookshotType getType(int damage) {
        return damage > -1 ? IHookable.HookshotType.values()[damage % IHookable.HookshotType.values().length] : IHookable.HookshotType.WOOD_SHOT;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    public int func_77626_a(ItemStack stack) {
        return 16000;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        EntityHookShot shot = new EntityHookShot(player.field_70170_p, (EntityLivingBase)player);
        shot.setThrower(player);
        shot.setType(this.getType(stack.func_77960_j()));
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72838_d((Entity)shot);
            player.field_70170_p.func_72956_a((Entity)player, "zeldaswordskills:hookshot", 1.0f, 1.0f);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (count % 9 == 8 && !player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, "zeldaswordskills:hookshot", 1.0f, 1.0f);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity.getClass() == EntityVillager.class) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == 3) {
                MerchantRecipe trade = new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 16));
                if (MerchantRecipeHelper.addToListWithCheck(trades, trade) || player.field_70170_p.field_73012_v.nextFloat() < 0.5f) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sell.0", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int type) {
        return this.iconArray[this.getType(type).ordinal() / 2];
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + stack.func_77960_j();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < IHookable.HookshotType.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.iconArray = new IIcon[IHookable.HookshotType.values().length / 2];
        for (int i = 0; i < IHookable.HookshotType.values().length; ++i) {
            this.iconArray[i / 2] = register.func_94245_a("zeldaswordskills:" + shotNames[this.getType(i).ordinal() / 2].toLowerCase());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.0"));
        switch (this.getType(stack.func_77960_j())) {
            case WOOD_SHOT: 
            case WOOD_SHOT_EXT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.10"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.11"));
                break;
            }
            case CLAW_SHOT: 
            case CLAW_SHOT_EXT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.20"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.21"));
                break;
            }
            case MULTI_SHOT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.30"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.31"));
                break;
            }
            case MULTI_SHOT_EXT: {
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.32"));
                list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.hookshot.desc.31"));
            }
        }
    }
}

