/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.ISheathed;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.ISpecialBow;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.items.ItemQuiver;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.item.IFairyUpgrade;
import zeldaswordskills.api.item.IMagicArrow;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IZoom;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.entity.projectile.EntityArrowBomb;
import zeldaswordskills.entity.projectile.EntityArrowCustom;
import zeldaswordskills.entity.projectile.EntityArrowElemental;
import zeldaswordskills.handler.BattlegearEvents;
import zeldaswordskills.item.ICyclableItem;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.battlegear2.api.IAllowItem", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.ISheathed", modid="battlegear2", striprefs=true), @Optional.Interface(iface="mods.battlegear2.api.quiver.ISpecialBow", modid="battlegear2", striprefs=true)})
public class ItemHeroBow
extends ItemBow
implements ICyclableItem,
IFairyUpgrade,
IUnenchantable,
IZoom,
IAllowItem,
ISheathed,
ISpecialBow {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private static final Map<Item, Class<? extends EntityArrowCustom>> arrowMap = new HashMap<Item, Class<? extends EntityArrowCustom>>();
    private static BiMap<Item, BombType> bombArrowMap;
    private static final Map<Item, EntityArrowElemental.ElementType> elementalArrowMap;
    private static final List fireHandlers;

    public ItemHeroBow() {
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public int getLevel(ItemStack bow) {
        if (!bow.func_77942_o() || !bow.func_77978_p().func_74764_b("zssBowLevel")) {
            this.setLevel(bow, 1);
        }
        return bow.func_77978_p().func_74762_e("zssBowLevel");
    }

    private void setLevel(ItemStack bow, int level) {
        if (!bow.func_77942_o()) {
            bow.func_77982_d(new NBTTagCompound());
        }
        bow.func_77978_p().func_74768_a("zssBowLevel", level);
    }

    public Mode getMode(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("zssItemMode")) {
            this.setMode(stack, Mode.DEFAULT);
        }
        return Mode.values()[stack.func_77978_p().func_74762_e("zssItemMode") % Mode.values().length];
    }

    private void setMode(ItemStack stack, Mode mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("zssItemMode", mode.ordinal());
    }

    @Override
    public void nextItemMode(ItemStack stack, EntityPlayer player) {
        if (!player.func_71039_bw()) {
            this.setMode(stack, this.getMode(stack).next(this.getLevel(stack)));
        }
    }

    @Override
    public void prevItemMode(ItemStack stack, EntityPlayer player) {
        if (!player.func_71039_bw()) {
            this.setMode(stack, this.getMode(stack).prev(this.getLevel(stack)));
        }
    }

    @Override
    public int getCurrentMode(ItemStack stack, EntityPlayer player) {
        return this.getMode(stack).ordinal();
    }

    @Override
    public void setCurrentMode(ItemStack stack, EntityPlayer player, int mode) {
        this.setMode(stack, Mode.values()[mode % Mode.values().length]);
    }

    @Override
    public ItemStack getRenderStackForMode(ItemStack stack, EntityPlayer player) {
        ItemStack ret;
        Item item = this.getMode(stack).getArrowItem();
        ItemStack itemStack = ret = item == null ? null : new ItemStack(item, 0);
        if (ret != null) {
            for (ItemStack inv : player.field_71071_by.field_70462_a) {
                if (inv == null || inv.func_77973_b() != ret.func_77973_b()) continue;
                ret.field_77994_a += inv.field_77994_a;
                if (ret.field_77994_a <= 98) continue;
                ret.field_77994_a = 99;
                break;
            }
        }
        return ret;
    }

    public ItemStack getArrow(EntityPlayer player) {
        return ZSSPlayerInfo.get(player).getNockedArrow();
    }

    private void setArrow(EntityPlayer player, ItemStack arrow) {
        ZSSPlayerInfo.get(player).setNockedArrow(arrow);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getMaxZoomTime() {
        return 20.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getZoomFactor() {
        return 0.15f;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (Config.areArrowTradesEnabled() && entity instanceof EntityVillager && !player.field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            if (villager.func_70946_n() == 2 && trades != null && trades.size() >= Config.getFriendTradesRequired()) {
                int level = this.getLevel(stack);
                MerchantRecipe trade = null;
                if (level > 1 && MerchantRecipeHelper.doesListContain(trades, trade = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 16), new ItemStack(ZSSItems.arrowFire, 4)))) {
                    trade = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 20), new ItemStack(ZSSItems.arrowIce, 4));
                    if (level > 2 && MerchantRecipeHelper.doesListContain(trades, trade)) {
                        trade = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 40), new ItemStack(ZSSItems.arrowLight, 4));
                    }
                }
                if (trade != null && MerchantRecipeHelper.addToListWithCheck(trades, trade)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.arrow", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.1", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.generic.sorry.0", new Object[0]);
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (this.nockArrowFromInventory(stack, player)) {
            int duration = this.func_77626_a(stack);
            if (ZSSMain.isBG2Enabled) {
                duration -= EnchantmentHelper.func_77506_a((int)((Enchantment)BaseEnchantment.bowCharge.get()).field_77352_x, (ItemStack)stack) * 20000;
            }
            player.func_71008_a(stack, duration);
        }
        return stack;
    }

    public void func_77615_a(ItemStack bow, World world, EntityPlayer player, int ticksRemaining) {
        ZSSPlayerInfo.get((EntityPlayer)player).hasAutoBombArrow = false;
        int ticksInUse = this.func_77626_a(bow) - ticksRemaining;
        ArrowLooseEvent event = new ArrowLooseEvent(player, bow, ticksInUse);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            if (this.getArrow(player) != null) {
                this.setArrow(player, null);
            }
            return;
        }
        ItemStack arrowStack = this.getArrow(player);
        if (arrowStack != null) {
            if (this.canShootArrow(player, bow, arrowStack)) {
                this.fireArrow(event, arrowStack, bow, player);
            }
            this.setArrow(player, null);
        }
    }

    private void fireArrow(ArrowLooseEvent event, ItemStack arrowStack, ItemStack bow, EntityPlayer player) {
        boolean flag;
        boolean bl = flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)bow) > 0;
        if (flag || PlayerUtils.hasItem(player, arrowStack)) {
            float charge = (float)event.charge / 20.0f;
            if ((double)(charge = Math.min((charge * charge + charge * 2.0f) / 3.0f, 1.0f)) < 0.1) {
                return;
            }
            EntityArrowCustom arrowEntity = ItemHeroBow.getArrowEntity(arrowStack, player.field_70170_p, (EntityLivingBase)player, charge * 2.0f);
            if (arrowEntity == null && ZSSMain.isBG2Enabled) {
                arrowEntity = QuiverArrowRegistry.getArrowType((ItemStack)arrowStack, (World)player.field_70170_p, (EntityPlayer)player, (float)(charge * 2.0f));
            }
            if (arrowEntity != null && this.confirmArrowShot(arrowStack, player)) {
                ItemHeroBow.applyArrowSettings(arrowEntity, bow, charge);
                if (arrowEntity instanceof EntityArrowCustom) {
                    ItemHeroBow.applyCustomArrowSettings(event.entityPlayer, event.bow, arrowStack, arrowEntity, charge);
                }
                player.field_70170_p.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + charge * 0.5f);
                if (flag) {
                    arrowEntity.field_70251_a = 2;
                } else {
                    PlayerUtils.consumeInventoryItem(player, arrowStack, 1);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)arrowEntity);
                }
            }
        }
    }

    private boolean confirmArrowShot(ItemStack arrow, EntityPlayer player) {
        if (arrow != null && arrow.func_77973_b() instanceof IMagicArrow) {
            float mp = ((IMagicArrow)arrow.func_77973_b()).getMagicCost(arrow, player);
            return ZSSPlayerInfo.get(player).consumeMagic(mp);
        }
        return true;
    }

    public boolean canShootArrow(EntityPlayer player, ItemStack bow, ItemStack arrowStack) {
        Item arrowItem;
        Item item = arrowItem = arrowStack == null ? null : arrowStack.func_77973_b();
        if (arrowMap.containsKey(arrowItem)) {
            if (player.field_71075_bZ.field_75098_d) {
                return true;
            }
            if (arrowItem instanceof IMagicArrow && (!ZSSPlayerInfo.get(player).canUseMagic() || ZSSPlayerInfo.get(player).getCurrentMagic() < ((IMagicArrow)arrowItem).getMagicCost(arrowStack, player))) {
                return false;
            }
            if (elementalArrowMap.containsKey(arrowItem)) {
                if (ZSSPlayerInfo.get(player).isNayruActive()) {
                    return false;
                }
                int n = this.getLevel(bow);
                if (n < 3) {
                    return n == 2 && elementalArrowMap.get(arrowItem) != EntityArrowElemental.ElementType.LIGHT;
                }
            }
            return true;
        }
        return ZSSMain.isBG2Enabled && QuiverArrowRegistry.isKnownArrow((ItemStack)arrowStack);
    }

    private ItemStack getArrowFromInventory(ItemStack bow, EntityPlayer player) {
        Item modeArrow = this.getMode(bow).getArrowItem();
        ItemStack arrow = null;
        if (modeArrow == null && Config.enableAutoBombArrows() && player.func_70093_af()) {
            arrow = this.getAutoBombArrow(bow, player);
        }
        if (modeArrow != null) {
            if (!this.canShootArrow(player, bow, new ItemStack(modeArrow))) {
                return null;
            }
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || stack.func_77973_b() != modeArrow) continue;
                arrow = stack;
                break;
            }
        } else if (arrow == null) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || !this.canShootArrow(player, bow, stack)) continue;
                arrow = stack;
                break;
            }
        }
        if (arrow == null && player.field_71075_bZ.field_75098_d) {
            arrow = new ItemStack(modeArrow == null ? Items.field_151032_g : modeArrow);
        }
        return arrow;
    }

    public boolean nockArrowFromInventory(ItemStack bow, EntityPlayer player) {
        this.setArrow(player, this.getArrowFromInventory(bow, player));
        return this.getArrow(player) != null;
    }

    private ItemStack getAutoBombArrow(ItemStack bow, EntityPlayer player) {
        ItemStack arrow = null;
        boolean hasArrow = player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Items.field_151032_g);
        boolean hasAutoArrow = ZSSPlayerInfo.get((EntityPlayer)player).hasAutoBombArrow;
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && arrow == null; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() == ZSSItems.arrowBomb || stack.func_77973_b() == ZSSItems.arrowBombFire || stack.func_77973_b() == ZSSItems.arrowBombWater) {
                arrow = stack;
                continue;
            }
            if (stack.func_77973_b() instanceof ItemBombBag) {
                ItemBombBag bombBag = (ItemBombBag)stack.func_77973_b();
                int bagType = bombBag.getBagBombType(stack);
                if (bagType < 0 || bombBag.getBombsHeld(stack) <= 0) continue;
                BombType type = BombType.values()[bagType % BombType.values().length];
                ItemStack bombArrow = new ItemStack((Item)bombArrowMap.inverse().get((Object)type), 1, 0);
                if (hasAutoArrow || player.field_71075_bZ.field_75098_d) {
                    arrow = bombArrow;
                    continue;
                }
                if (!hasArrow || !player.field_71071_by.func_70441_a(bombArrow)) continue;
                if (bombBag.removeBomb(stack)) {
                    if (player.field_71071_by.func_146026_a(Items.field_151032_g)) {
                        arrow = bombArrow;
                        continue;
                    }
                    bombBag.addBombs(stack, bombArrow);
                    continue;
                }
                PlayerUtils.consumeInventoryItem(player, bombArrow, 1);
                continue;
            }
            if (stack.func_77973_b() != ZSSItems.bomb) continue;
            ItemStack bombArrow = new ItemStack((Item)bombArrowMap.inverse().get((Object)ItemBomb.getType(stack)), 1, 0);
            if (hasAutoArrow || player.field_71075_bZ.field_75098_d) {
                arrow = bombArrow;
                continue;
            }
            if (!hasArrow || !player.field_71071_by.func_146026_a(Items.field_151032_g)) continue;
            arrow = bombArrow;
            player.field_71071_by.func_70299_a(i, bombArrow);
        }
        if (arrow == null && player.field_71075_bZ.field_75098_d) {
            arrow = new ItemStack(ZSSItems.arrowBomb);
        }
        ZSSPlayerInfo.get((EntityPlayer)player).hasAutoBombArrow = arrow != null;
        return arrow;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem == null) {
            return this.field_77791_bV;
        }
        int t = stack.func_77988_m() - useRemaining;
        return t > 17 ? this.iconArray[2] : (t > 13 ? this.iconArray[1] : (t > 0 ? this.iconArray[0] : this.field_77791_bV));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + "_standard_0");
        this.iconArray = new IIcon[3];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9) + "_standard_" + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = new ItemStack(item);
            this.setLevel(stack, i);
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.0")));
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc.1"), (Object[])new Object[]{this.getLevel(stack)}));
        Item item = this.getMode(stack).getArrowItem();
        if (item != null) {
            list.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"tooltip.zss.mode", (Object[])new Object[]{new ItemStack(item).func_82833_r()}));
        }
    }

    @Override
    public void handleFairyUpgrade(EntityItem item, EntityPlayer player, TileEntityDungeonCore core) {
        ItemStack stack = item.func_92059_d();
        int n = this.getLevel(stack);
        if (n < 3 && core.consumeRupees((n + 1) * Config.getHeroBowUpgradeCost())) {
            this.setLevel(stack, ++n);
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
            player.func_71029_a((StatBase)ZSSAchievements.fairyBow);
            if (n == 3) {
                player.func_71029_a((StatBase)ZSSAchievements.fairyBowMax);
            }
        } else {
            core.func_145831_w().func_72908_a((double)core.field_145851_c + 0.5, (double)(core.field_145848_d + 1), (double)core.field_145849_e + 0.5, "zeldaswordskills:fairy_laugh", 1.0f, 1.0f);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.fairy.laugh.unworthy", new Object[0]);
        }
    }

    @Override
    public boolean hasFairyUpgrade(ItemStack stack) {
        return this.getLevel(stack) < 3;
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return offhand == null || offhand.func_77973_b() instanceof ItemQuiver;
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public List<IArrowFireHandler> getFireHandlers(ItemStack arrow, ItemStack bow, EntityPlayer player) {
        return fireHandlers;
    }

    @Optional.Method(modid="battlegear2")
    public Event.Result canDrawBow(ItemStack bow, EntityPlayer player) {
        ItemStack arrow = BattlegearEvents.getQuiverArrow(bow, player);
        return this.canShootArrow(player, bow, arrow) ? Event.Result.ALLOW : Event.Result.DENY;
    }

    public static final void applyArrowSettings(EntityArrow arrow, ItemStack bow, float charge) {
        int l;
        int k;
        if (charge == 1.0f) {
            arrow.func_70243_d(true);
        }
        if ((k = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)k * 0.5 + 0.5);
        }
        if ((l = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)bow)) > 0) {
            arrow.func_70240_a(l);
        }
        if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)bow) > 0) {
            arrow.func_70015_d(100);
        }
    }

    private static final void applyCustomArrowSettings(EntityPlayer player, ItemStack bow, ItemStack arrowStack, EntityArrowCustom arrowEntity, float charge) {
        EntityLivingBase target;
        Item arrowItem = arrowStack.func_77973_b();
        arrowEntity.setArrowItem(arrowItem);
        if (player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() == ZSSItems.maskHawkeye && (target = TargetUtils.acquireLookTarget((EntityLivingBase)player, 64, 1.0)) != null) {
            arrowEntity.setHomingArrow(true);
            arrowEntity.setTarget(target);
        }
        if (arrowEntity instanceof EntityArrowBomb && bombArrowMap.containsKey((Object)arrowItem)) {
            ((EntityArrowBomb)arrowEntity).setType((BombType)((Object)bombArrowMap.get((Object)arrowItem)));
            arrowEntity.func_70239_b(0.0);
        } else if (arrowEntity instanceof EntityArrowElemental && elementalArrowMap.containsKey(arrowItem)) {
            ((EntityArrowElemental)arrowEntity).setType(elementalArrowMap.get(arrowItem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final EntityArrowCustom getArrowEntity(ItemStack arrowStack, World world, EntityLivingBase shooter, float charge) {
        Item arrowItem;
        Item item = arrowItem = arrowStack == null ? null : arrowStack.func_77973_b();
        if (!arrowMap.containsKey(arrowItem)) {
            return null;
        }
        EntityArrowCustom arrow = null;
        try {
            try {
                arrow = arrowMap.get(arrowItem).getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(world, shooter, Float.valueOf(charge));
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                Object var7_9 = null;
                return arrow;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                Object var7_10 = null;
                return arrow;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                Object var7_11 = null;
                return arrow;
            }
        }
        finally {
            return arrow;
        }
    }

    public static void initializeArrows() {
        arrowMap.put(Items.field_151032_g, EntityArrowCustom.class);
        arrowMap.put(ZSSItems.arrowBomb, EntityArrowBomb.class);
        arrowMap.put(ZSSItems.arrowBombFire, EntityArrowBomb.class);
        arrowMap.put(ZSSItems.arrowBombWater, EntityArrowBomb.class);
        arrowMap.put(ZSSItems.arrowFire, EntityArrowElemental.class);
        arrowMap.put(ZSSItems.arrowIce, EntityArrowElemental.class);
        arrowMap.put(ZSSItems.arrowLight, EntityArrowElemental.class);
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)ZSSItems.arrowBomb, (Object)BombType.BOMB_STANDARD);
        builder.put((Object)ZSSItems.arrowBombFire, (Object)BombType.BOMB_FIRE);
        builder.put((Object)ZSSItems.arrowBombWater, (Object)BombType.BOMB_WATER);
        bombArrowMap = builder.build();
        elementalArrowMap.put(ZSSItems.arrowFire, EntityArrowElemental.ElementType.FIRE);
        elementalArrowMap.put(ZSSItems.arrowIce, EntityArrowElemental.ElementType.ICE);
        elementalArrowMap.put(ZSSItems.arrowLight, EntityArrowElemental.ElementType.LIGHT);
    }

    @Optional.Method(modid="battlegear2")
    public static void registerBG2() {
        fireHandlers.add(new HeroBowFireHandler());
        fireHandlers.add(new QuiverArrowRegistry.DefaultArrowFire());
        QuiverArrowRegistry.addArrowFireHandler((IArrowFireHandler)new HeroBowFireHandler());
        QuiverArrowRegistry.addArrowToRegistry((Item)ZSSItems.arrowBomb, null);
        QuiverArrowRegistry.addArrowToRegistry((Item)ZSSItems.arrowBombFire, null);
        QuiverArrowRegistry.addArrowToRegistry((Item)ZSSItems.arrowBombWater, null);
        QuiverArrowRegistry.addArrowToRegistry((Item)ZSSItems.arrowFire, null);
        QuiverArrowRegistry.addArrowToRegistry((Item)ZSSItems.arrowIce, null);
        QuiverArrowRegistry.addArrowToRegistry((Item)ZSSItems.arrowLight, null);
    }

    static {
        elementalArrowMap = new HashMap<Item, EntityArrowElemental.ElementType>();
        fireHandlers = new ArrayList();
    }

    @Optional.Interface(iface="mods.battlegear2.api.quiver.IArrowFireHandler", modid="battlegear2", striprefs=true)
    public static class HeroBowFireHandler
    implements IArrowFireHandler {
        @Optional.Method(modid="battlegear2")
        public boolean canFireArrow(ItemStack arrow, World world, EntityPlayer player, float charge) {
            ItemStack bow = player.func_70694_bm();
            if (bow != null) {
                return bow.func_77973_b() instanceof ItemHeroBow ? ((ItemHeroBow)bow.func_77973_b()).canShootArrow(player, bow, arrow) : player.field_71075_bZ.field_75098_d;
            }
            return false;
        }

        @Optional.Method(modid="battlegear2")
        public EntityArrow getFiredArrow(ItemStack arrow, World world, EntityPlayer player, float charge) {
            ItemStack bow = player.func_70694_bm();
            if (bow != null && (bow.func_77973_b() instanceof ItemHeroBow || player.field_71075_bZ.field_75098_d)) {
                EntityArrowCustom arrowEntity = ItemHeroBow.getArrowEntity(arrow, world, (EntityLivingBase)player, charge);
                if (arrowEntity != null && (!(bow.func_77973_b() instanceof ItemHeroBow) || ((ItemHeroBow)bow.func_77973_b()).confirmArrowShot(arrow, player))) {
                    ItemHeroBow.applyCustomArrowSettings(player, bow, arrow, arrowEntity, charge);
                }
                return arrowEntity;
            }
            return null;
        }
    }

    public static enum Mode {
        DEFAULT("", 0),
        STANDARD("minecraft:arrow", 0),
        BOMB_STANDARD("zeldaswordskills:zss.arrow_bomb", 1),
        BOMB_FIRE("zeldaswordskills:zss.arrow_bomb_fire", 1),
        BOMB_WATER("zeldaswordskills:zss.arrow_bomb_water", 1),
        MAGIC_FIRE("zeldaswordskills:zss.arrow_fire", 2),
        MAGIC_ICE("zeldaswordskills:zss.arrow_ice", 2),
        MAGIC_LIGHT("zeldaswordskills:zss.arrow_light", 3);

        private final String arrowName;
        private Item arrowItem;
        private final int level;

        private Mode(String arrowName, int level) {
            this.arrowName = arrowName;
            this.level = level;
        }

        public Item getArrowItem() {
            if (this.arrowItem == null && this.arrowName.length() > 0) {
                String[] parts = this.arrowName.split(":");
                this.arrowItem = GameRegistry.findItem((String)parts[0], (String)parts[1]);
            }
            return this.arrowItem;
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode next(int level) {
            return this.cycle(level, true);
        }

        public Mode prev() {
            return Mode.values()[((this.ordinal() == 0 ? Mode.values().length : this.ordinal()) - 1) % Mode.values().length];
        }

        public Mode prev(int level) {
            return this.cycle(level, false);
        }

        private Mode cycle(int level, boolean next) {
            Mode mode = this;
            do {
                Mode mode2 = mode = next ? mode.next() : mode.prev();
            } while (mode != this && mode.level > level);
            return mode;
        }
    }
}

