/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.item.IUnenchantable;
import zeldaswordskills.api.item.IWeapon;
import zeldaswordskills.api.item.WeaponRegistry;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemZeldaSword;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

@Optional.Interface(iface="mods.battlegear2.api.weapons.IBattlegearWeapon", modid="battlegear2", striprefs=true)
public class ItemBrokenSword
extends Item
implements IUnenchantable,
IWeapon,
IBattlegearWeapon {
    public ItemBrokenSword() {
        this.func_77664_n();
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityVillager && !player.field_70170_p.field_72995_K) {
            boolean isGoron = entity instanceof EntityGoron;
            EntityVillager villager = (EntityVillager)entity;
            MerchantRecipeList trades = villager.func_70934_b(player);
            Item brokenItem = Item.func_150899_d((int)stack.func_77960_j());
            if (!(brokenItem instanceof ItemSword) || brokenItem instanceof ItemZeldaSword && !((ItemZeldaSword)brokenItem).givesBrokenItem) {
                ZSSMain.logger.warn("Broken sword contained an invalid item: " + brokenItem + "; defaulting to Ordon Sword");
                brokenItem = ZSSItems.swordOrdon;
            }
            if (villager.func_70946_n() == 3 || isGoron) {
                if (brokenItem != ZSSItems.swordGiant) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.broken", new Object[0]);
                    MerchantRecipeHelper.addToListWithCheck(trades, new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 5), new ItemStack(brokenItem)));
                } else if (isGoron && villager.func_94057_bL().equals("Medigoron")) {
                    if (ZSSPlayerSkills.get(player).getSkillLevel(SkillBase.bonusHeart) > 9) {
                        player.func_71029_a((StatBase)ZSSAchievements.swordBroken);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.broken.giant.1", new Object[0]);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.broken.giant.2", new Object[0]);
                        MerchantRecipeHelper.addToListWithCheck(trades, new MerchantRecipe(stack.func_77946_l(), new ItemStack(Items.field_151166_bC, 5), new ItemStack(brokenItem)));
                    } else {
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.big", new Object[0]);
                        PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.later", new Object[0]);
                    }
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.sorry", new Object[0]);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.sword.sorry", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        Item sword = Item.func_150899_d((int)damage);
        if (sword instanceof ItemZeldaSword && ((ItemZeldaSword)sword).givesBrokenItem) {
            return sword.func_77617_a(-1);
        }
        return this.field_77791_bV;
    }

    public String func_77653_i(ItemStack stack) {
        Item sword = Item.func_150899_d((int)stack.func_77960_j());
        String name = sword instanceof ItemZeldaSword && ((ItemZeldaSword)sword).givesBrokenItem ? sword.func_77658_a() : ZSSItems.swordOrdon.func_77658_a();
        return StatCollector.func_74837_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[]{StatCollector.func_74838_a((String)(name + ".name"))});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, Item.func_150891_b((Item)ZSSItems.swordKokiri)));
        list.add(new ItemStack(item, 1, Item.func_150891_b((Item)ZSSItems.swordOrdon)));
        list.add(new ItemStack(item, 1, Item.func_150891_b((Item)ZSSItems.swordGiant)));
        list.add(new ItemStack(item, 1, Item.func_150891_b((Item)ZSSItems.swordDarknut)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.zss.sword_broken.desc.0"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:broken_sword_ordon");
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 2.0, 0));
        return multimap;
    }

    @Override
    public boolean isSword(ItemStack stack) {
        return !WeaponRegistry.INSTANCE.isSwordForbidden(this);
    }

    @Override
    public boolean isWeapon(ItemStack stack) {
        return !WeaponRegistry.INSTANCE.isWeaponForbidden(this);
    }

    @Optional.Method(modid="battlegear2")
    public boolean sheatheOnBack(ItemStack stack) {
        return false;
    }

    @Optional.Method(modid="battlegear2")
    public boolean isOffhandHandDual(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandAttackEntity(PlayerEventChild.OffhandAttackEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickAir(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public boolean offhandClickBlock(PlayerInteractEvent event, ItemStack main, ItemStack offhand) {
        return true;
    }

    @Optional.Method(modid="battlegear2")
    public void performPassiveEffects(Side side, ItemStack main, ItemStack offhand) {
    }

    @Optional.Method(modid="battlegear2")
    public boolean allowOffhand(ItemStack main, ItemStack offhand) {
        return true;
    }
}

