/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.world.World;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class ItemArmorTunic
extends ItemArmor {
    protected PotionEffect tickingEffect = null;

    public ItemArmorTunic(int renderIndex, int type) {
        super(ItemArmor.ArmorMaterial.CHAIN, renderIndex, type);
        this.func_77637_a(ZSSCreativeTabs.tabCombat);
    }

    public ItemArmorTunic setEffect(PotionEffect effect) {
        this.tickingEffect = effect;
        return this;
    }

    public PotionEffect getEffect() {
        return this.tickingEffect;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && this == ZSSItems.tunicGoronChest && entity instanceof EntityGoron) {
            if (stack.func_77960_j() > 0) {
                MerchantRecipe trade = new MerchantRecipe(new ItemStack(ZSSItems.tunicGoronChest), new ItemStack(Items.field_151166_bC, 8), new ItemStack(ZSSItems.tunicGoronChest));
                MerchantRecipeHelper.addToListWithCheck(((EntityVillager)entity).func_70934_b(player), trade);
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.goron.tunic.repair", new Object[0]);
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.trade.goron.tunic.undamaged", new Object[0]);
            }
        }
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        PotionEffect effect = this.getEffect();
        if (effect != null && this.shouldDamageArmor(world, player, stack, effect.func_76456_a())) {
            player.func_70690_d(new PotionEffect(effect));
            player.func_70050_g(300);
            this.damageStack(stack, (EntityLivingBase)player, 1);
        }
    }

    public static boolean onFireDamage(EntityLivingBase entity, float damage) {
        ItemStack stack = entity.func_71124_b(3);
        if (!entity.field_70170_p.field_72995_K && stack != null && stack.func_77973_b() == ZSSItems.tunicGoronChest) {
            if (entity.func_82165_m(Potion.field_76426_n.func_76396_c())) {
                return true;
            }
            damage *= 1.0f + (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.WEAKNESS_FIRE) * 0.01f;
            if ((damage *= 1.0f - (float)ZSSEntityInfo.get(entity).getBuffAmplifier(Buff.RESIST_FIRE) * 0.01f) < 0.1f) {
                entity.func_70066_B();
                return true;
            }
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("lastDamaged") || entity.field_70170_p.func_82737_E() > stack.func_77978_p().func_74763_f("lastDamaged") + 20L) {
                stack.func_77978_p().func_74772_a("lastDamaged", entity.field_70170_p.func_82737_E());
                ((ItemArmorTunic)stack.func_77973_b()).damageStack(stack, entity, Math.max((int)damage / 4, 1));
                entity.func_70066_B();
            }
            return true;
        }
        return false;
    }

    private void damageStack(ItemStack stack, EntityLivingBase entity, int amount) {
        stack.func_77972_a(amount, entity);
        if (stack.field_77994_a == 0 || stack.func_77960_j() >= stack.func_77958_k()) {
            entity.field_70170_p.func_72956_a((Entity)entity, "random.break", 1.0f, 1.0f);
            entity.func_70062_b(EntityLiving.func_82159_b((ItemStack)stack), null);
        }
    }

    private boolean shouldDamageArmor(World world, EntityPlayer player, ItemStack stack, int effectID) {
        Material m = world.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u + 1, (int)player.field_70161_v).func_149688_o();
        if (effectID == Potion.field_76427_o.field_76415_H) {
            if (player.func_82165_m(Potion.field_76427_o.func_76396_c())) {
                return false;
            }
            ItemStack helm = player.func_82169_q(3);
            if (helm != null && helm.func_77973_b() == ZSSItems.maskZora) {
                return false;
            }
            int time = 50 + 50 * EnchantmentHelper.func_77501_a((EntityLivingBase)player) + (helm != null && helm.func_77973_b() == ZSSItems.tunicZoraHelm ? 100 : 0);
            return m == Material.field_151586_h && world.func_82737_E() % (long)time == 0L;
        }
        return false;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        String name = this.func_77658_a().substring(9, this.func_77658_a().lastIndexOf("_"));
        return String.format("%s:textures/armor/%s_layer_%d.png", "zeldaswordskills", name, slot == 2 ? 2 : 1);
    }

    public int func_77619_b() {
        return ItemArmor.ArmorMaterial.CLOTH.func_78045_a();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack stack) {
        if (this == ZSSItems.tunicGoronChest) {
            return stack.func_77973_b() == Items.field_151064_bs;
        }
        if (this == ZSSItems.tunicZoraChest) {
            // empty if block
        }
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("zeldaswordskills:" + this.func_77658_a().substring(9));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        String[] tooltips;
        for (String tooltip : tooltips = StatCollector.func_74838_a((String)("tooltip." + this.func_77658_a().substring(5) + ".desc")).split("\\\\n")) {
            list.add(EnumChatFormatting.ITALIC + tooltip);
        }
    }
}

