/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.api.entity.LootableEntityRegistry;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ItemWhip;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.network.server.FallDistancePacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.skills.sword.Parry;
import zeldaswordskills.util.TargetUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityWhip
extends EntityThrowable {
    protected static final int THROWER_INDEX = 22;
    protected static final int WHIP_TYPE_INDEX = 24;
    protected static final int IN_GROUND_INDEX = 25;
    public static final int HIT_POS_X = 26;
    public static final int HIT_POS_Y = 27;
    public static final int HIT_POS_Z = 28;
    private int hitX;
    private int hitY;
    private int hitZ;
    private int ticksInGround = 0;
    private int swingTicks = 0;
    private Vec3 swingVec = null;
    private double dy;

    public EntityWhip(World world) {
        super(world);
    }

    public EntityWhip(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityWhip(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.25f, 0.25f);
        this.field_70180_af.func_75682_a(22, (Object)"");
        this.field_70180_af.func_75682_a(24, (Object)IWhipBlock.WhipType.WHIP_SHORT.ordinal());
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(27, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(28, (Object)Float.valueOf(0.0f));
    }

    public IWhipBlock.WhipType getType() {
        return IWhipBlock.WhipType.values()[this.field_70180_af.func_75679_c(24) % IWhipBlock.WhipType.values().length];
    }

    public EntityWhip setType(IWhipBlock.WhipType type) {
        this.field_70180_af.func_75692_b(24, (Object)type.ordinal());
        return this;
    }

    public float getMaxDistance() {
        return (float)Config.getWhipRange() * (this.getType().isExtended() ? 1.5f : 1.0f);
    }

    public void setThrower(EntityPlayer player) {
        this.field_70180_af.func_75692_b(22, (Object)(player != null ? player.func_70005_c_() : ""));
    }

    public EntityLivingBase func_85052_h() {
        String name = this.field_70180_af.func_75681_e(22);
        return name.equals("") ? null : this.field_70170_p.func_72924_a(name);
    }

    public boolean isInGround() {
        return (this.field_70180_af.func_75683_a(25) & 1) == 1;
    }

    protected void setInGround(boolean isInGround) {
        this.field_70180_af.func_75692_b(25, (Object)(isInGround ? (byte)1 : 0));
        this.field_70193_a = isInGround;
    }

    protected float getDamage() {
        switch (this.getType()) {
            case WHIP_SHORT: {
                return 1.0f;
            }
            case WHIP_LONG: {
                return 2.0f;
            }
            case WHIP_MAGIC: {
                return 4.0f;
            }
        }
        return 1.0f;
    }

    protected DamageSource getDamageSource() {
        return new DamageUtils.DamageSourceBaseIndirect("whip", (Entity)this, (Entity)this.func_85052_h()).setStunDamage(40, 10, true);
    }

    protected boolean canBreakBlock(Block block, Material m, int x, int y, int z, int side) {
        EntityLivingBase thrower = this.func_85052_h();
        if (block instanceof IWhipBlock) {
            return ((IWhipBlock)block).canBreakBlock(this.getType(), thrower, this.field_70170_p, x, y, z, side);
        }
        boolean isBreakable = block.func_149712_f(this.field_70170_p, x, y, z) >= 0.0f;
        boolean canPlayerEdit = false;
        if (thrower instanceof EntityPlayer) {
            canPlayerEdit = ((EntityPlayer)thrower).field_71075_bZ.field_75099_e && Config.canHookshotBreakBlocks();
        }
        return isBreakable && canPlayerEdit && (block instanceof BlockTorch || m == Material.field_151584_j || m == Material.field_151585_k);
    }

    protected boolean canGrabBlock(Block block, int x, int y, int z, int side) {
        if (block instanceof IWhipBlock) {
            return ((IWhipBlock)block).canGrabBlock(this.getType(), this.func_85052_h(), this.field_70170_p, x, y, z, side);
        }
        switch (this.getType()) {
            case WHIP_MAGIC: {
                if (block instanceof BlockSandStone || block instanceof BlockHugeMushroom || block.func_149688_o().func_76230_c() && block.func_149712_f(this.field_70170_p, x, y, z) > 1.0f) {
                    return true;
                }
            }
            case WHIP_SHORT: 
            case WHIP_LONG: {
                int clear = 0;
                if (this.isSideClear(x + 1, y, z) && this.isSideClear(x - 1, y, z)) {
                    ++clear;
                }
                if (this.isSideClear(x, y + 1, z) && this.isSideClear(x, y - 1, z)) {
                    ++clear;
                }
                if (this.isSideClear(x, y, z + 1) && this.isSideClear(x, y, z - 1)) {
                    ++clear;
                }
                return clear > 1 && (block instanceof BlockFence || block instanceof BlockLog || block instanceof BlockLever || block instanceof BlockSign || block instanceof BlockLadder);
            }
        }
        return false;
    }

    protected boolean isSideClear(int x, int y, int z) {
        Material m = this.field_70170_p.func_147439_a(x, y, z).func_149688_o();
        return !m.func_76230_c() || m == Material.field_151584_j;
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (this.isInGround()) return;
            if (!((float)this.field_70173_aa < this.getMaxDistance())) return;
            WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:whip_crack", 1.0f, 0.2f);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            if (this.canGrabBlock(block, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e)) {
                this.setInGround(true);
                AxisAlignedBB box = block.func_149668_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (box != null) {
                    this.field_70165_t = box.field_72340_a + (box.field_72336_d - box.field_72340_a) / 2.0;
                    this.field_70163_u = box.field_72338_b + (box.field_72337_e - box.field_72338_b) / 2.0;
                    this.field_70161_v = box.field_72339_c + (box.field_72334_f - box.field_72339_c) / 2.0;
                    switch (mop.field_72310_e) {
                        case 5: {
                            this.field_70165_t = box.field_72336_d;
                            break;
                        }
                        case 4: {
                            this.field_70165_t = box.field_72340_a - 0.015;
                            break;
                        }
                        case 3: {
                            this.field_70161_v = box.field_72334_f;
                            break;
                        }
                        case 2: {
                            this.field_70161_v = box.field_72339_c - 0.015;
                            break;
                        }
                        case 1: {
                            this.field_70163_u = box.field_72337_e;
                            break;
                        }
                        case 0: {
                            this.field_70163_u = box.field_72338_b - 0.015;
                            break;
                        }
                    }
                } else {
                    this.field_70165_t = (double)mop.field_72311_b + 0.5;
                    this.field_70163_u = (double)mop.field_72312_c + 0.5;
                    this.field_70161_v = (double)mop.field_72309_d + 0.5;
                    switch (mop.field_72310_e) {
                        case 1: {
                            this.field_70163_u = (double)mop.field_72312_c + 1.0;
                            break;
                        }
                        case 0: {
                            this.field_70163_u = (double)mop.field_72312_c - 0.015;
                            break;
                        }
                    }
                }
                this.field_70180_af.func_75692_b(26, (Object)Float.valueOf((float)this.field_70165_t));
                this.field_70180_af.func_75692_b(27, (Object)Float.valueOf((float)this.field_70163_u));
                this.field_70180_af.func_75692_b(28, (Object)Float.valueOf((float)this.field_70161_v));
                this.hitX = mop.field_72311_b;
                this.hitY = mop.field_72312_c;
                this.hitZ = mop.field_72309_d;
                return;
            }
            if (this.canBreakBlock(block, block.func_149688_o(), mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e)) {
                if (this.field_70170_p.field_72995_K) return;
                boolean drop = this.func_85052_h() instanceof EntityPlayer ? !((EntityPlayer)this.func_85052_h()).field_71075_bZ.field_75098_d : true;
                this.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, drop);
                this.func_70106_y();
                return;
            }
            if (block.func_149688_o().func_76230_c()) {
                block.func_149670_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, (Entity)this);
                return;
            }
            block.func_149670_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, (Entity)this);
            return;
        }
        if (mop.field_72308_g == null) return;
        this.field_70170_p.func_72956_a(mop.field_72308_g, "zeldaswordskills:whip_crack", 1.0f, 1.0f);
        boolean inflictDamage = true;
        if (mop.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)mop.field_72308_g;
            if (this.func_85052_h() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.func_85052_h();
                if (this.lootTarget(player, target)) {
                    inflictDamage = target instanceof IEntityLootable ? ((IEntityLootable)target).isHurtOnTheft(player, this.getType()) : Config.getHurtOnSteal();
                } else if (target.func_70694_bm() != null && ZSSPlayerSkills.get(player).hasSkill(SkillBase.parry)) {
                    float yaw;
                    float chance = Parry.getDisarmModifier((EntityLivingBase)player, target);
                    for (yaw = target.field_70177_z - player.field_70177_z; yaw >= 360.0f; yaw -= 360.0f) {
                    }
                    while (yaw < 0.0f) {
                        yaw += 360.0f;
                    }
                    yaw = Math.abs(Math.abs(yaw) - 180.0f);
                    float mod = 0.5f - 0.25f * (yaw / 45.0f);
                    chance = 0.05f + chance * mod;
                    if (this.field_70170_p.field_73012_v.nextFloat() < chance) {
                        WorldUtils.dropHeldItem(target);
                        inflictDamage = false;
                    }
                }
            }
            if (inflictDamage && target.func_71124_b(3) != null) {
                inflictDamage = false;
            }
        }
        if (inflictDamage) {
            mop.field_72308_g.func_70097_a(this.getDamageSource(), this.getDamage());
        }
        this.func_70106_y();
    }

    private boolean lootTarget(EntityPlayer player, EntityLivingBase target) {
        if (target.getEntityData().func_74767_n("LootableEntityFlag")) {
            return false;
        }
        IEntityLootable lootable = target instanceof IEntityLootable ? (IEntityLootable)target : null;
        float lootChance = lootable != null ? lootable.getLootableChance(player, this.getType()) : LootableEntityRegistry.getEntityLootChance(target.getClass());
        lootChance *= Config.getWhipLootMultiplier();
        boolean wasItemStolen = false;
        if (this.field_70146_Z.nextFloat() < lootChance) {
            ItemStack loot;
            ItemStack itemStack = loot = lootable != null ? lootable.getEntityLoot(player, this.getType()) : LootableEntityRegistry.getEntityLoot(target.getClass());
            if (target instanceof EntitySpider && this.field_70146_Z.nextInt(25) == 0) {
                loot = new ItemStack(ZSSItems.skulltulaToken);
            }
            if (loot != null) {
                EntityItem item = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, loot);
                double dx = player.field_70165_t - this.field_70165_t;
                double dy = player.field_70163_u - this.field_70163_u;
                double dz = player.field_70161_v - this.field_70161_v;
                TargetUtils.setEntityHeading((Entity)item, dx, dy, dz, 1.0f, 1.0f, true);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)item);
                }
                player.func_71029_a((StatBase)ZSSAchievements.orcaThief);
                wasItemStolen = true;
            }
        }
        if ((lootable == null || lootable.onLootStolen(player, wasItemStolen)) && !this.field_70170_p.field_72995_K) {
            target.getEntityData().func_74757_a("LootableEntityFlag", true);
        }
        return wasItemStolen;
    }

    public void func_70071_h_() {
        if (this.isInGround()) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            super.func_70030_z();
        } else {
            super.func_70071_h_();
        }
        if (this.canUpdate()) {
            if (this.isInGround() && this.field_70173_aa < 6000) {
                ++this.ticksInGround;
                if (this.shouldSwing()) {
                    this.swingThrower();
                }
            } else if ((float)this.field_70173_aa > this.getMaxDistance()) {
                WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:whip_crack", 0.5f, 0.2f);
                this.func_70106_y();
            }
        } else {
            this.func_70106_y();
        }
    }

    private boolean shouldSwing() {
        Block block = this.field_70170_p.func_147439_a(this.hitX, this.hitY, this.hitZ);
        if (block.func_149688_o() == Material.field_151579_a) {
            this.func_70106_y();
            return false;
        }
        if (block instanceof IWhipBlock) {
            Event.Result result = ((IWhipBlock)block).shouldSwing(this, this.field_70170_p, this.hitX, this.hitY, this.hitZ, this.ticksInGround);
            switch (result) {
                case ALLOW: {
                    return true;
                }
                case DENY: {
                    return false;
                }
            }
        }
        if (this.field_70128_L) {
            return false;
        }
        if (block instanceof BlockLever) {
            if (this.ticksInGround > 10 && !this.field_70170_p.field_72995_K) {
                WorldUtils.activateButton(this.field_70170_p, block, this.hitX, this.hitY, this.hitZ);
                this.func_70106_y();
            }
            return false;
        }
        if (this.field_70170_p.field_72995_K && this.swingVec == null && this.func_85052_h() != null) {
            return this.func_85052_h().field_70163_u < (double)this.field_70180_af.func_111145_d(27);
        }
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_85052_h() instanceof EntityPlayer && this.func_85052_h() instanceof EntityPlayerMP && !this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendTo(new UnpressKeyPacket(-99), (EntityPlayerMP)this.func_85052_h());
        }
    }

    protected boolean canUpdate() {
        EntityLivingBase thrower = this.func_85052_h();
        if (!this.field_70128_L && thrower instanceof EntityPlayer && ((EntityPlayer)thrower).func_71039_bw()) {
            return thrower.func_70694_bm() != null && thrower.func_70694_bm().func_77973_b() instanceof ItemWhip;
        }
        return false;
    }

    protected void swingThrower() {
        EntityLivingBase thrower = this.func_85052_h();
        if (thrower != null && !thrower.field_70122_E && this.isInGround() && thrower.field_70170_p.field_72995_K) {
            float x = this.field_70180_af.func_111145_d(26);
            float y = this.field_70180_af.func_111145_d(27);
            float z = this.field_70180_af.func_111145_d(28);
            if (this.swingTicks == 0 && this.swingVec == null && thrower.field_70181_x < 0.0) {
                this.swingVec = Vec3.func_72443_a((double)((double)x - thrower.field_70165_t), (double)((double)y - (thrower.field_70163_u + (double)thrower.func_70047_e())), (double)((double)z - thrower.field_70161_v)).func_72432_b();
                this.dy = thrower.func_70011_f((double)x, (double)y, (double)z) / 7.0;
                double d = Math.min(thrower.func_70011_f((double)x, thrower.field_70163_u, (double)z), (double)this.getMaxDistance());
                this.swingTicks = MathHelper.func_76128_c((double)(((double)this.getMaxDistance() - d) / (double)this.getMaxDistance() * 8.0));
            }
            if (this.swingVec != null) {
                double sin = Math.sin(10.0 * (double)this.swingTicks * Math.PI / 180.0);
                double f = 0.8;
                thrower.field_70159_w = sin * this.swingVec.field_72450_a * f;
                thrower.field_70179_y = sin * this.swingVec.field_72449_c * f;
                thrower.field_70181_x = this.dy * -Math.sin(20.0 * (double)this.swingTicks * Math.PI / 180.0);
                MovingObjectPosition mop = TargetUtils.checkForImpact(this.field_70170_p, (Entity)thrower, (Entity)this, -(thrower.field_70130_N / 4.0f), false);
                if (mop != null && mop.field_72313_a != MovingObjectPosition.MovingObjectType.MISS) {
                    thrower.field_70159_w = -thrower.field_70159_w * 0.15;
                    thrower.field_70181_x = -thrower.field_70181_x * 0.15;
                    thrower.field_70179_y = -thrower.field_70179_y * 0.15;
                    this.swingVec = null;
                }
                ++this.swingTicks;
                if (thrower.field_70143_R > 0.0f && thrower.field_70181_x < 0.0) {
                    PacketDispatcher.sendToServer(new FallDistancePacket((Entity)thrower, -0.467f));
                    thrower.field_70143_R -= 0.467f;
                }
            } else if (this.swingTicks > 0) {
                if (thrower.func_70092_e((double)x, thrower.field_70163_u, (double)z) > 1.0) {
                    double dx = (double)x - thrower.field_70165_t;
                    double dz = (double)z - thrower.field_70161_v;
                    thrower.field_70159_w = 0.15 * dx;
                    thrower.field_70179_y = 0.15 * dz;
                }
                if (thrower.field_70163_u < (double)y - (double)this.getMaxDistance() / 2.0) {
                    thrower.field_70181_x = 0.0;
                }
                ++this.swingTicks;
                PacketDispatcher.sendToServer(new FallDistancePacket((Entity)thrower, 0.0f));
                thrower.field_70143_R = 0.0f;
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("hitPosX", this.field_70180_af.func_111145_d(26));
        compound.func_74776_a("hitPosY", this.field_70180_af.func_111145_d(27));
        compound.func_74776_a("hitPosZ", this.field_70180_af.func_111145_d(28));
        compound.func_74768_a("hitX", this.hitX);
        compound.func_74768_a("hitY", this.hitY);
        compound.func_74768_a("hitZ", this.hitZ);
        compound.func_74774_a("customInGround", (byte)(this.isInGround() ? 1 : 0));
        compound.func_74768_a("whipType", this.getType().ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_75692_b(26, (Object)Float.valueOf(compound.func_74760_g("hitPosX")));
        this.field_70180_af.func_75692_b(27, (Object)Float.valueOf(compound.func_74760_g("hitPosY")));
        this.field_70180_af.func_75692_b(28, (Object)Float.valueOf(compound.func_74760_g("hitPosZ")));
        this.hitX = compound.func_74762_e("hitX");
        this.hitY = compound.func_74762_e("hitY");
        this.hitZ = compound.func_74762_e("hitZ");
        this.field_70180_af.func_75692_b(22, (Object)compound.func_74779_i("ownerName"));
        this.field_70180_af.func_75692_b(24, (Object)IWhipBlock.WhipType.values()[compound.func_74762_e("whipType") % IWhipBlock.WhipType.values().length]);
        this.field_70180_af.func_75692_b(25, (Object)compound.func_74771_c("customInGround"));
    }
}

