/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityMobThrowable
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private int throwerId;
    private float damage;
    private float gravity = 0.03f;

    public EntityMobThrowable(World world) {
        super(world);
    }

    public EntityMobThrowable(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityMobThrowable(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityMobThrowable(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter);
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = target.field_70165_t - shooter.field_70165_t;
        double d1 = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            this.field_70129_M = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1 + (double)f4, d2, velocity, wobble);
        }
    }

    public EntityLivingBase func_85052_h() {
        EntityLivingBase thrower = super.func_85052_h();
        if (thrower == null) {
            Entity entity = this.field_70170_p.func_73045_a(this.throwerId);
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }
        return thrower;
    }

    public float getDamage() {
        return this.damage;
    }

    public EntityMobThrowable setDamage(float amount) {
        this.damage = amount;
        return this;
    }

    public EntityMobThrowable setProjectileVelocity(float velocity) {
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 0.0f);
        return this;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    public EntityMobThrowable setGravityVelocity(float amount) {
        this.gravity = amount;
        return this;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!(this.gravityCheck() && !(this.field_70163_u > 255.0) || this.field_70170_p.field_72995_K)) {
            this.func_70106_y();
        }
    }

    protected boolean gravityCheck() {
        return this.func_70185_h() > 0.0f || this.field_70173_aa < 60;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("throwerId", this.func_85052_h() == null ? -1 : this.func_85052_h().func_145782_y());
        compound.func_74776_a("damage", this.damage);
        compound.func_74776_a("gravity", this.gravity);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.throwerId = compound.func_74762_e("throwerId");
        this.damage = compound.func_74760_g("damage");
        this.gravity = compound.func_74760_g("gravity");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.gravity);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.gravity = buffer.readFloat();
    }
}

