/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.entity.IReflectable;
import zeldaswordskills.api.entity.MagicType;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ItemMagicRod;
import zeldaswordskills.util.WorldUtils;

public class EntityMagicSpell
extends EntityMobThrowable
implements IReflectable {
    private MagicType type = MagicType.FIRE;
    private boolean canGrief = true;
    private float radius = 2.0f;
    private boolean bypassesArmor;
    private float reflectChance = -1.0f;
    private boolean spawnParticles = true;

    public EntityMagicSpell(World world) {
        super(world);
        this.setGravityVelocity(0.02f);
    }

    public EntityMagicSpell(World world, EntityLivingBase entity) {
        super(world, entity);
        this.setGravityVelocity(0.02f);
        this.resetSize();
    }

    public EntityMagicSpell(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setGravityVelocity(0.02f);
        this.resetSize();
    }

    public EntityMagicSpell(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setGravityVelocity(0.02f);
        this.resetSize();
    }

    private void resetSize() {
        float f = (float)((double)this.radius / 4.0);
        this.func_70105_a(f, f);
    }

    public MagicType getType() {
        return this.type;
    }

    public EntityMagicSpell setType(MagicType type) {
        this.type = type;
        return this;
    }

    public EntityMagicSpell disableGriefing() {
        this.canGrief = false;
        return this;
    }

    public EntityMagicSpell setDamageBypassesArmor() {
        this.bypassesArmor = true;
        return this;
    }

    public float getArea() {
        return this.radius;
    }

    public EntityMagicSpell setArea(float radius) {
        this.radius = radius;
        this.resetSize();
        return this;
    }

    public EntityMagicSpell setReflectChance(float chance) {
        this.reflectChance = chance;
        return this;
    }

    public EntityMagicSpell disableTrailingParticles() {
        this.spawnParticles = false;
        return this;
    }

    protected DamageSource getDamageSource() {
        DamageSource source = new DamageUtils.DamageSourceFireIndirect("blast.fire", (Entity)this, (Entity)this.func_85052_h(), true).func_76349_b().func_82726_p();
        switch (this.getType()) {
            case ICE: {
                source = new DamageUtils.DamageSourceIceIndirect("blast.ice", (Entity)this, (Entity)this.func_85052_h(), 50, 1, true).setStunDamage(60, 10, true).func_76349_b().func_82726_p();
                break;
            }
            case LIGHTNING: {
                source = new DamageUtils.DamageSourceShockIndirect("blast.lightning", (Entity)this, (Entity)this.func_85052_h(), 50, 1.0f, true).func_76349_b().func_82726_p();
                break;
            }
            case WIND: {
                source = new DamageUtils.DamageSourceBaseIndirect("blast.wind", (Entity)this, (Entity)this.func_85052_h(), true).func_76349_b().func_82726_p();
                break;
            }
        }
        if (this.bypassesArmor) {
            source.func_76348_h();
        }
        return source;
    }

    @Override
    public float getReflectChance(ItemStack mirrorShield, EntityPlayer player, Entity shooter) {
        return this.reflectChance < 0.0f ? 1.0f - this.getArea() / 4.0f : this.reflectChance;
    }

    @Override
    public void onReflected(ItemStack mirrorShield, EntityPlayer player, Entity shooter, Entity oldEntity) {
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        MagicType type = this.getType();
        if (this.field_70170_p.field_72995_K && this.spawnParticles) {
            String particle = type.getTrailingParticle();
            boolean flag = type != MagicType.FIRE;
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_72869_a(particle, this.field_70165_t + this.field_70159_w * (double)i / 4.0, this.field_70163_u + this.field_70181_x * (double)i / 4.0, this.field_70161_v + this.field_70179_y * (double)i / 4.0, -this.field_70159_w * 0.25, -this.field_70181_x + (flag ? 0.1 : 0.0), -this.field_70179_y * 0.25);
            }
        } else if (this.field_70173_aa % type.getSoundFrequency() == 0) {
            this.field_70170_p.func_72956_a((Entity)this, type.getMovingSound(), type.getSoundVolume(this.field_70146_Z), type.getSoundPitch(this.field_70146_Z));
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        double x = mop.field_72308_g != null ? mop.field_72308_g.field_70165_t : (double)mop.field_72311_b + 0.5;
        double y = mop.field_72308_g != null ? mop.field_72308_g.field_70163_u : (double)mop.field_72312_c + 0.5;
        double z = mop.field_72308_g != null ? mop.field_72308_g.field_70161_v : (double)mop.field_72309_d + 0.5;
        float r = this.getArea();
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(x - (double)r), (double)(y - (double)r), (double)(z - (double)r), (double)(x + (double)r), (double)(y + (double)r), (double)(z + (double)r)));
        for (EntityLivingBase entity : list) {
            Block block;
            Vec3 vec31;
            Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - this.field_70159_w), (double)(this.field_70163_u - this.field_70181_x), (double)(this.field_70161_v - this.field_70179_y));
            MovingObjectPosition mop1 = this.field_70170_p.func_72933_a(vec3, vec31 = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
            if (mop1 != null && mop1.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = this.field_70170_p.func_147439_a(mop1.field_72311_b, mop1.field_72312_c, mop1.field_72309_d)).func_149688_o().func_76230_c() || !entity.func_70097_a(this.getDamageSource(), this.getDamage()) || entity.field_70128_L) continue;
            this.handlePostDamageEffects(entity);
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnImpactParticles("largeexplode", 4, -0.1f);
            this.spawnImpactParticles(this.getType().getTrailingParticle(), 16, this.getType() == MagicType.ICE ? 0.0f : -0.2f);
        } else {
            this.field_70170_p.func_72956_a((Entity)this, "random.explode", 2.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            if (this.canGrief && this.getType().affectsBlocks(this.field_70170_p, this.func_85052_h())) {
                HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>(WorldUtils.getAffectedBlocksList(this.field_70170_p, this.field_70146_Z, r, this.field_70165_t, this.field_70163_u, this.field_70161_v, null));
                ItemMagicRod.affectAllBlocks(this.field_70170_p, affectedBlocks, this.getType());
            }
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnImpactParticles(String particle, int n, float offsetY) {
        for (int i = 0; i < n; ++i) {
            double dx = this.field_70165_t - this.field_70159_w * (double)i / 4.0;
            double dy = this.field_70163_u - this.field_70181_x * (double)i / 4.0;
            double dz = this.field_70161_v - this.field_70159_w * (double)i / 4.0;
            this.field_70170_p.func_72869_a(particle, dx + (double)this.field_70146_Z.nextFloat() - 0.5, dy + (double)this.field_70146_Z.nextFloat() - 0.5, dz + (double)this.field_70146_Z.nextFloat() - 0.5, (double)(0.25f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(this.field_70146_Z.nextFloat() * 0.25f + offsetY), (double)(0.25f * (this.field_70146_Z.nextFloat() - 0.5f)));
        }
    }

    protected void handlePostDamageEffects(EntityLivingBase entity) {
        switch (this.getType()) {
            case ICE: {
                int i = MathHelper.func_76128_c((double)entity.field_70165_t);
                int j = MathHelper.func_76128_c((double)entity.field_70163_u);
                int k = MathHelper.func_76128_c((double)entity.field_70161_v);
                if (this.func_85052_h() instanceof EntityPlayer) {
                    this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150432_aD);
                    this.field_70170_p.func_147449_b(i, j + 1, k, Blocks.field_150432_aD);
                }
                this.field_70170_p.func_72908_a((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "dig.glass", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                break;
            }
            case FIRE: {
                if (entity.func_70045_F()) break;
                entity.func_70015_d((int)Math.ceil(this.getDamage()));
                break;
            }
            case WIND: {
                float f3;
                double power = Math.min(3.0, (double)this.getDamage() / 6.0);
                if (!(power > 0.0) || !((f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f)) break;
                double knockback = power * (double)0.6f / (double)f3;
                entity.func_70024_g(this.field_70159_w * knockback, 0.1, this.field_70179_y * knockback);
                break;
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("magicType", this.getType().ordinal());
        compound.func_74776_a("areaOfEffect", this.getArea());
        compound.func_74776_a("reflectChance", this.reflectChance);
        compound.func_74757_a("bypassesArmor", this.bypassesArmor);
        compound.func_74757_a("canGrief", this.canGrief);
        compound.func_74757_a("spawnParticles", this.spawnParticles);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(MagicType.values()[compound.func_74762_e("magicType") % MagicType.values().length]);
        this.setArea(compound.func_74760_g("areaOfEffect"));
        this.reflectChance = compound.func_74760_g("reflectChance");
        this.bypassesArmor = compound.func_74767_n("bypassesArmor");
        this.canGrief = compound.func_74767_n("canGrief");
        this.spawnParticles = compound.func_74767_n("spawnParticles");
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.type.ordinal());
        buffer.writeFloat(this.radius);
        buffer.writeBoolean(this.spawnParticles);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        super.readSpawnData(buffer);
        this.type = MagicType.values()[buffer.readInt() % MagicType.values().length];
        this.radius = buffer.readFloat();
        this.spawnParticles = buffer.readBoolean();
    }
}

