/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemHookShot;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.UnpressKeyPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.TargetUtils;

public class EntityHookShot
extends EntityThrowable {
    protected static final int THROWER_INDEX = 22;
    protected static final int TARGET_INDEX = 23;
    protected static final int SHOTTYPE_INDEX = 24;
    protected static final int IN_GROUND_INDEX = 25;
    public static final int HIT_POS_X = 26;
    public static final int HIT_POS_Y = 27;
    public static final int HIT_POS_Z = 28;
    protected boolean reachedHook = false;

    public EntityHookShot(World world) {
        super(world);
    }

    public EntityHookShot(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityHookShot(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.25f, 0.25f);
        this.field_70180_af.func_75682_a(22, (Object)"");
        this.field_70180_af.func_75682_a(23, (Object)-1);
        this.field_70180_af.func_75682_a(24, (Object)IHookable.HookshotType.WOOD_SHOT.ordinal());
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(27, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(28, (Object)Float.valueOf(0.0f));
    }

    public IHookable.HookshotType getType() {
        return IHookable.HookshotType.values()[this.field_70180_af.func_75679_c(24) % IHookable.HookshotType.values().length];
    }

    public EntityHookShot setType(IHookable.HookshotType type) {
        this.field_70180_af.func_75692_b(24, (Object)type.ordinal());
        return this;
    }

    public int getMaxDistance() {
        return Config.getHookshotRange() * (this.getType().isExtended() ? 2 : 1);
    }

    public void setThrower(EntityPlayer player) {
        this.field_70180_af.func_75692_b(22, (Object)(player != null ? player.func_70005_c_() : ""));
    }

    protected Entity getTarget() {
        int id = this.field_70180_af.func_75679_c(23);
        return id == -1 ? null : this.field_70170_p.func_73045_a(id);
    }

    protected void setTarget(Entity entity) {
        this.field_70180_af.func_75692_b(23, (Object)(entity != null ? entity.func_145782_y() : -1));
    }

    public EntityLivingBase func_85052_h() {
        String name = this.field_70180_af.func_75681_e(22);
        return name.equals("") ? null : this.field_70170_p.func_72924_a(name);
    }

    public boolean isInGround() {
        return (this.field_70180_af.func_75683_a(25) & 1) == 1;
    }

    protected void setInGround(boolean isInGround) {
        this.field_70180_af.func_75692_b(25, (Object)(isInGround ? (byte)1 : 0));
        this.field_70193_a = isInGround;
    }

    protected DamageSource getDamageSource() {
        return new DamageUtils.DamageSourceBaseIndirect("hookshot", (Entity)this, (Entity)this.func_85052_h()).setStunDamage(50, 1, true).func_76349_b();
    }

    protected boolean canGrabBlock(Block block, int x, int y, int z, int side) {
        Material material = block.func_149688_o();
        Event.Result result = Event.Result.DEFAULT;
        if (block instanceof IHookable) {
            result = ((IHookable)block).canGrabBlock(this.getType(), this.field_70170_p, x, y, z, side);
            material = ((IHookable)block).getHookableMaterial(this.getType(), this.field_70170_p, x, y, z);
        } else if (Config.allowHookableOnly()) {
            return false;
        }
        switch (result) {
            case DEFAULT: {
                switch (this.getType()) {
                    case WOOD_SHOT: 
                    case WOOD_SHOT_EXT: {
                        return material == Material.field_151575_d;
                    }
                    case CLAW_SHOT: 
                    case CLAW_SHOT_EXT: {
                        return material == Material.field_151576_e || block instanceof BlockPane && material == Material.field_151573_f;
                    }
                    case MULTI_SHOT: 
                    case MULTI_SHOT_EXT: {
                        return material == Material.field_151575_d || material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151571_B;
                    }
                }
            }
        }
        return result == Event.Result.ALLOW;
    }

    protected boolean canDestroyBlock(Block block, int x, int y, int z, int side) {
        Event.Result result = Event.Result.DEFAULT;
        if (block instanceof IHookable) {
            result = ((IHookable)block).canDestroyBlock(this.getType(), this.field_70170_p, x, y, z, side);
        } else if (Config.allowHookableOnly()) {
            return false;
        }
        switch (result) {
            case DEFAULT: {
                boolean isBreakable = block.func_149712_f(this.field_70170_p, x, y, z) >= 0.0f;
                boolean canPlayerEdit = false;
                if (this.func_85052_h() instanceof EntityPlayer) {
                    canPlayerEdit = ((EntityPlayer)this.func_85052_h()).field_71075_bZ.field_75099_e && Config.canHookshotBreakBlocks();
                }
                Material m = block.func_149688_o();
                return isBreakable && canPlayerEdit && (m == Material.field_151592_s || m == Material.field_151575_d && this.getType().ordinal() / 2 == IHookable.HookshotType.CLAW_SHOT.ordinal() / 2);
            }
        }
        return result == Event.Result.ALLOW;
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.getTarget() == null) {
            Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            if (!block.func_149688_o().func_76230_c()) {
                return;
            }
            if (block.func_149688_o() != Material.field_151579_a) {
                block.func_149670_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, (Entity)this);
            }
            if (!this.isInGround() && this.field_70173_aa < this.getMaxDistance()) {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                if (this.canGrabBlock(block, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e)) {
                    this.setInGround(true);
                    this.field_70165_t = (double)mop.field_72311_b + 0.5;
                    this.field_70163_u = (double)mop.field_72312_c + 0.5;
                    this.field_70161_v = (double)mop.field_72309_d + 0.5;
                    switch (mop.field_72310_e) {
                        case 5: {
                            this.field_70165_t += 0.5;
                            break;
                        }
                        case 4: {
                            this.field_70165_t -= 0.515;
                            break;
                        }
                        case 3: {
                            this.field_70161_v += 0.5;
                            break;
                        }
                        case 2: {
                            this.field_70161_v -= 0.515;
                            break;
                        }
                        case 1: {
                            this.field_70163_u = (double)mop.field_72312_c + 1.0;
                            break;
                        }
                        case 0: {
                            this.field_70163_u = mop.field_72312_c;
                        }
                    }
                    this.field_70180_af.func_75692_b(26, (Object)Float.valueOf((float)this.field_70165_t));
                    this.field_70180_af.func_75692_b(27, (Object)Float.valueOf((float)this.field_70163_u));
                    this.field_70180_af.func_75692_b(28, (Object)Float.valueOf((float)this.field_70161_v));
                } else if (!this.field_70170_p.field_72995_K) {
                    if (this.canDestroyBlock(block, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, mop.field_72310_e)) {
                        this.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, false);
                    }
                    this.func_70106_y();
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72956_a((Entity)this, block.field_149762_H.func_150498_e(), 1.0f, 1.0f);
            } else {
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian(), this.field_70146_Z.nextGaussian());
                }
            }
        } else if (mop.field_72308_g != null && this.getTarget() == null) {
            EntityPlayer player;
            mop.field_72308_g.func_70097_a(this.getDamageSource(), 1.0f);
            this.field_70170_p.func_72956_a(mop.field_72308_g, "random.wood_click", 1.0f, 1.0f);
            EntityPlayer entityPlayer = player = this.func_85052_h() instanceof EntityPlayer ? (EntityPlayer)this.func_85052_h() : null;
            if (player != null && player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() == ZSSItems.bootsHeavy && player.func_70093_af()) {
                this.setTarget(mop.field_72308_g);
                this.field_70159_w = -this.field_70159_w;
                this.field_70181_x = -this.field_70181_x;
                this.field_70179_y = -this.field_70179_y;
            } else {
                this.func_70106_y();
            }
        }
    }

    public void func_70071_h_() {
        if (this.isInGround()) {
            super.func_70030_z();
        } else {
            super.func_70071_h_();
        }
        if (this.canUpdate()) {
            if (this.field_70173_aa > this.getMaxDistance() && !this.isInGround() && this.getTarget() == null || this.field_70173_aa > this.getMaxDistance() * 8) {
                if (this.field_70170_p.field_72995_K && this.func_85052_h() instanceof EntityPlayer && Config.enableHookshotSound) {
                    ((EntityPlayer)this.func_85052_h()).func_85030_a("random.wood_click", 1.0f, 1.0f);
                }
                this.func_70106_y();
            } else if (this.getTarget() != null) {
                this.pullTarget();
            } else {
                this.pullThrower();
            }
        } else {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_85052_h() instanceof EntityPlayerMP && !this.field_70170_p.field_72995_K) {
            PacketDispatcher.sendTo(new UnpressKeyPacket(-99), (EntityPlayerMP)this.func_85052_h());
        }
    }

    protected boolean canUpdate() {
        EntityLivingBase thrower = this.func_85052_h();
        if (!this.field_70128_L && thrower instanceof EntityPlayer && ((EntityPlayer)thrower).func_71039_bw()) {
            ItemStack stack = thrower.func_70694_bm();
            return stack.func_77973_b() instanceof ItemHookShot && ((ItemHookShot)stack.func_77973_b()).getType(stack.func_77960_j()) == this.getType();
        }
        return false;
    }

    protected void pullThrower() {
        EntityLivingBase thrower = this.func_85052_h();
        if (thrower != null && this.isInGround()) {
            thrower.field_70143_R = 0.0f;
            double d = thrower.func_70092_e((double)this.field_70180_af.func_111145_d(26), (double)this.field_70180_af.func_111145_d(27), (double)this.field_70180_af.func_111145_d(28));
            if (!this.reachedHook) {
                boolean bl = this.reachedHook = d < 1.0;
            }
            if (this.reachedHook && thrower.func_70093_af()) {
                thrower.field_70179_y = 0.0;
                thrower.field_70159_w = 0.0;
                thrower.field_70181_x = -0.15;
            } else if (this.reachedHook && d < 1.0) {
                thrower.field_70179_y = 0.0;
                thrower.field_70181_x = 0.0;
                thrower.field_70159_w = 0.0;
            } else {
                double dx = 0.15 * ((double)this.field_70180_af.func_111145_d(26) - thrower.field_70165_t);
                double dy = 0.15 * ((double)(this.field_70180_af.func_111145_d(27) + this.field_70131_O / 3.0f) - thrower.field_70163_u + 0.05);
                double dz = 0.15 * ((double)this.field_70180_af.func_111145_d(28) - thrower.field_70161_v);
                TargetUtils.setEntityHeading((Entity)thrower, dx, dy, dz, 1.0f, 1.0f, true);
            }
        }
    }

    protected void pullTarget() {
        Entity target = this.getTarget();
        EntityLivingBase thrower = this.func_85052_h();
        if (target != null && thrower != null) {
            if (target instanceof EntityLivingBase) {
                ZSSEntityInfo.get((EntityLivingBase)target).removeBuff(Buff.STUN);
            }
            double d = target.func_70092_e(thrower.field_70165_t, thrower.field_70163_u, thrower.field_70161_v);
            if (!this.reachedHook) {
                boolean bl = this.reachedHook = d < 9.0;
            }
            if (this.reachedHook && d < 9.0) {
                target.field_70179_y = 0.0;
                target.field_70181_x = 0.0;
                target.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            } else {
                double dx = 0.15 * (thrower.field_70165_t - target.field_70165_t);
                double dy = 0.15 * (thrower.field_70163_u + (double)(this.field_70131_O / 3.0f) - target.field_70163_u);
                double dz = 0.15 * (thrower.field_70161_v - target.field_70161_v);
                if (target instanceof EntityLivingBase) {
                    double resist = 1.0 - ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
                    dx *= resist;
                    dy *= resist;
                    dz *= resist;
                }
                TargetUtils.setEntityHeading(target, dx, dy, dz, 1.0f, 1.0f, true);
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("hitPosX", this.field_70180_af.func_111145_d(26));
        compound.func_74776_a("hitPosY", this.field_70180_af.func_111145_d(27));
        compound.func_74776_a("hitPosZ", this.field_70180_af.func_111145_d(28));
        compound.func_74774_a("customInGround", (byte)(this.isInGround() ? 1 : 0));
        compound.func_74774_a("reachedHook", (byte)(this.reachedHook ? 1 : 0));
        compound.func_74774_a("shotType", (byte)this.getType().ordinal());
        compound.func_74768_a("shotTarget", this.getTarget() != null ? this.getTarget().func_145782_y() : -1);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_75692_b(26, (Object)Float.valueOf(compound.func_74760_g("hitPosX")));
        this.field_70180_af.func_75692_b(27, (Object)Float.valueOf(compound.func_74760_g("hitPosY")));
        this.field_70180_af.func_75692_b(28, (Object)Float.valueOf(compound.func_74760_g("hitPosZ")));
        this.field_70180_af.func_75692_b(25, (Object)compound.func_74771_c("customInGround"));
        this.reachedHook = compound.func_74771_c("reachedHook") == 1;
        this.field_70180_af.func_75692_b(22, (Object)compound.func_74779_i("ownerName"));
        this.field_70180_af.func_75692_b(24, (Object)IHookable.HookshotType.values()[compound.func_74771_c("shotType") % IHookable.HookshotType.values().length]);
        this.field_70180_af.func_75692_b(23, (Object)compound.func_74762_e("shotTarget"));
    }
}

