/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.block.IBoomerangBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class EntityBoomerang
extends EntityMobThrowable {
    private static final int ITEM_DATAWATCHER_INDEX = 22;
    private static final int TARGET_DATAWATCHER_INDEX = 23;
    private int distance = 12;
    private static final int LIFESPAN = 100;
    private int slot;
    private boolean captureAll = false;
    private List<ItemStack> capturedItems = new ArrayList<ItemStack>();
    private int xp = 0;

    public EntityBoomerang(World world) {
        super(world);
    }

    public EntityBoomerang(World world, EntityLivingBase entity) {
        super(world, entity);
    }

    public EntityBoomerang(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityBoomerang(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setTarget(target);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(23, (Object)-1);
        this.field_70180_af.func_82709_a(22, 5);
    }

    public EntityBoomerang setInvStack(ItemStack stack, int slot) {
        this.field_70180_af.func_75692_b(22, (Object)stack);
        this.slot = slot;
        return this;
    }

    public ItemStack getBoomerang() {
        return this.field_70180_af.func_82710_f(22);
    }

    public EntityBoomerang setRange(int range) {
        this.distance = range;
        return this;
    }

    public EntityBoomerang setCaptureAll(boolean captureAll) {
        this.captureAll = captureAll;
        return this;
    }

    protected EntityLivingBase getTarget() {
        int id = this.field_70180_af.func_75679_c(23);
        return id > 0 ? (EntityLivingBase)this.field_70170_p.func_73045_a(id) : null;
    }

    public void setTarget(EntityLivingBase target) {
        this.field_70180_af.func_75692_b(23, (Object)(target != null ? target.func_145782_y() : -1));
    }

    protected DamageSource getDamageSource() {
        return new DamageUtils.DamageSourceBaseIndirect("boomerang", (Entity)this, (Entity)this.func_85052_h()).setStunDamage(200, 5, true).func_76349_b();
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    protected float getVelocity() {
        return this.func_70182_d();
    }

    protected float func_70182_d() {
        return 1.25f;
    }

    @Override
    public void func_70071_h_() {
        --this.distance;
        if (this.shouldDrop() && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getBoomerang()));
            this.dropXpOrbs();
            this.releaseDrops(null);
            this.func_70106_y();
        } else {
            if (this.field_70173_aa % 4 == 0) {
                WorldUtils.playSoundAtEntity((Entity)this, "zeldaswordskills:swordmiss", 0.4f, 0.5f);
            }
            this.captureDrops();
            this.captureXpOrbs();
            this.destroyVines();
            this.updateMotion();
            super.func_70071_h_();
        }
    }

    private boolean shouldDrop() {
        return this.distance < -100 || this.func_85052_h() == null || !this.func_85052_h().func_70089_S();
    }

    protected void updateMotion() {
        EntityLivingBase target;
        if (this.distance < 0 && this.getTarget() != this.func_85052_h()) {
            this.setTarget(this.func_85052_h());
        }
        if ((target = this.getTarget()) != null) {
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.field_70121_D.field_72338_b + (double)target.field_70131_O - this.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            this.func_70186_c(d0, d1, d2, this.getVelocity(), 0.0f);
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.distance < 0 && !this.field_70170_p.field_72995_K) {
            if (player.field_71071_by.func_70301_a(this.slot) == null) {
                player.field_71071_by.func_70299_a(this.slot, this.getBoomerang());
            } else {
                int i = player.field_71071_by.func_70447_i();
                if (i >= 0) {
                    player.field_71071_by.func_70299_a(i, player.field_71071_by.func_70301_a(this.slot));
                    player.field_71071_by.func_70299_a(this.slot, this.getBoomerang());
                } else {
                    PlayerUtils.addItemToInventory(player, this.getBoomerang());
                }
            }
            this.dropXpOrbs();
            this.releaseDrops(player);
            this.func_70106_y();
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mop.field_72308_g != this.func_85052_h() && mop.field_72308_g.func_70097_a(this.getDamageSource(), this.getDamage())) {
                this.func_85030_a("game.neutral.hurt", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (mop.field_72308_g instanceof EntityLivingBase && this.func_85052_h() != null) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)mop.field_72308_g), (Entity)this.func_85052_h());
                    EnchantmentHelper.func_151385_b((EntityLivingBase)this.func_85052_h(), (Entity)mop.field_72308_g);
                }
            }
        } else {
            Block block = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            boolean flag = block.func_149688_o().func_76230_c();
            if (block instanceof IBoomerangBlock) {
                flag = ((IBoomerangBlock)block).onBoomerangCollided(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, this);
            } else {
                block.func_149670_a(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, (Entity)this);
                float hardness = block.func_149712_f(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (block.func_149688_o() != Material.field_151579_a && hardness >= 0.0f && hardness < 0.1f && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_147480_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, true);
                } else if (block instanceof BlockButton || block instanceof BlockLever && this.getBoomerang() != null && this.getBoomerang().func_77973_b() == ZSSItems.boomerangMagic) {
                    WorldUtils.activateButton(this.field_70170_p, block, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                    flag = true;
                }
            }
            if (flag && !this.field_70145_X) {
                this.field_70145_X = true;
                this.distance = Math.min(this.distance, 0);
                this.func_70186_c(-this.field_70159_w, -this.field_70181_x, -this.field_70179_y, this.getVelocity(), 1.0f);
            }
        }
    }

    public boolean captureItem(EntityItem item) {
        if (item.func_70089_S()) {
            if (this.field_70153_n == null) {
                item.func_70078_a((Entity)this);
                return true;
            }
            if (this.captureAll && item != this.field_70153_n) {
                this.capturedItems.add(item.func_92059_d());
                item.func_70106_y();
                return true;
            }
        }
        return false;
    }

    private void captureDrops() {
        if (this.field_70153_n == null || this.captureAll) {
            List items = this.field_70170_p.func_72872_a(EntityItem.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
            for (EntityItem item : items) {
                if (!this.captureItem(item) || this.captureAll) continue;
                return;
            }
        }
    }

    private void releaseDrops(EntityPlayer player) {
        for (ItemStack stack : this.capturedItems) {
            if (player != null) {
                PlayerUtils.addItemToInventory(player, stack);
                continue;
            }
            WorldUtils.spawnItemWithRandom(this.field_70170_p, stack, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void captureXpOrbs() {
        List orbs = this.field_70170_p.func_72872_a(EntityXPOrb.class, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
        for (EntityXPOrb orb : orbs) {
            this.xp += orb.func_70526_d();
            this.field_70170_p.func_72956_a((Entity)this, "random.orb", 0.1f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
            orb.func_70106_y();
        }
    }

    private void dropXpOrbs() {
        int j;
        for (int i = this.xp; i > 0; i -= j) {
            j = EntityXPOrb.func_70527_a((int)i);
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            this.field_70170_p.func_72956_a((Entity)this, "random.orb", 0.1f, 0.5f * ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.8f));
        }
    }

    private void destroyVines() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_147439_a(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o() == Material.field_151582_l) {
            this.field_70170_p.func_147480_a(i, j, k, true);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("distance", this.distance);
        NBTTagCompound item = new NBTTagCompound();
        this.getBoomerang().func_77955_b(item);
        compound.func_74782_a("item", (NBTBase)item);
        compound.func_74768_a("invSlot", this.slot);
        compound.func_74768_a("target", this.getTarget() != null ? this.getTarget().func_145782_y() : -1);
        compound.func_74757_a("captureAll", this.captureAll);
        if (this.captureAll) {
            NBTTagList items = new NBTTagList();
            for (ItemStack stack : this.capturedItems) {
                NBTTagCompound dropNBT = new NBTTagCompound();
                stack.func_77955_b(dropNBT);
                items.func_74742_a((NBTBase)dropNBT);
            }
            compound.func_74782_a("items", (NBTBase)items);
        }
        compound.func_74768_a("capturedXP", this.xp);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.distance = compound.func_74762_e("distance");
        this.field_70180_af.func_75692_b(22, (Object)ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("item")));
        this.slot = compound.func_74762_e("invSlot");
        this.field_70180_af.func_75692_b(23, (Object)(compound.func_74764_b("target") ? compound.func_74762_e("target") : -1));
        this.captureAll = compound.func_74767_n("captureAll");
        if (this.captureAll) {
            NBTTagList items = compound.func_150295_c("items", (int)compound.func_74732_a());
            for (int i = 0; i < items.func_74745_c(); ++i) {
                this.capturedItems.add(ItemStack.func_77949_a((NBTTagCompound)items.func_150305_b(i)));
            }
        }
        this.xp = compound.func_74762_e("capturedXP");
    }
}

