/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.projectile;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.projectile.EntityMobThrowable;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;

public class EntityBomb
extends EntityMobThrowable
implements IEntityBombIngestible {
    private int fuseTime = 24;
    private float radius = 0.0f;
    private boolean canGrief = true;
    protected float motionFactor = 1.0f;
    protected float destructionFactor = 1.0f;
    private static final int BOMBTYPE_DATAWATCHER_INDEX = 22;

    public EntityBomb(World world) {
        super(world);
        this.setGravityVelocity(0.075f);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBomb(World world, EntityLivingBase entity) {
        super(world, entity);
        this.setGravityVelocity(0.075f);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setGravityVelocity(0.075f);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBomb(World world, EntityLivingBase shooter, EntityLivingBase target, float velocity, float wobble) {
        super(world, shooter, target, velocity, wobble);
        this.setGravityVelocity(0.075f);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.setDamage(0.0f);
        this.field_70180_af.func_75682_a(22, (Object)BombType.BOMB_STANDARD.ordinal());
    }

    @Override
    public float getExplosionDamage(Entity entity) {
        return this.getDamage();
    }

    @Override
    public EntityBomb setExplosionDamage(float damage) {
        return (EntityBomb)this.setDamage(damage);
    }

    @Override
    public float getExplosionRadius(Entity entity) {
        return this.getRadius();
    }

    @Override
    public EntityBomb setExplosionRadius(float radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public int getFuseTime(Entity entity) {
        return this.fuseTime;
    }

    @Override
    public EntityBomb setFuseTime(int time) {
        this.fuseTime = Math.max(time, 1);
        return this;
    }

    public EntityBomb addTime(int time) {
        this.fuseTime = Math.max(this.fuseTime + time, this.fuseTime);
        return this;
    }

    public float getRadius() {
        return this.radius > 0.0f ? this.radius : ItemBomb.getRadius(this.getType());
    }

    @Override
    public float getMotionFactor() {
        return this.motionFactor;
    }

    public EntityBomb setMotionFactor(float amount) {
        this.motionFactor = amount;
        return this;
    }

    @Override
    public float getDestructionFactor() {
        return this.destructionFactor;
    }

    public EntityBomb setDestructionFactor(float factor) {
        this.destructionFactor = factor;
        return this;
    }

    public boolean canGriefAdventureMode() {
        return Config.canGriefAdventure();
    }

    public EntityBomb setNoGrief() {
        this.canGrief = false;
        return this;
    }

    @Override
    public BombType getType() {
        return BombType.values()[this.field_70180_af.func_75679_c(22)];
    }

    public EntityBomb setType(BombType type) {
        this.field_70180_af.func_75692_b(22, (Object)type.ordinal());
        return this;
    }

    @Override
    public boolean hasPostExplosionEffect() {
        return this.getType() != BombType.BOMB_FLOWER || this.func_85052_h() == null;
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.field_70121_D;
    }

    @Override
    public void func_70071_h_() {
        boolean inFire;
        super.func_70071_h_();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= (double)0.04f;
        this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.field_70121_D.field_72338_b + this.field_70121_D.field_72337_e) / 2.0, this.field_70161_v);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            f = 0.58800006f;
            Block block = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            if (block.func_149688_o() != Material.field_151579_a) {
                f = block.field_149765_K * 0.98f;
            }
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= -0.5;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 5 && this.wasBombEaten()) {
            this.func_70106_y();
            return;
        }
        Material material = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)).func_149688_o();
        boolean bl = inFire = this.func_70027_ad() || material == Material.field_151587_i || material == Material.field_151581_o || this.field_70170_p.func_147470_e(this.field_70121_D);
        if (this.isDud(inFire)) {
            this.fuseTime += 10;
            this.disarm(this.field_70170_p);
        } else if (this.field_70173_aa % 20 == 0) {
            this.func_85030_a("zeldaswordskills:bomb_fuse", 1.0f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        if (!this.field_70170_p.field_72995_K && this.shouldExplode(inFire)) {
            CustomExplosion.createExplosion(this, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getRadius(), this.getDamage(), this.canGrief);
            this.func_70106_y();
        }
    }

    private boolean wasBombEaten() {
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(0.5, 0.5, 0.5));
        for (EntityLivingBase entity : entities) {
            Event.Result result;
            if (!entity.func_70089_S()) continue;
            Event.Result result2 = result = entity instanceof IEntityBombEater ? ((IEntityBombEater)entity).ingestBomb(this) : Event.Result.DENY;
            if (result == Event.Result.ALLOW) {
                return true;
            }
            if (result != Event.Result.DEFAULT || !ZSSEntityInfo.get(entity).onBombIngested(this)) continue;
            return true;
        }
        return false;
    }

    public boolean disarm(World world) {
        if (!world.field_72995_K && this.func_70089_S() && this.fuseTime > 4) {
            this.func_70106_y();
            EntityItem bomb = new EntityItem(world, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ZSSItems.bomb, 1, this.getType().ordinal()));
            bomb.field_145804_b = 40;
            bomb.field_70159_w = this.field_70159_w;
            bomb.field_70181_x = this.field_70181_x;
            bomb.field_70179_y = this.field_70179_y;
            world.func_72838_d((Entity)bomb);
            return true;
        }
        return false;
    }

    protected void func_70184_a(MovingObjectPosition movingobjectposition) {
        this.field_70159_w *= 0.5;
        this.field_70181_x *= -0.5;
        this.field_70179_y *= 0.5;
    }

    private boolean isDud(boolean inFire) {
        switch (this.getType()) {
            case BOMB_WATER: {
                return inFire || this.field_70170_p.field_73011_w.field_76575_d;
            }
        }
        return this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v).func_149688_o() == Material.field_151586_h;
    }

    private boolean shouldExplode(boolean inFire) {
        if (!this.func_70089_S()) {
            return false;
        }
        if ((inFire || this.field_70170_p.field_73011_w.field_76575_d) && this.getType() != BombType.BOMB_FIRE) {
            return true;
        }
        return this.field_70173_aa >= this.fuseTime;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("bombType", (byte)this.getType().ordinal());
        compound.func_74768_a("fuseTime", this.fuseTime);
        compound.func_74776_a("bombRadius", this.radius);
        compound.func_74776_a("motionFactor", this.motionFactor);
        compound.func_74776_a("destructionFactor", this.destructionFactor);
        compound.func_74757_a("canGrief", this.canGrief);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(BombType.values()[compound.func_74771_c("bombType") % BombType.values().length]);
        this.fuseTime = compound.func_74762_e("fuseTime");
        this.radius = compound.func_74760_g("bombRadius");
        this.motionFactor = compound.func_74760_g("motionFactor");
        this.destructionFactor = compound.func_74760_g("destructionFactor");
        this.canGrief = compound.func_74767_n("canGrief");
    }
}

