/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.entity.player.quests.QuestMasterSword;
import zeldaswordskills.entity.player.quests.QuestZeldaTalk;
import zeldaswordskills.entity.player.quests.QuestZeldasLetter;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.item.ItemPendant;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;

public final class QuestPendants
extends QuestBase {
    private static final int FLAG_ALL_PENDANTS = 7;
    private static final ItemPendant.PendantType[] pendants = new ItemPendant.PendantType[]{ItemPendant.PendantType.WISDOM, ItemPendant.PendantType.COURAGE, ItemPendant.PendantType.POWER};

    public boolean givePendant(EntityPlayer player, ItemPendant.PendantType pendant) {
        if (!this.isset(pendant.bitFlag) && PlayerUtils.consumeHeldItem(player, ZSSItems.pendant, pendant.ordinal(), 1)) {
            this.set(pendant.bitFlag);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBegin(EntityPlayer player) {
        return super.canBegin(player) && ZSSQuests.get(player).hasCompleted(QuestZeldaTalk.class);
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.zelda.pendant.begin.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.begin.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.begin.2", new Object[0])});
        return true;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return false;
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given.final.0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given.final.1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given.final.2", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given.final.3", new Object[0])});
        ItemStack stack = new ItemStack(ZSSItems.keyBig, 1, BossType.FOREST.ordinal());
        new TimedAddItem(player, stack, 4000, "zeldaswordskills:success");
        return true;
    }

    @Override
    public boolean complete(EntityPlayer player, Object ... data) {
        if (!this.isset(128) && this.isset(7) && this.onComplete(player, data)) {
            this.forceComplete(player, data);
            return true;
        }
        return false;
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        this.set(128);
        ZSSQuests.get(player).add(new QuestMasterSword());
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemPendant) {
            ItemPendant.PendantType pendant = ItemPendant.PendantType.byDamage(stack.func_77960_j());
            if (pendant != ItemPendant.PendantType.WISDOM && !this.isset(ItemPendant.PendantType.WISDOM.bitFlag)) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.pendant.wrong", new Object[0]);
            } else if (this.givePendant(player, pendant)) {
                if (pendant == ItemPendant.PendantType.WISDOM) {
                    ZSSQuests.get(player).add(new QuestZeldasLetter());
                } else if (this.isset(7)) {
                    this.complete(player, new Object[0]);
                }
                if (!this.isComplete(player)) {
                    new TimedChatDialogue(player, new IChatComponent[]{new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given." + pendant.unlocalizedName + ".0", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given." + pendant.unlocalizedName + ".1", new Object[0]), new ChatComponentTranslation("chat.zss.npc.zelda.pendant.given." + pendant.unlocalizedName + ".2", new Object[0])});
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.zelda.pendant.duplicate", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        if (this.hasBegun(player) && rand.nextInt(8) < 3) {
            for (ItemPendant.PendantType pendant : pendants) {
                if (this.isset(pendant.bitFlag)) continue;
                return new ChatComponentTranslation("chat.zss.npc.zelda.pendant.hint." + pendant.unlocalizedName + "." + rand.nextInt(3), new Object[0]);
            }
        }
        return null;
    }
}

