/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player.quests;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.entity.npc.EntityGoron;
import zeldaswordskills.entity.player.quests.QuestBase;
import zeldaswordskills.handler.TradeHandler;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TimedAddItem;
import zeldaswordskills.util.TimedChatDialogue;
import zeldaswordskills.util.VillagerDescription;

public final class QuestBiggoronSword
extends QuestBase {
    private static final ImmutableSet<TradeData> TRADES = new ImmutableSet.Builder().add((Object)new TradeData(ItemTreasure.Treasures.TENTACLE, new VillagerDescription("Talon", EntityVillager.class, TradeHandler.EnumVillager.FARMER.ordinal(), true), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.POCKET_EGG))).add((Object)new TradeData(ItemTreasure.Treasures.POCKET_EGG, new VillagerDescription("Cucco Lady", EntityVillager.class, TradeHandler.EnumVillager.FARMER.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.COJIRO))).add((Object)new TradeData(ItemTreasure.Treasures.COJIRO, new VillagerDescription("Grog", EntityVillager.class, TradeHandler.EnumVillager.BUTCHER.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.ODD_MUSHROOM))).add((Object)new TradeData(ItemTreasure.Treasures.ODD_MUSHROOM, new VillagerDescription("Old Hag", EntityVillager.class, TradeHandler.EnumVillager.LIBRARIAN.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.ODD_POTION))).add((Object)new TradeData(ItemTreasure.Treasures.ODD_POTION, new VillagerDescription("Grog", EntityVillager.class, TradeHandler.EnumVillager.BUTCHER.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.POACHER_SAW))).add((Object)new TradeData(ItemTreasure.Treasures.POACHER_SAW, new VillagerDescription("Mutoh", EntityVillager.class, TradeHandler.EnumVillager.BLACKSMITH.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.GORON_SWORD))).add((Object)new TradeData(ItemTreasure.Treasures.GORON_SWORD, new VillagerDescription("Biggoron", EntityGoron.class, TradeHandler.EnumVillager.BLACKSMITH.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.PRESCRIPTION))).add((Object)new TradeData(ItemTreasure.Treasures.PRESCRIPTION, new VillagerDescription("King Zora", EntityVillager.class, TradeHandler.EnumVillager.PRIEST.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.EYEBALL_FROG))).add((Object)new TradeData(ItemTreasure.Treasures.EYEBALL_FROG, new VillagerDescription("Lake Scientist", EntityVillager.class, TradeHandler.EnumVillager.LIBRARIAN.ordinal()), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.EYE_DROPS))).add((Object)new TradeData(ItemTreasure.Treasures.EYE_DROPS, new VillagerDescription("Biggoron", EntityGoron.class), QuestBiggoronSword.getTreasure(ItemTreasure.Treasures.CLAIM_CHECK))).add((Object)new TradeData(ItemTreasure.Treasures.CLAIM_CHECK, new VillagerDescription("Biggoron", EntityGoron.class), new ItemStack(ZSSItems.swordBiggoron))).build();
    private int tradeIndex;

    private static final ItemStack getTreasure(ItemTreasure.Treasures treasure) {
        return new ItemStack(ZSSItems.treasure, 1, treasure.ordinal());
    }

    private TradeData getCurrentTrade() {
        return this.tradeIndex < TRADES.size() ? (TradeData)TRADES.asList().get(this.tradeIndex) : null;
    }

    public QuestBiggoronSword() {
        this.set(64);
    }

    @Override
    protected boolean onBegin(EntityPlayer player, Object ... data) {
        return false;
    }

    @Override
    public boolean canComplete(EntityPlayer player) {
        return false;
    }

    @Override
    protected boolean onComplete(EntityPlayer player, Object ... data) {
        this.forceComplete(player, data);
        return false;
    }

    @Override
    public void forceComplete(EntityPlayer player, Object ... data) {
        player.func_71029_a((StatBase)ZSSAchievements.treasureBiggoron);
        this.tradeIndex = TRADES.size();
        this.set(128);
    }

    @Override
    public boolean update(EntityPlayer player, Object ... data) {
        if (data == null || data.length < 2 || !(data[0] instanceof Entity) || !(data[1] instanceof Boolean)) {
            return false;
        }
        ItemStack stack = player.func_70694_bm();
        if (stack == null || !(stack.func_77973_b() instanceof ItemTreasure)) {
            return false;
        }
        TradeData trade = this.getCurrentTrade();
        if (trade != null && trade.villager.matches((Entity)data[0]) && trade.treasure == ItemTreasure.Treasures.byDamage(stack.func_77960_j())) {
            if (((Boolean)data[1]).booleanValue()) {
                if (trade.treasure != ItemTreasure.Treasures.CLAIM_CHECK || this.checkClaim(stack, player)) {
                    if (!PlayerUtils.consumeHeldItem(player, stack.func_77973_b(), stack.func_77960_j(), 1)) {
                        return false;
                    }
                    this.rewardAndChat(player, trade, true);
                    if (this.tradeIndex < TRADES.size()) {
                        ++this.tradeIndex;
                    }
                    return true;
                }
                if (trade.treasure == ItemTreasure.Treasures.CLAIM_CHECK) {
                    return true;
                }
            } else {
                if (trade.treasure != ItemTreasure.Treasures.CLAIM_CHECK || this.checkClaim(stack, player)) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure." + trade.treasure.name + ".show", new Object[0]);
                }
                return true;
            }
        }
        return false;
    }

    private void rewardAndChat(EntityPlayer player, TradeData trade, boolean first) {
        ItemStack reward = trade.reward.func_77946_l();
        ArrayList<ChatComponentTranslation> chat = new ArrayList<ChatComponentTranslation>();
        if (first) {
            chat.add(new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".give.first", new Object[0]));
        } else {
            if (trade.treasure == ItemTreasure.Treasures.CLAIM_CHECK) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".give.repeat", new Object[0]));
                return;
            }
            chat.add(new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".give.repeat", new Object[0]));
        }
        chat.add(new ChatComponentTranslation("chat.zss.treasure.generic.received", new Object[]{new ChatComponentTranslation(reward.func_77977_a() + ".name", new Object[0])}));
        if (this.onCompletedTrade(player, trade, reward) && first) {
            chat.add(new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".give.next", new Object[0]));
        }
        new TimedChatDialogue(player, chat.toArray(new IChatComponent[chat.size()]));
        new TimedAddItem(player, reward, 1250, "zeldaswordskills:success");
    }

    private boolean checkClaim(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("finishDate")) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.claim_check.no_nbt", new Object[0]);
            stack.func_77978_p().func_74772_a("finishDate", player.field_70170_p.func_82737_E() + 48000L);
            return false;
        }
        if (player.field_70170_p.func_82737_E() < stack.func_77978_p().func_74763_f("finishDate")) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.treasure.claim_check.early", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean onCompletedTrade(EntityPlayer player, TradeData trade, ItemStack reward) {
        switch (trade.treasure) {
            case TENTACLE: {
                player.func_71029_a((StatBase)ZSSAchievements.treasureFirst);
                return false;
            }
            case POCKET_EGG: {
                player.func_71029_a((StatBase)ZSSAchievements.treasureSecond);
                return false;
            }
            case EYE_DROPS: {
                reward.func_77982_d(new NBTTagCompound());
                reward.func_77978_p().func_74772_a("finishDate", player.field_70170_p.func_82737_E() + 48000L);
                return true;
            }
            case CLAIM_CHECK: {
                this.onComplete(player, new Object[0]);
                return true;
            }
        }
        return true;
    }

    @Override
    public IChatComponent getHint(EntityPlayer player, Object ... data) {
        if (data == null || data.length < 1 || !(data[0] instanceof Entity)) {
            return null;
        }
        Entity entity = (Entity)data[0];
        boolean isChild = entity instanceof EntityAgeable && ((EntityAgeable)entity).func_70631_g_();
        ItemTreasure.Treasures treasure = null;
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemTreasure) {
            treasure = ItemTreasure.Treasures.byDamage(stack.func_77960_j());
        }
        boolean isLeftClick = data.length > 1 && data[1] instanceof Boolean && (Boolean)data[1] != false;
        ChatComponentTranslation chat = null;
        int index = Math.min(this.tradeIndex + 2, TRADES.size());
        UnmodifiableListIterator iterator = TRADES.asList().listIterator(index);
        int i = index - 1;
        while (iterator.hasPrevious()) {
            TradeData trade = (TradeData)iterator.previous();
            if (trade.villager.matches(entity, false) && (!isChild || trade.villager.isChild)) {
                boolean exactMatch = trade.villager.matchChild(entity);
                if (i + 1 == this.tradeIndex && trade.reward.func_77973_b() instanceof ItemTreasure && treasure == ItemTreasure.Treasures.byDamage(trade.reward.func_77960_j())) {
                    return new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".hint.next" + (exactMatch ? "" : ".ageable"), new Object[0]);
                }
                if (!(i != this.tradeIndex || trade.treasure == treasure && exactMatch)) {
                    return new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".hint.current" + (exactMatch ? "" : ".ageable"), new Object[0]);
                }
                if (i - 1 == this.tradeIndex && trade.treasure != treasure && !this.isComplete(player)) {
                    return new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".hint.previous" + (treasure == ((TradeData)iterator.previous()).treasure ? ".match" : ""), new Object[0]);
                }
                if (i < this.tradeIndex) {
                    if (isLeftClick && trade.treasure == treasure && exactMatch && PlayerUtils.consumeHeldItem(player, stack.func_77973_b(), stack.func_77960_j(), 1)) {
                        this.rewardAndChat(player, trade, false);
                        return new ChatComponentTranslation("", new Object[0]);
                    }
                    return new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + ".thanks" + (exactMatch ? "" : ".ageable"), new Object[0]);
                }
                return null;
            }
            if (trade.treasure == treasure && trade.villager.matchClassAndName(entity) && !trade.villager.matchProfession(entity)) {
                TradeHandler.EnumVillager ev = TradeHandler.EnumVillager.values()[trade.villager.profession % TradeHandler.EnumVillager.values().length];
                return new ChatComponentTranslation("chat.zss.treasure.generic.profession." + (isChild ? "child" : ev.unlocalizedName), new Object[]{new ChatComponentTranslation("entity.villager.profession." + ev.unlocalizedName, new Object[0])});
            }
            if (trade.treasure == treasure && entity instanceof EntityVillager && this.checkVillagerTrade(stack, player, (EntityVillager)entity, isLeftClick)) {
                return new ChatComponentTranslation("", new Object[0]);
            }
            if (trade.treasure == treasure && !isChild) {
                chat = rand.nextInt(8) < 3 ? new ChatComponentTranslation("chat.zss.treasure." + trade.treasure.name + (isLeftClick ? ".give" : ".show") + ".random", new Object[0]) : new ChatComponentTranslation("chat.zss.treasure.generic." + (isLeftClick ? "give." : "show.") + rand.nextInt(4), new Object[0]);
            }
            --i;
        }
        return chat;
    }

    private boolean checkVillagerTrade(ItemStack stack, EntityPlayer player, EntityVillager villager, boolean isLeftClick) {
        ItemTreasure.Treasures treasure = ItemTreasure.Treasures.byDamage(stack.func_77960_j());
        return treasure.canSell() && ((ItemTreasure)stack.func_77973_b()).handleVillagerTrade(stack, player, villager, isLeftClick);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("tradeIndex", this.tradeIndex);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.tradeIndex = compound.func_74762_e("tradeIndex");
    }

    private static class TradeData {
        public final ItemTreasure.Treasures treasure;
        public final VillagerDescription villager;
        public final ItemStack reward;

        public TradeData(ItemTreasure.Treasures treasure, VillagerDescription villager, ItemStack reward) {
            this.treasure = treasure;
            this.villager = villager;
            this.reward = reward;
        }
    }
}

