/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.world.chunk.Chunk;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.bidirectional.LearnSongPacket;
import zeldaswordskills.network.bidirectional.PlaySoundPacket;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.SongNote;
import zeldaswordskills.util.WarpPoint;
import zeldaswordskills.util.WorldUtils;

public class ZSSPlayerSongs {
    private final EntityPlayer player;
    private final Set<AbstractZeldaSong> knownSongs = new HashSet<AbstractZeldaSong>();
    private final Map<Integer, WarpPoint> warpPoints = new HashMap<Integer, WarpPoint>();
    @SideOnly(value=Side.CLIENT)
    public AbstractZeldaSong songToLearn;
    public boolean preventSongGui;
    private final List<SongNote> scarecrowNotes = new ArrayList<SongNote>();
    private long scarecrowTime;
    private long nextSongHealTime;
    private UUID horseUUID = null;
    private int horseId = -1;
    private int horseChunkX;
    private int horseChunkZ;
    private Map<Integer, Long> lonlonCows = new HashMap<Integer, Long>();
    private final Set<String> curedNpcs = new HashSet<String>();

    public ZSSPlayerSongs(EntityPlayer player) {
        this.player = player;
    }

    public static ZSSPlayerSongs get(EntityPlayer player) {
        return ZSSPlayerInfo.get(player).getPlayerSongs();
    }

    public boolean isSongKnown(AbstractZeldaSong song) {
        return this.knownSongs.contains(song);
    }

    public boolean learnSong(AbstractZeldaSong song, List<SongNote> notes) {
        boolean addSong = true;
        if (this.isSongKnown(song)) {
            return false;
        }
        if (!song.canLearn(this.player)) {
            if (!this.player.field_70170_p.field_72995_K) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.nolearn", new ChatComponentTranslation(song.getTranslationString(), new Object[0]));
            }
            return false;
        }
        if (song == ZeldaSongs.songScarecrow) {
            if (notes == null || notes.size() != 8 || !ZeldaSongs.areNotesUnique(notes)) {
                ZSSMain.logger.warn("Trying to add Scarecrow's Song with invalid list: " + notes);
                return false;
            }
            if (this.scarecrowNotes.isEmpty()) {
                addSong = false;
                this.scarecrowNotes.addAll(notes);
                this.scarecrowTime = this.player.field_70170_p.func_82737_E() + 168000L;
            } else if (this.player.field_70170_p.func_82737_E() > this.scarecrowTime) {
                for (int i = 0; i < this.scarecrowNotes.size() && addSong; ++i) {
                    addSong = this.scarecrowNotes.get(i) == notes.get(i);
                }
            } else if (!this.player.field_70170_p.field_72995_K) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.scarecrow.later", new Object[0]);
            }
        }
        if (addSong) {
            this.knownSongs.add(song);
            this.player.func_71029_a((StatBase)ZSSAchievements.ocarinaSong);
            if (song == ZeldaSongs.songScarecrow) {
                this.player.func_71029_a((StatBase)ZSSAchievements.ocarinaScarecrow);
            }
            if (this.knownSongs.size() > 15) {
                this.player.func_71029_a((StatBase)ZSSAchievements.ocarinaMaestro);
            }
            if (!this.player.field_70170_p.field_72995_K) {
                PacketDispatcher.sendTo(new PlaySoundPacket("zeldaswordskills:success", 1.0f, 1.0f), (EntityPlayerMP)this.player);
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.learned", new ChatComponentTranslation(song.getTranslationString(), new Object[0]));
                PacketDispatcher.sendTo(new LearnSongPacket(song, notes), (EntityPlayerMP)this.player);
            }
        }
        return true;
    }

    public boolean removeSong(AbstractZeldaSong song) {
        if (this.knownSongs.contains(song)) {
            this.knownSongs.remove(song);
            if (song == ZeldaSongs.songScarecrow) {
                this.scarecrowNotes.clear();
                this.scarecrowTime = 0L;
            }
            if (this.player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new LearnSongPacket(song, true), (EntityPlayerMP)this.player);
            }
            return true;
        }
        return false;
    }

    public void resetKnownSongs() {
        this.knownSongs.clear();
        this.scarecrowNotes.clear();
        this.scarecrowTime = 0L;
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new LearnSongPacket(true), (EntityPlayerMP)this.player);
        }
    }

    public AbstractZeldaSong getKnownSongFromNotes(List<SongNote> notesPlayed) {
        for (AbstractZeldaSong song : this.knownSongs) {
            if (song == ZeldaSongs.songScarecrow) {
                if (notesPlayed == null || notesPlayed.size() != this.scarecrowNotes.size()) continue;
                for (int i = 0; i < this.scarecrowNotes.size(); ++i) {
                    if (notesPlayed.get(i) == this.scarecrowNotes.get(i)) continue;
                    return null;
                }
                return song;
            }
            if (!song.areCorrectNotes(notesPlayed)) continue;
            return song;
        }
        return null;
    }

    public void onActivatedWarpStone(int x, int y, int z, int meta) {
        if (this.warpPoints.containsKey(meta)) {
            this.warpPoints.remove(meta);
        }
        this.warpPoints.put(meta, new WarpPoint(this.player.field_70170_p.field_73011_w.field_76574_g, x, y, z));
    }

    public WarpPoint getWarpPoint(AbstractZeldaSong song) {
        Integer meta = BlockWarpStone.reverseLookup.get(song);
        return meta == null ? null : this.warpPoints.get(meta);
    }

    public boolean canOpenScarecrowGui(boolean addChat) {
        if (this.scarecrowNotes.isEmpty()) {
            return true;
        }
        if (this.isSongKnown(ZeldaSongs.songScarecrow)) {
            if (addChat) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.scarecrow.known", new Object[0]);
            }
            return false;
        }
        if (this.player.field_70170_p.func_82737_E() < this.scarecrowTime) {
            if (addChat) {
                PlayerUtils.sendTranslatedChat(this.player, "chat.zss.song.scarecrow.later", new Object[0]);
            }
            return false;
        }
        return true;
    }

    public boolean canHealFromSong() {
        return this.player.func_110143_aJ() < this.player.func_110138_aP() && this.player.field_70170_p.func_82737_E() > this.nextSongHealTime;
    }

    public void setNextHealTime() {
        this.nextSongHealTime = this.player.field_70170_p.func_82737_E() + 24000L;
    }

    public List<SongNote> getScarecrowNotes() {
        return Collections.unmodifiableList(this.scarecrowNotes);
    }

    public EntityHorse getLastHorseRidden() {
        Entity entity;
        Entity entity2 = entity = this.horseId < 0 ? null : this.player.field_70170_p.func_73045_a(this.horseId);
        if (entity == null && this.horseUUID != null) {
            entity = this.getHorseByUUID();
        }
        if (entity == null) {
            entity = this.getHorseFromChunk(this.horseChunkX, this.horseChunkZ);
            int n = 1;
            for (int i = -n; entity == null && i <= n; ++i) {
                for (int k = -n; entity == null && k <= n; ++k) {
                    if (i == 0 && k == 0) continue;
                    entity = this.getHorseFromChunk(this.horseChunkX + i, this.horseChunkZ + k);
                }
            }
        }
        if (entity instanceof EntityHorse && entity.func_70089_S()) {
            return (EntityHorse)entity;
        }
        return null;
    }

    private Entity getHorseByUUID() {
        if (this.horseUUID == null) {
            return null;
        }
        Entity entity = WorldUtils.getEntityByUUID(this.player.field_70170_p, this.horseUUID);
        if (entity instanceof EntityHorse) {
            this.horseId = entity.func_145782_y();
        }
        return entity;
    }

    private Entity getHorseFromChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.player.field_70170_p.func_72964_e(chunkX, chunkZ);
        if (chunk != null && chunk.field_76636_d) {
            return this.getHorseByUUID();
        }
        return null;
    }

    public void setHorseRidden(EntityHorse horse) {
        if (horse.func_145782_y() == this.horseId) {
            this.setHorseCoordinates(horse);
        } else if (horse.func_110248_bS() && horse.func_152119_ch().equals(this.player.func_110124_au().toString())) {
            this.horseId = horse.func_145782_y();
            this.horseUUID = horse.getPersistentID();
            this.setHorseCoordinates(horse);
        }
    }

    private void setHorseCoordinates(EntityHorse horse) {
        this.horseChunkX = MathHelper.func_76128_c((double)horse.field_70165_t) >> 4;
        this.horseChunkZ = MathHelper.func_76128_c((double)horse.field_70161_v) >> 4;
    }

    public void addLonLonCow(EntityCow cow) {
        NBTTagCompound data = cow.getEntityData();
        if (!(cow.func_70631_g_() || data.func_74764_b("zss_lon_milk") && cow.field_70170_p.func_72820_D() <= data.func_74763_f("zss_lon_milk"))) {
            this.lonlonCows.put(cow.func_145782_y(), cow.field_70170_p.func_72820_D() + 6000L);
            cow.field_70170_p.func_72960_a((Entity)cow, (byte)18);
        }
    }

    public boolean milkLonLonCow(EntityPlayer player, EntityCow cow) {
        NBTTagCompound data;
        boolean match = false;
        Iterator<Map.Entry<Integer, Long>> iterator = this.lonlonCows.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Long> entry = iterator.next();
            if (cow.field_70170_p.func_72820_D() > entry.getValue()) {
                iterator.remove();
                continue;
            }
            if (entry.getKey().intValue() != cow.func_145782_y()) continue;
            match = true;
            iterator.remove();
        }
        ItemStack stack = player.func_70694_bm();
        if (!(!match || stack == null || stack.func_77973_b() != Items.field_151069_bo || cow.func_70631_g_() || (data = cow.getEntityData()).func_74764_b("zss_lon_milk") && cow.field_70170_p.func_72820_D() <= data.func_74763_f("zss_lon_milk"))) {
            if (stack.field_77994_a > 1) {
                --stack.field_77994_a;
                PlayerUtils.addItemToInventory(player, new ItemStack(ZSSItems.lonlonMilk));
            } else {
                player.func_70062_b(0, new ItemStack(ZSSItems.lonlonMilk));
            }
            data.func_74772_a("zss_lon_milk", cow.field_70170_p.func_72820_D() + 24000L);
            return true;
        }
        return false;
    }

    public boolean hasCuredNpc(String name) {
        return this.curedNpcs.contains(name);
    }

    public boolean onCuredNpc(String name) {
        return this.curedNpcs.add(name);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList songs = new NBTTagList();
        for (AbstractZeldaSong song : this.knownSongs) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("song", song.getUnlocalizedName());
            songs.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("KnownSongs", (NBTBase)songs);
        if (!this.scarecrowNotes.isEmpty()) {
            int[] notes = new int[this.scarecrowNotes.size()];
            for (int i = 0; i < this.scarecrowNotes.size(); ++i) {
                notes[i] = this.scarecrowNotes.get(i).ordinal();
            }
            compound.func_74783_a("ScarecrowNotes", notes);
        }
        compound.func_74772_a("ScarecrowTime", this.scarecrowTime);
        compound.func_74772_a("NextSongHealTime", this.nextSongHealTime);
        if (this.horseUUID != null) {
            compound.func_74772_a("HorseUUIDMost", this.horseUUID.getMostSignificantBits());
            compound.func_74772_a("HorseUUIDLeast", this.horseUUID.getLeastSignificantBits());
            compound.func_74768_a("HorseChunkX", this.horseChunkX);
            compound.func_74768_a("HorseChunkZ", this.horseChunkZ);
        }
        if (!this.warpPoints.isEmpty()) {
            NBTTagList warpList = new NBTTagList();
            for (Integer i : this.warpPoints.keySet()) {
                WarpPoint warp = this.warpPoints.get(i);
                if (warp != null) {
                    NBTTagCompound warpTag = warp.writeToNBT();
                    warpTag.func_74768_a("WarpKey", i.intValue());
                    warpList.func_74742_a((NBTBase)warpTag);
                    continue;
                }
                ZSSMain.logger.warn("NULL warp point stored in map with key " + i);
            }
            compound.func_74782_a("WarpList", (NBTBase)warpList);
        }
        if (!this.curedNpcs.isEmpty()) {
            NBTTagList npcs = new NBTTagList();
            for (String name : this.curedNpcs) {
                NBTTagCompound npc = new NBTTagCompound();
                npc.func_74778_a("NpcName", name);
                npcs.func_74742_a((NBTBase)npc);
            }
            compound.func_74782_a("CuredNpcs", (NBTBase)npcs);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList songs = compound.func_150295_c("KnownSongs", 10);
        this.knownSongs.clear();
        for (int i = 0; i < songs.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound = songs.func_150305_b(i);
            AbstractZeldaSong song = ZeldaSongs.getSongByName(nBTTagCompound.func_74779_i("song"));
            if (song == null) continue;
            this.knownSongs.add(song);
        }
        if (compound.func_74764_b("ScarecrowNotes")) {
            try {
                int[] notes;
                for (int n : notes = compound.func_74759_k("ScarecrowNotes")) {
                    this.scarecrowNotes.add(SongNote.values()[n]);
                }
            }
            catch (Exception e) {
                ZSSMain.logger.error("Exception thrown while loading Scarecrow's Song notes: " + e.getMessage());
            }
        }
        this.scarecrowTime = compound.func_74763_f("ScarecrowTime");
        this.nextSongHealTime = compound.func_74763_f("NextHealSongTime");
        if (compound.func_74764_b("HorseChunkX") && compound.func_74764_b("HorseChunkZ")) {
            this.horseChunkX = compound.func_74762_e("HorseChunkX");
            this.horseChunkZ = compound.func_74762_e("HorseChunkZ");
        }
        if (compound.func_74764_b("HorseUUIDMost") && compound.func_74764_b("HorseUUIDLeast")) {
            this.horseUUID = new UUID(compound.func_74763_f("HorseUUIDMost"), compound.func_74763_f("HorseUUIDLeast"));
        }
        if (compound.func_74764_b("WarpList")) {
            void var4_12;
            NBTTagList warpList = compound.func_150295_c("WarpList", 10);
            boolean bl = false;
            while (var4_12 < warpList.func_74745_c()) {
                NBTTagCompound warpTag = warpList.func_150305_b((int)var4_12);
                WarpPoint warp = WarpPoint.readFromNBT(warpTag);
                this.warpPoints.put(warpTag.func_74762_e("WarpKey"), warp);
                ++var4_12;
            }
        }
        if (compound.func_74764_b("CuredNpcs")) {
            void var4_14;
            NBTTagList npcs = compound.func_150295_c("CuredNpcs", 10);
            boolean bl = false;
            while (var4_14 < npcs.func_74745_c()) {
                NBTTagCompound npc = npcs.func_150305_b((int)var4_14);
                this.curedNpcs.add(npc.func_74779_i("NpcName"));
                ++var4_14;
            }
        }
    }
}

