/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.player;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.commons.lang3.ArrayUtils;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.entity.player.quests.ZSSQuests;
import zeldaswordskills.handler.ZSSCombatEvents;
import zeldaswordskills.item.ItemArmorBoots;
import zeldaswordskills.item.ItemHeroBow;
import zeldaswordskills.item.ItemMask;
import zeldaswordskills.item.ItemZeldaShield;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.client.AttackBlockedPacket;
import zeldaswordskills.network.client.SetNockedArrowPacket;
import zeldaswordskills.network.client.SpawnNayruParticlesPacket;
import zeldaswordskills.network.client.SyncCurrentMagicPacket;
import zeldaswordskills.network.client.SyncPlayerInfoPacket;
import zeldaswordskills.network.client.SyncQuestsPacket;
import zeldaswordskills.network.server.RequestCurrentMagicPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class ZSSPlayerInfo
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "ZSSPlayerInfo";
    private final EntityPlayer player;
    private final ZSSPlayerSkills playerSkills;
    private final ZSSPlayerSongs playerSongs;
    private float mp;
    private float lastMp;
    public static final IAttribute maxMagic = new RangedAttribute("zss.max_magic", 50.0, 0.0, Double.MAX_VALUE).func_111117_a("Max Magic").func_111112_a(true);
    private Entity lastRidden;
    private int blockTime = 0;
    private final Map<Stats, Integer> playerStats = new EnumMap<Stats, Integer>(Stats.class);
    private byte receivedGear = 0;
    private byte flags = 0;
    public static final byte IS_WEARING_BOOTS = 1;
    public static final byte IS_WEARING_HELM = 2;
    public static final byte IS_NAYRU_ACTIVE = 4;
    public static final byte MOBILITY = 8;
    private ItemStack lastBootsWorn;
    private ItemStack lastHelmWorn;
    public int hoverTime = 0;
    @Deprecated
    private Item borrowedMask = null;
    @Deprecated
    private int maskStage = 0;
    public static final int MAX_SKULLTULA_TOKENS = 100;
    private int skulltulaTokens = 0;
    private ItemStack arrowStack = null;
    public boolean hasAutoBombArrow = false;
    public int slingshotMode = 0;
    public float reduceFallAmount = 0.0f;

    public ZSSPlayerInfo(EntityPlayer player) {
        this.player = player;
        this.playerSkills = new ZSSPlayerSkills(player);
        this.playerSongs = new ZSSPlayerSongs(player);
        player.func_110140_aT().func_111150_b(maxMagic).func_111128_a(50.0);
        this.mp = this.getMaxMagic();
        this.initStats();
    }

    public void init(Entity entity, World world) {
    }

    private void initStats() {
        for (Stats stat : Stats.values()) {
            this.playerStats.put(stat, 0);
        }
    }

    public float getCurrentMagic() {
        if (this.mp > this.getMaxMagic()) {
            this.setCurrentMagic(this.getMaxMagic());
        }
        return this.mp;
    }

    public void restoreMagic(float amount) {
        this.setCurrentMagic(this.getCurrentMagic() + amount);
    }

    public void setCurrentMagic(float value) {
        this.mp = MathHelper.func_76131_a((float)value, (float)0.0f, (float)this.getMaxMagic());
    }

    public void setInitialMagic(float value) {
        this.mp = Math.max(0.0f, value);
    }

    public float getMaxMagic() {
        return (float)this.player.func_110140_aT().func_111151_a(maxMagic).func_111126_e();
    }

    public void setMaxMagic(float value) {
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)Config.getMaxMagicPoints());
        this.player.func_110140_aT().func_111151_a(maxMagic).func_111128_a((double)value);
        if (this.getCurrentMagic() > this.getMaxMagic()) {
            this.setCurrentMagic(this.getMaxMagic());
        }
    }

    public boolean consumeMagic(float amount) {
        return this.canUseMagic() ? this.useMagic(amount, true) : false;
    }

    public boolean useMagic(float amount) {
        return this.canUseMagic() ? this.useMagic(amount, false) : false;
    }

    private boolean useMagic(float amount, boolean consume) {
        boolean sufficient;
        if (this.player.field_71075_bZ.field_75098_d || ZSSEntityInfo.get((EntityLivingBase)this.player).isBuffActive(Buff.UNLIMITED_MAGIC)) {
            return true;
        }
        boolean bl = sufficient = amount <= this.getCurrentMagic();
        if (sufficient || consume) {
            this.setCurrentMagic(this.getCurrentMagic() - amount);
        }
        return sufficient;
    }

    public boolean canUseMagic() {
        return this.player.field_71075_bZ.field_75098_d || this.getMaxMagic() > 0.0f && !this.isNayruActive();
    }

    public int getStat(Stats stat) {
        return this.playerStats.get((Object)stat);
    }

    public void addStat(Stats stat, int value) {
        int i = this.playerStats.remove((Object)stat);
        switch (stat) {
            case STAT_BOSS_ROOMS: {
                this.playerStats.put(stat, i | value);
                break;
            }
            default: {
                this.playerStats.put(stat, i + value);
            }
        }
    }

    public ZSSPlayerSkills getPlayerSkills() {
        return this.playerSkills;
    }

    public ZSSPlayerSongs getPlayerSongs() {
        return this.playerSongs;
    }

    public boolean canBlock() {
        return this.blockTime == 0;
    }

    public void onAttackBlocked(ItemStack shield, float damage) {
        ZSSCombatEvents.setPlayerAttackTime(this.player);
        this.blockTime = shield.func_77973_b() instanceof ItemZeldaShield ? ((ItemZeldaShield)shield.func_77973_b()).getRecoveryTime() : 20;
        this.player.func_71041_bz();
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new AttackBlockedPacket(shield), (EntityPlayerMP)this.player);
            this.player.func_71020_j(0.3f * damage);
        }
    }

    public void verifyStartingGear() {
        if ((this.receivedGear & 1) == 0 && ZSSItems.grantBonusGear(this.player)) {
            this.receivedGear = (byte)(this.receivedGear | 1);
        }
    }

    public void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    public boolean getFlag(byte flag) {
        return (this.flags & flag) == flag;
    }

    public void activateNayru() {
        if (Config.allowUnlimitedNayru() || !ZSSEntityInfo.get((EntityLivingBase)this.player).isBuffActive(Buff.UNLIMITED_MAGIC)) {
            this.setFlag((byte)4, true);
        }
    }

    public boolean isNayruActive() {
        return this.getFlag((byte)4);
    }

    public void setWearingBoots(ItemStack boots) {
        ItemStack helm;
        if (this.lastBootsWorn != null && this.lastBootsWorn.func_77973_b() instanceof ItemArmorBoots) {
            ((ItemArmorBoots)this.lastBootsWorn.func_77973_b()).removeModifiers(this.lastBootsWorn, this.player);
        }
        this.lastBootsWorn = boots;
        this.setFlag((byte)1, boots != null && boots.func_77973_b() instanceof ItemArmorBoots);
        if (this.getFlag((byte)1)) {
            ((ItemArmorBoots)boots.func_77973_b()).applyModifiers(boots, this.player);
        }
        if (this.getFlag((byte)2) && (helm = this.player.func_82169_q(3)) != null && helm.func_77973_b() instanceof ItemMask) {
            ((ItemMask)helm.func_77973_b()).applyModifiers(helm, this.player);
        }
    }

    public void setWearingHelm(ItemStack helm) {
        ItemStack boots;
        if (this.lastHelmWorn != null && this.lastHelmWorn.func_77973_b() instanceof ItemMask) {
            ((ItemMask)this.lastHelmWorn.func_77973_b()).removeModifiers(this.lastHelmWorn, this.player);
        }
        this.lastHelmWorn = helm;
        this.setFlag((byte)2, helm != null && helm.func_77973_b() instanceof ItemMask);
        if (this.getFlag((byte)2)) {
            ((ItemMask)helm.func_77973_b()).applyModifiers(helm, this.player);
        }
        if (this.getFlag((byte)1) && (boots = this.player.func_82169_q(0)) != null && boots.func_77973_b() instanceof ItemArmorBoots) {
            ((ItemArmorBoots)boots.func_77973_b()).applyModifiers(boots, this.player);
        }
    }

    @Deprecated
    public Item getBorrowedMask() {
        return this.borrowedMask;
    }

    @Deprecated
    public void setBorrowedMask(Item item) {
        this.borrowedMask = item;
    }

    @Deprecated
    public int getCurrentMaskStage() {
        return this.maskStage;
    }

    public boolean canIncrementSkulltulaTokens() {
        return this.skulltulaTokens < 100;
    }

    public int getSkulltulaTokens() {
        return this.skulltulaTokens;
    }

    public boolean incrementSkulltulaTokens() {
        if (this.canIncrementSkulltulaTokens() && PlayerUtils.consumeHeldItem(this.player, ZSSItems.skulltulaToken, 1)) {
            ++this.skulltulaTokens;
            return true;
        }
        return false;
    }

    public ItemStack getNockedArrow() {
        return this.arrowStack;
    }

    public void setNockedArrow(ItemStack stack) {
        this.arrowStack = stack;
        if (this.player instanceof EntityPlayerMP) {
            PacketDispatcher.sendTo(new SetNockedArrowPacket(stack), (EntityPlayerMP)this.player);
        }
    }

    public void onUpdate() {
        ItemStack helm;
        ItemStack boots;
        this.playerSkills.onUpdate();
        if (!this.player.field_70170_p.field_72995_K && this.lastMp != this.mp) {
            this.lastMp = this.mp;
            if (this.player instanceof EntityPlayerMP) {
                PacketDispatcher.sendTo(new SyncCurrentMagicPacket(this.player), (EntityPlayerMP)this.player);
            }
        }
        if (this.blockTime > 0) {
            --this.blockTime;
        }
        if (this.getFlag((byte)4)) {
            this.updateNayru();
        }
        if (this.getFlag((byte)1) && ((boots = this.player.func_82169_q(0)) == null || this.lastBootsWorn != null && boots.func_77973_b() != this.lastBootsWorn.func_77973_b())) {
            this.setWearingBoots(boots);
        }
        if (this.getFlag((byte)2) && ((helm = this.player.func_82169_q(3)) == null || this.lastHelmWorn != null && helm.func_77973_b() != this.lastHelmWorn.func_77973_b())) {
            this.setWearingHelm(helm);
        }
        if (this.getFlag((byte)8) && !this.player.field_70122_E && Math.abs(this.player.field_70181_x) > 0.05 && !this.player.field_71075_bZ.field_75100_b && this.player.field_70170_p.func_82737_E() % 2L == 0L) {
            this.player.field_70159_w *= 1.15;
            this.player.field_70179_y *= 1.15;
        }
        if (this.hasAutoBombArrow && (this.player.func_70694_bm() == null || !(this.player.func_70694_bm().func_77973_b() instanceof ItemHeroBow))) {
            this.hasAutoBombArrow = false;
        }
        if (this.lastRidden == null && this.player.field_70154_o != null) {
            this.lastRidden = this.player.field_70154_o;
            if (this.lastRidden instanceof EntityHorse) {
                this.playerSongs.setHorseRidden((EntityHorse)this.lastRidden);
            }
        } else if (this.player.field_70154_o == null && this.lastRidden instanceof EntityHorse) {
            this.playerSongs.setHorseRidden((EntityHorse)this.lastRidden);
            this.lastRidden = null;
        }
    }

    private void updateNayru() {
        this.player.field_70172_ad = this.player.field_70771_an;
        if (this.player.field_70173_aa % 4 == 0) {
            if (!this.useMagic(0.5f, true)) {
                this.setFlag((byte)4, false);
            } else if (this.player instanceof EntityPlayerMP) {
                PacketDispatcher.sendToAllAround(new SpawnNayruParticlesPacket(this.player), (Entity)this.player, 64.0);
            }
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ZSSPlayerInfo(player));
        ZSSQuests.register(player);
    }

    public static final ZSSPlayerInfo get(EntityPlayer player) {
        return (ZSSPlayerInfo)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void onPlayerLoggedIn() {
        if (this.player instanceof EntityPlayerMP) {
            this.verifyStartingGear();
        }
    }

    public void onJoinWorld() {
        if (this.player instanceof EntityPlayerMP) {
            this.playerSkills.validateSkills();
            this.playerSkills.verifyMaxHealth();
            PacketDispatcher.sendTo(new SyncPlayerInfoPacket(this), (EntityPlayerMP)this.player);
            PacketDispatcher.sendTo(new SyncQuestsPacket(ZSSQuests.get(this.player)), (EntityPlayerMP)this.player);
        } else {
            PacketDispatcher.sendToServer(new RequestCurrentMagicPacket());
        }
    }

    public void copy(ZSSPlayerInfo info) {
        NBTTagCompound compound = new NBTTagCompound();
        info.saveNBTData(compound);
        this.loadNBTData(compound);
        ZSSQuests.get(this.player).copy(ZSSQuests.get(info.player));
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag;
        this.playerSkills.saveNBTData(compound);
        this.playerSongs.saveNBTData(compound);
        compound.func_74776_a("zssCurrentMagic", this.mp);
        compound.func_74783_a("zssStats", ArrayUtils.toPrimitive((Integer[])this.playerStats.values().toArray(new Integer[this.playerStats.size()])));
        compound.func_74774_a("ZSSGearReceived", this.receivedGear);
        if (this.lastBootsWorn != null) {
            tag = new NBTTagCompound();
            compound.func_74782_a("lastBootsWorn", (NBTBase)this.lastBootsWorn.func_77955_b(tag));
        }
        if (this.lastHelmWorn != null) {
            tag = new NBTTagCompound();
            compound.func_74782_a("lastHelmWorn", (NBTBase)this.lastHelmWorn.func_77955_b(tag));
        }
        compound.func_74768_a("slingshotMode", this.slingshotMode);
        compound.func_74768_a("skulltulaTokens", this.skulltulaTokens);
    }

    public void loadNBTData(NBTTagCompound compound) {
        int maskID;
        Item helm;
        Item boots;
        this.playerSkills.loadNBTData(compound);
        this.playerSongs.loadNBTData(compound);
        this.mp = compound.func_74760_g("zssCurrentMagic");
        int[] stats = compound.func_74759_k("zssStats");
        for (int i = 0; i < stats.length; ++i) {
            this.playerStats.put(Stats.values()[i], stats[i]);
        }
        this.receivedGear = compound.func_74771_c("ZSSGearReceived");
        if (compound.func_150297_b("lastBootsWorn", 10)) {
            this.lastBootsWorn = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lastBootsWorn"));
        }
        if (compound.func_150297_b("lastHelmWorn", 10)) {
            this.lastHelmWorn = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("lastHelmWorn"));
        }
        if ((boots = Item.func_150899_d((int)compound.func_74762_e("lastBoots"))) != null) {
            this.lastBootsWorn = new ItemStack(boots);
        }
        if ((helm = Item.func_150899_d((int)compound.func_74762_e("lastHelm"))) != null) {
            this.lastHelmWorn = new ItemStack(helm);
        }
        this.borrowedMask = (maskID = compound.func_74762_e("borrowedMask")) > -1 ? Item.func_150899_d((int)maskID) : null;
        this.maskStage = compound.func_74762_e("maskStage");
        this.slingshotMode = compound.func_74762_e("slingshotMode");
        this.skulltulaTokens = compound.func_74762_e("skulltulaTokens");
    }

    public static enum Stats {
        STAT_SECRET_ROOMS,
        STAT_BOSS_ROOMS;

    }
}

