/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ICustomMerchant;
import zeldaswordskills.entity.npc.EntityNpcBase;
import zeldaswordskills.item.ItemCustomEgg;

public abstract class EntityNpcMerchantBase
extends EntityNpcBase
implements ICustomMerchant {
    protected MerchantRecipeList trades;
    protected EntityPlayer customer;
    protected String lastCustomer;
    protected boolean refreshTrades;
    protected int refreshTimer;

    public EntityNpcMerchantBase(World world) {
        super(world);
    }

    protected abstract void populateTradingList();

    protected void refreshTradingList() {
        for (MerchantRecipe trade : this.trades) {
            if (!trade.func_82784_g()) continue;
            trade.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
        }
    }

    protected abstract void updateTradingList();

    protected void displayTradingGuiFor(EntityPlayer player) {
        if (!(this.field_70170_p.field_72995_K || this.trades != null && this.trades.size() <= 0)) {
            this.func_70932_a_(player);
            player.func_71030_a((IMerchant)this, this.func_94057_bL());
        }
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.trades == null || this.trades.isEmpty()) {
            this.populateTradingList();
        }
        return this.trades;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList trades) {
        this.trades = trades;
    }

    @Override
    public void setMerchantTrades(MerchantRecipeList trades) {
        this.trades = trades;
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_85030_a("mob.villager.yes", this.func_70599_aP(), this.func_70647_i());
        if (recipe.func_77393_a((MerchantRecipe)this.trades.get(this.trades.size() - 1))) {
            this.refreshTimer = 40;
            this.refreshTrades = true;
            this.lastCustomer = this.customer == null ? null : this.customer.func_70005_c_();
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_85030_a(stack == null ? "mob.villager.no" : "mob.villager.yes", this.func_70599_aP(), this.func_70647_i());
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        boolean flag;
        ItemStack stack = player.field_71071_by.func_70448_g();
        boolean bl = flag = stack != null && (stack.func_77973_b() == Items.field_151063_bx || stack.func_77973_b() instanceof ItemCustomEgg);
        if (!flag && this.func_70089_S() && this.func_70931_l_() == null && !this.func_70631_g_() && !player.func_70093_af()) {
            this.displayTradingGuiFor(player);
            return true;
        }
        return super.func_70085_c(player);
    }

    protected void func_70619_bc() {
        if (this.func_70931_l_() == null && this.refreshTimer > 0) {
            --this.refreshTimer;
            if (this.refreshTimer <= 0) {
                if (this.refreshTrades) {
                    this.refreshTradingList();
                    this.updateTradingList();
                    this.refreshTrades = false;
                    if (this.villageObj != null && this.lastCustomer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.villageObj.func_82688_a(this.lastCustomer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.trades != null) {
            compound.func_74782_a("Offers", (NBTBase)this.trades.func_77202_a());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Offers", 10)) {
            NBTTagCompound tradeTag = compound.func_74775_l("Offers");
            this.trades = new MerchantRecipeList(tradeTag);
        }
    }
}

