/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.npc;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ListIterator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.INpcVillager;
import zeldaswordskills.entity.npc.EntityNpcMerchantBase;
import zeldaswordskills.item.ItemBomb;
import zeldaswordskills.item.ItemBombBag;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.MerchantRecipeHelper;
import zeldaswordskills.util.PlayerUtils;

public class EntityNpcBarnes
extends EntityNpcMerchantBase
implements INpcVillager {
    private static final MerchantRecipe standardBomb = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 8), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_STANDARD.ordinal()));
    private static final MerchantRecipe waterBomb = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 12), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_WATER.ordinal()));
    private static final MerchantRecipe fireBomb = new MerchantRecipe(new ItemStack(Items.field_151166_bC, 16), new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FIRE.ordinal()));
    private static final MerchantRecipe bombSeeds = new MerchantRecipe(new ItemStack(ZSSItems.bombFlowerSeed), new ItemStack(Items.field_151166_bC, 4));

    public EntityNpcBarnes(World world) {
        super(world);
    }

    @Override
    protected String getNameTagOnSpawn() {
        return "Barnes";
    }

    protected String func_70639_aQ() {
        return "mob.villager.haggle";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    @Override
    protected void populateTradingList() {
        MerchantRecipeList newTrades = new MerchantRecipeList();
        newTrades.add((Object)standardBomb);
        if (this.trades == null) {
            this.trades = newTrades;
        } else {
            for (int i = 0; i < this.trades.size(); ++i) {
                MerchantRecipeHelper.addToListWithCheck(newTrades, (MerchantRecipe)this.trades.get(i));
            }
            this.trades = newTrades;
        }
    }

    @Override
    protected void refreshTradingList() {
        ListIterator iterator = this.trades.listIterator();
        while (iterator.hasNext()) {
            MerchantRecipe trade = (MerchantRecipe)iterator.next();
            if (this.isBombTrade(trade)) {
                iterator.set(this.getRefreshedBombTrade(trade));
                continue;
            }
            if (!trade.func_82784_g()) continue;
            trade.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
        }
    }

    @Override
    protected void updateTradingList() {
    }

    private boolean isBombTrade(MerchantRecipe trade) {
        return this.isBombTrade(trade.func_77397_d()) || this.isBombTrade(trade.func_77394_a());
    }

    private boolean isBombTrade(ItemStack stack) {
        return stack != null && (stack.func_77973_b() instanceof ItemBomb || stack.func_77973_b() instanceof ItemBombBag || stack.func_77973_b() == ZSSItems.bombFlowerSeed);
    }

    private MerchantRecipe getRefreshedBombTrade(MerchantRecipe trade) {
        MerchantRecipe newTrade = new MerchantRecipe(trade.func_77394_a(), trade.func_77396_b(), trade.func_77397_d());
        newTrade.func_82783_a(92);
        return newTrade;
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (!this.func_70089_S() || player.func_70093_af()) {
            return false;
        }
        if (this.func_70931_l_() != null) {
            if (!this.field_70170_p.field_72995_K) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.merchant.busy", new Object[0]);
            }
            return true;
        }
        ItemStack stack = player.func_70694_bm();
        String chat = "chat.zss.npc.barnes.greeting";
        boolean openGui = true;
        if (stack != null && this.trades != null) {
            if (stack.func_77973_b() == ZSSItems.bombFlowerSeed) {
                chat = this.insertBombTrade(bombSeeds) ? "chat.zss.npc.barnes.trade.bombseeds.new" : "chat.zss.npc.barnes.trade.bombseeds.old";
            } else if (stack.func_77973_b() == Items.field_151115_aP) {
                if (this.insertBombTrade(waterBomb)) {
                    --stack.field_77994_a;
                    chat = "chat.zss.npc.barnes.trade.water";
                    openGui = false;
                }
            } else if (stack.func_77973_b() == Items.field_151064_bs) {
                if (this.insertBombTrade(fireBomb)) {
                    --stack.field_77994_a;
                    chat = "chat.zss.npc.barnes.trade.fire";
                    openGui = false;
                }
            } else if (!MerchantRecipeHelper.hasSimilarTrade(this.trades, waterBomb)) {
                chat = "chat.zss.npc.barnes.material.water";
            } else if (!MerchantRecipeHelper.hasSimilarTrade(this.trades, fireBomb)) {
                chat = "chat.zss.npc.barnes.material.fire";
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            PlayerUtils.sendTranslatedChat(player, chat, new Object[0]);
            if (openGui) {
                this.displayTradingGuiFor(player);
            }
        }
        return true;
    }

    @Override
    public Event.Result canInteractConvert(EntityPlayer player, EntityVillager villager) {
        if (player.field_70170_p.field_72995_K || villager.getClass() != EntityVillager.class || villager.func_70631_g_()) {
            return Event.Result.DEFAULT;
        }
        if (PlayerUtils.consumeHeldItem(player, Items.field_151016_H, 1)) {
            return Event.Result.ALLOW;
        }
        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.barnes.hmph", new Object[0]);
        return Event.Result.DENY;
    }

    @Override
    public Event.Result canLeftClickConvert(EntityPlayer player, EntityVillager villager) {
        return Event.Result.DEFAULT;
    }

    @Override
    public void onConverted(EntityPlayer player) {
        PlayerUtils.sendTranslatedChat(player, "chat.zss.npc.barnes.open", new Object[0]);
        this.populateTradingList();
    }

    public boolean addBombBagTrade() {
        return Config.enableTradeBombBag() && this.insertBombTrade(new MerchantRecipe(new ItemStack(Items.field_151166_bC, Config.getBombBagPrice()), new ItemStack(ZSSItems.bombBag)));
    }

    private boolean insertBombTrade(MerchantRecipe trade) {
        MerchantRecipe r;
        if (this.trades == null || MerchantRecipeHelper.hasSimilarTrade(this.trades, trade)) {
            return false;
        }
        int i = 0;
        for (i = 0; i < this.trades.size() && (r = (MerchantRecipe)this.trades.get(i)).func_77397_d().func_77973_b() instanceof ItemBomb; ++i) {
        }
        this.trades.add(i, (Object)trade);
        return true;
    }
}

