/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import zeldaswordskills.api.entity.ai.IEntityAnimationOffset;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntitySwordBeam;
import zeldaswordskills.skills.SkillBase;
import zeldaswordskills.util.PlayerUtils;

public abstract class EntityDekuBase
extends EntityCreature
implements IMob,
IEntityAnimationOffset {
    protected static byte flag_index;
    public static final byte CUSTOM_DEATH;
    public int custom_death;
    private final int ticksExistedOffset;

    public EntityDekuBase(World world) {
        super(world);
        this.addAITasks();
        this.func_70105_a(0.75f, 2.0f);
        this.field_70728_aV = 5;
        this.ticksExistedOffset = this.getTickOffset(world);
    }

    protected int getTickOffset(World world) {
        return world.field_73012_v.nextInt(3600);
    }

    @Override
    public int getTicksExistedOffset(int action_id) {
        return this.ticksExistedOffset;
    }

    protected void addAITasks() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        ZSSEntityInfo.get((EntityLivingBase)this).applyBuff(Buff.RESIST_STUN, Integer.MAX_VALUE, 100);
    }

    protected String func_70621_aR() {
        return "zeldaswordskills:leaf_hit";
    }

    protected String func_70673_aS() {
        return "zeldaswordskills:leaf_hit";
    }

    public void func_70024_g(double dx, double dy, double dz) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70058_J() {
        return false;
    }

    public boolean isReallyInLava() {
        return this.field_70170_p.func_72875_a(this.field_70121_D.func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151587_i);
    }

    public void func_70031_b(boolean sprinting) {
    }

    protected void func_70664_aZ() {
    }

    public void func_70069_a(float distance) {
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected boolean canAttack() {
        return true;
    }

    public boolean func_70686_a(Class clazz) {
        return !EntityDekuBase.class.isAssignableFrom(clazz) && super.func_70686_a(clazz);
    }

    public boolean func_70685_l(Entity entity) {
        Vec3 end;
        Vec3 start = Vec3.func_72443_a((double)this.field_70165_t, (double)(this.field_70163_u + (double)this.func_70047_e()), (double)this.field_70161_v);
        return this.field_70170_p.func_147447_a(start, end = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v), false, true, false) == null;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        if (!this.canAttack()) {
            return false;
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entity.func_70015_d(j * 4);
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
        }
        return flag;
    }

    protected boolean isSourceFatal(DamageSource source) {
        if (source.func_76364_f() instanceof EntityBoomerang) {
            return true;
        }
        if (source.func_76346_g() instanceof EntityPlayer) {
            return ZSSPlayerSkills.get((EntityPlayer)source.func_76346_g()).isSkillActive(SkillBase.spinAttack);
        }
        return source.func_94541_c() && ZSSEntityInfo.get((EntityLivingBase)this).hasIngestedBomb();
    }

    protected boolean isSlashing(DamageSource source) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)source.func_76364_f();
            if (PlayerUtils.isSword(entity.func_70694_bm())) {
                return true;
            }
        } else if (source.func_76352_a()) {
            return source.func_76364_f() instanceof EntityBoomerang || source.func_76364_f() instanceof EntitySwordBeam;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isReallyInLava()) {
            this.func_70044_A();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70645_a(DamageSource source) {
        byte flag;
        super.func_70645_a(source);
        if (!this.field_70170_p.field_72995_K && (flag = this.getCustomDeathFlag(source)) != 0) {
            this.field_70170_p.func_72960_a((Entity)this, flag);
        }
    }

    protected byte getCustomDeathFlag(DamageSource source) {
        return this.isSlashing(source) ? CUSTOM_DEATH : (byte)0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        if (flag == CUSTOM_DEATH) {
            this.custom_death = this.field_70146_Z.nextInt(2) == 0 ? -1 : 1;
        } else {
            super.func_70103_a(flag);
        }
    }

    protected Item func_146068_u() {
        return Items.field_151055_y;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (!this.isValidSpawnBlock() || !this.isValidLightLevel()) {
            return false;
        }
        return super.func_70601_bi();
    }

    protected boolean isValidSpawnBlock() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.isValidMaterial(this.field_70170_p.func_147439_a(i, j - 1, k).func_149688_o());
    }

    protected boolean isValidMaterial(Material material) {
        return material == Material.field_151577_b || material == Material.field_151578_c || material == Material.field_151571_B || material == Material.field_151595_p;
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int light = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int sky = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            light = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = sky;
        }
        return light <= this.field_70146_Z.nextInt(8);
    }

    static {
        byte by = flag_index = (byte)10;
        flag_index = (byte)(by + 1);
        CUSTOM_DEATH = by;
    }
}

