/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.api.damage.EnumDamageType;
import zeldaswordskills.api.damage.IPostDamageEffect;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.api.entity.IEntityCustomTarget;
import zeldaswordskills.api.entity.ai.EntityAIDynamicAction;
import zeldaswordskills.api.entity.ai.EntityAIDynamicProne;
import zeldaswordskills.api.entity.ai.EntityAITargetBombs;
import zeldaswordskills.api.entity.ai.EntityAction;
import zeldaswordskills.api.entity.ai.IEntityDynamic;
import zeldaswordskills.api.entity.ai.IEntityDynamicAI;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.mobs.EntityDekuBase;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

public class EntityDekuBaba
extends EntityDekuBase
implements IEntityBombEater,
IEntityDynamic,
IEntityCustomTarget {
    public static final byte BOMB_INGESTED;
    public static final EntityAction ACTION_SPROUT;
    public static final EntityAction ACTION_READY;
    public static final EntityAction ACTION_ATTACK;
    public static final EntityAction ACTION_BOMB;
    public static final EntityAction ACTION_PRONE;
    private static final Map<Integer, EntityAction> actionMap;
    public static final int ALERTNESS_INDEX = 17;
    public static final int TARGET_INDEX = 18;
    public static final int CUSTOM_TARGET_INDEX = 19;
    public static final int DIFFICULTY_INDEX = 20;
    public static final int STATUS_INDEX = 21;
    public static final int STATUS_BOMB = 1;
    public static final int STATUS_CONFUSED = 2;
    public static final int MAX_ALERTNESS = 50;
    public static final int FUSE_TIME = 20;
    protected EntityAction action = ACTION_READY;
    protected final List<EntityAction> actionList = new ArrayList<EntityAction>();
    protected int action_timer;
    protected boolean prone;
    protected int status_timer;
    protected Entity target;

    public static String[] getDefaultBiomes() {
        return BiomeType.getBiomeArray(null, BiomeType.FOREST, BiomeType.JUNGLE, BiomeType.PLAINS, BiomeType.RIVER);
    }

    protected static void registerAction(EntityAction action) {
        actionMap.put(action.id, action);
    }

    public EntityDekuBaba(World world) {
        super(world);
        this.actionList.add(this.action);
    }

    @Override
    protected void addAITasks() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDynamicProne(this, ACTION_PRONE, 63));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIDynamicAction(this, ACTION_ATTACK, 4.0f, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITargetBombs(this, ACTION_BOMB, 3.0f, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)-1);
        this.field_70180_af.func_75682_a(19, (Object)-1);
        this.field_70180_af.func_75682_a(20, (Object)this.field_70170_p.field_73013_u.func_151525_a());
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    protected String func_70639_aQ() {
        return this.isFullyAlert() ? "step.grass" : null;
    }

    protected float func_70599_aP() {
        return 0.75f + this.field_70146_Z.nextFloat() * 0.25f;
    }

    protected float func_70647_i() {
        return 0.5f;
    }

    protected int getAlertness() {
        return this.field_70180_af.func_75679_c(17);
    }

    public boolean isFullyAlert() {
        return this.func_70089_S() && this.getActionTime(EntityDekuBaba.ACTION_SPROUT.id) > ACTION_SPROUT.getDuration(this.getActionSpeed(EntityDekuBaba.ACTION_SPROUT.id));
    }

    protected boolean func_70650_aV() {
        return true;
    }

    private void updateAlertness() {
        int modified;
        int i;
        if (this.action == ACTION_PRONE) {
            return;
        }
        int alertness = this.getAlertness();
        int n = i = this.getCurrentTarget() == null ? -1 : 1;
        if (this.getCurrentTarget() != null && !this.func_70685_l(this.getCurrentTarget())) {
            int n2 = i = this.field_70146_Z.nextInt(4) == 0 ? -1 : 0;
        }
        if ((modified = MathHelper.func_76125_a((int)(alertness + i), (int)0, (int)50)) != alertness) {
            this.field_70180_af.func_75692_b(17, (Object)modified);
        }
    }

    public boolean isConfused() {
        return this.field_70180_af.func_75679_c(21) == 2;
    }

    public void setConfused(boolean confused) {
        this.field_70180_af.func_75692_b(21, (Object)(confused ? 2 : 0));
        this.status_timer = confused && this.status_timer == 0 ? this.field_70146_Z.nextInt(80) + this.field_70146_Z.nextInt(80) + 142 : 0;
    }

    public boolean isAttack(int action_id) {
        return action_id == EntityDekuBaba.ACTION_ATTACK.id || action_id == EntityDekuBaba.ACTION_BOMB.id;
    }

    @Override
    public List<EntityAction> getActiveActions() {
        return this.actionList;
    }

    @Override
    public int getActionTime(int action_id) {
        if (action_id == EntityDekuBaba.ACTION_SPROUT.id) {
            return this.getAlertness();
        }
        EntityAction a = this.getActionById(action_id);
        if (a == this.action && this.action_timer > 0) {
            return a.getDuration(this.getActionSpeed(action_id)) - this.action_timer;
        }
        return 0;
    }

    @Override
    public float getActionSpeed(int action_id) {
        int i = this.getDifficultyModifier() - 2;
        if (this.isAttack(action_id)) {
            return 0.7f + (float)i * 0.15f;
        }
        if (action_id == EntityDekuBaba.ACTION_PRONE.id) {
            return 1.0f + (float)i * 0.25f;
        }
        return 1.0f;
    }

    @Override
    public boolean canExecute(int action_id, IEntityDynamicAI ai) {
        if (this.isAttack(action_id)) {
            Entity entity = this.getCurrentTarget();
            return this.action_timer == 0 && entity != null && this.canAttack() && TargetUtils.isTargetInFrontOf((Entity)this, entity, 15.0f);
        }
        if (action_id == EntityDekuBaba.ACTION_PRONE.id) {
            return this.prone;
        }
        return true;
    }

    @Override
    public void beginAction(int action_id, IEntityDynamicAI ai) {
        if (this.isAttack(action_id)) {
            this.func_70642_aH();
        }
        this.setActionState(action_id);
    }

    @Override
    public void endAction(int action_id, IEntityDynamicAI ai) {
        if (action_id == EntityDekuBaba.ACTION_PRONE.id) {
            this.prone = false;
        }
        if (action_id == this.action.id) {
            this.setActionState(EntityDekuBaba.ACTION_READY.id);
        }
    }

    @Override
    public void performAction(int action_id, IEntityDynamicAI ai) {
        Entity target = this.getCurrentTarget();
        if (!this.isConfused()) {
            if (action_id == EntityDekuBaba.ACTION_ATTACK.id) {
                if (target instanceof EntityLivingBase && this.canAttack() && TargetUtils.isTargetInFrontOf((Entity)this, target, 15.0f)) {
                    this.func_70652_k(target);
                }
            } else if (action_id == EntityDekuBaba.ACTION_BOMB.id && target instanceof IEntityBombIngestible && this.canAttack() && TargetUtils.isTargetInFrontOf((Entity)this, target, 15.0f)) {
                IEntityBombIngestible bomb = (IEntityBombIngestible)this.getCurrentTarget();
                if (ZSSEntityInfo.get((EntityLivingBase)this).onBombIngested(bomb)) {
                    this.field_70180_af.func_75692_b(21, (Object)1);
                    this.field_70170_p.func_72960_a((Entity)this, BOMB_INGESTED);
                    double damage = this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    bomb.setExplosionDamage((float)damage * (float)this.field_70170_p.field_73013_u.func_151525_a());
                    bomb.setFuseTime(20);
                    ZSSEntityInfo.get((EntityLivingBase)this).refreshFuseTime();
                }
            }
        }
    }

    public int getDifficultyModifier() {
        return this.field_70180_af.func_75679_c(20);
    }

    public int getBombTimer() {
        return this.status_timer > 0 && this.field_70180_af.func_75679_c(21) == 1 ? 20 - this.status_timer : 0;
    }

    @Override
    public Event.Result ingestBomb(IEntityBombIngestible bomb) {
        return Event.Result.DENY;
    }

    @Override
    public boolean onBombIndigestion(IEntityBombIngestible bomb) {
        this.prone = true;
        return true;
    }

    @Override
    public boolean doesIngestedBombExplode(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public boolean isIngestedBombFatal(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public Entity getCurrentTarget() {
        Entity entity = this.getCustomTarget();
        if (entity == null) {
            entity = this.func_70638_az();
        }
        return entity;
    }

    @Override
    public Entity getCustomTarget() {
        if (this.target == null && this.field_70180_af.func_75679_c(19) > -1) {
            this.target = this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(19));
            if (this.target == null) {
                this.field_70180_af.func_75692_b(19, (Object)-1);
            }
        }
        return this.target;
    }

    @Override
    public void setCustomTarget(Entity entity) {
        this.target = entity;
        this.field_70180_af.func_75692_b(19, (Object)(entity == null ? -1 : entity.func_145782_y()));
    }

    public EntityLivingBase func_70638_az() {
        if (super.func_70638_az() == null && this.field_70180_af.func_75679_c(18) > -1) {
            Entity target = this.field_70170_p.func_73045_a(this.field_70180_af.func_75679_c(18));
            if (target instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)target);
            } else {
                this.field_70180_af.func_75692_b(18, (Object)-1);
            }
        }
        return super.func_70638_az();
    }

    public void func_70624_b(EntityLivingBase entity) {
        super.func_70624_b(entity);
        this.field_70180_af.func_75692_b(18, (Object)(entity == null ? -1 : entity.func_145782_y()));
    }

    @Override
    protected boolean canAttack() {
        return this.isFullyAlert() && this.action != ACTION_PRONE;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        EntityPlayer player;
        boolean blocking = false;
        if (entity instanceof EntityPlayer && PlayerUtils.isBlocking(player = (EntityPlayer)entity) && PlayerUtils.isShield(player.func_70694_bm())) {
            blocking = true;
        }
        boolean flag = super.func_70652_k(entity);
        if (blocking) {
            this.prone = true;
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.isFullyAlert() && source.func_76364_f() != null) {
            return false;
        }
        if (this.isSourceFatal(source)) {
            this.prone ^= !this.isAttack(this.action.id);
            return super.func_70097_a(source, this.func_110138_aP());
        }
        if (this.prone) {
            if (super.func_70097_a(source, this.getSlashDamage(source, amount))) {
                this.onProneAttack(source, amount);
                return true;
            }
            return false;
        }
        if (this.didAttackCauseProne(source, amount)) {
            return true;
        }
        if (this.isDamageEffective(source)) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void onProneAttack(DamageSource source, float amount) {
        if (this.func_110143_aJ() > 0.0f) {
            this.setActionState(EntityDekuBaba.ACTION_READY.id);
            this.action_timer = 10;
        }
    }

    protected boolean didAttackCauseProne(DamageSource source, float amount) {
        boolean flag = false;
        if (this.prone || amount < 0.5f || source.func_76346_g() == null) {
            return false;
        }
        if (source.func_94541_c()) {
            flag = super.func_70097_a(source, Math.max(0.5f, amount * 0.25f));
        } else if (source instanceof IPostDamageEffect && ((IPostDamageEffect)source).getDuration(EnumDamageType.STUN) > 0) {
            amount = Math.max(amount * 0.25f, 0.5f);
            flag = super.func_70097_a(source, amount);
        } else if (this.isAttack(this.action.id) && this.getActionTime(this.action.id) > this.field_70170_p.field_73013_u.func_151525_a()) {
            flag = super.func_70097_a(source, this.getSlashDamage(source, amount));
        }
        if (flag && this.func_110143_aJ() > 0.0f) {
            if (!this.isConfused() && source.func_76364_f() instanceof EntityPlayer && ((EntityPlayer)source.func_76364_f()).func_70694_bm() == null) {
                this.setConfused(true);
            } else {
                this.setConfused(false);
                this.prone = true;
            }
        }
        return flag;
    }

    protected float getSlashDamage(DamageSource source, float amount) {
        return this.isSlashing(source) ? (this.prone ? this.func_110138_aP() : this.func_110138_aP() / 2.0f) : amount;
    }

    protected boolean isDamageEffective(DamageSource source) {
        return source.func_76347_k() || source.func_94541_c() || source.func_82725_o() || source == DamageSource.field_76368_d || source == DamageSource.field_76380_i;
    }

    protected boolean isTargetValid(EntityLivingBase entity) {
        if (!entity.func_70089_S()) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a) {
            return false;
        }
        return entity.func_70068_e((Entity)this) < 100.0;
    }

    @Override
    public void func_70071_h_() {
        Entity target;
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        if (this.target != null && !this.target.func_70089_S()) {
            this.setCustomTarget(null);
        }
        if (this.func_70638_az() != null && !this.isTargetValid(this.func_70638_az())) {
            this.func_70624_b(null);
        }
        this.updateAlertness();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_73013_u.func_151525_a() != this.getDifficultyModifier()) {
                this.field_70180_af.func_75692_b(20, (Object)this.field_70170_p.field_73013_u.func_151525_a());
            }
        } else if (this.isConfused() && this.field_70173_aa % 10 == 0) {
            Vec3 look = this.func_70040_Z();
            for (int i = 0; i < 1; ++i) {
                this.field_70170_p.func_72869_a("spell", this.field_70165_t - look.field_72450_a * 0.5 + 0.1 * this.field_70146_Z.nextGaussian(), this.field_70121_D.field_72337_e + 0.25 + 0.15 * this.field_70146_Z.nextGaussian(), this.field_70161_v - look.field_72449_c * 0.5 + 0.1 * this.field_70146_Z.nextGaussian(), 0.0, 0.0, 0.0);
            }
        }
        if (this.status_timer > 0) {
            --this.status_timer;
            if (this.status_timer == 0 && !this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(21, (Object)0);
            }
        }
        if (this.action_timer > 0 && this.func_70089_S()) {
            --this.action_timer;
            if (this.action_timer == 0) {
                this.setActionState(EntityDekuBaba.ACTION_READY.id);
            }
        }
        if (this.getActionTime(EntityDekuBaba.ACTION_SPROUT.id) > ACTION_SPROUT.getActionFrame(1.0f) && (target = this.getCurrentTarget()) != null && this.action != ACTION_PRONE) {
            this.func_70671_ap().func_75651_a(target, 30.0f, 30.0f);
            double dx = target.field_70165_t - this.field_70165_t;
            double dz = target.field_70161_v - this.field_70161_v;
            double dy = target.field_70163_u - (double)MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b + 0.5));
            double d = dx * dx + dy * dy + dz * dz;
            if (d >= 2.500000277905201E-7) {
                float f = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                this.field_70177_z = this.limitAngle(this.field_70177_z, f, 30.0f);
            }
        }
    }

    @Override
    protected byte getCustomDeathFlag(DamageSource source) {
        if (this.prone || this.isSourceFatal(source)) {
            return super.getCustomDeathFlag(source);
        }
        return 0;
    }

    private float limitAngle(float angle, float target, float max) {
        target = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)(target - angle)), (float)(-max), (float)max);
        return angle + target;
    }

    public EntityAction getActionById(int id) {
        return actionMap.get(id);
    }

    protected boolean setActionState(int id) {
        EntityAction a = this.getActionById(id);
        if (a != null) {
            this.action = a;
            this.prone = this.action == ACTION_PRONE;
            this.action_timer = this.action.getDuration(this.getActionSpeed(this.action.id));
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)this.action.id);
            }
            this.actionList.set(0, this.action);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte flag) {
        if (flag == BOMB_INGESTED) {
            this.status_timer = 20;
        } else if (!this.setActionState(flag)) {
            super.func_70103_a(flag);
        }
    }

    @Override
    protected Item func_146068_u() {
        return this.prone ? Items.field_151055_y : ZSSItems.dekuNut;
    }

    public void func_70109_d(NBTTagCompound compound) {
        super.func_70109_d(compound);
        compound.func_74768_a("statusIndex", this.field_70180_af.func_75679_c(21));
        compound.func_74768_a("statusTimer", this.status_timer);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        this.field_70180_af.func_75692_b(21, (Object)compound.func_74762_e("statusIndex"));
        this.status_timer = compound.func_74762_e("statusTimer");
    }

    static {
        byte by = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by + 1);
        BOMB_INGESTED = by;
        byte by2 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by2 + 1);
        ACTION_SPROUT = new EntityAction(by2, 11, 5);
        byte by3 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by3 + 1);
        ACTION_READY = new EntityAction(by3, 0, 5);
        byte by4 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by4 + 1);
        ACTION_ATTACK = new EntityAction(by4, 16, 7);
        byte by5 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by5 + 1);
        ACTION_BOMB = new EntityAction(by5, EntityDekuBaba.ACTION_ATTACK.duration, EntityDekuBaba.ACTION_ATTACK.action_frame);
        byte by6 = EntityDekuBase.flag_index;
        EntityDekuBase.flag_index = (byte)(by6 + 1);
        ACTION_PRONE = new EntityAction(by6, 60, 0);
        actionMap = new HashMap<Integer, EntityAction>();
        EntityDekuBaba.registerAction(ACTION_SPROUT);
        EntityDekuBaba.registerAction(ACTION_READY);
        EntityDekuBaba.registerAction(ACTION_ATTACK);
        EntityDekuBaba.registerAction(ACTION_BOMB);
        EntityDekuBaba.registerAction(ACTION_PRONE);
    }
}

