/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.mobs;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.IDamageSourceStun;
import zeldaswordskills.api.entity.IEntityBombEater;
import zeldaswordskills.api.entity.IEntityBombIngestible;
import zeldaswordskills.api.entity.IEntityLootable;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BiomeType;
import zeldaswordskills.util.WorldUtils;

public class EntityChu
extends EntityLiving
implements IMob,
IEntityBombEater,
IEntityLootable,
IEntityVariant {
    private static final int CHU_SIZE_INDEX = 16;
    private static final int CHU_TYPE_INDEX = 17;
    private static final int SHOCK_INDEX = 18;
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;
    private int timesMerged;

    public static String[] getDefaultBiomes() {
        ArrayList biomes = Lists.newArrayList((Object[])new BiomeType[]{BiomeType.BEACH, BiomeType.MOUNTAIN});
        for (ChuType type : ChuType.values()) {
            biomes.add(type.favoredBiome);
            biomes.add(type.secondBiome);
        }
        return BiomeType.getBiomeArray(null, biomes.toArray(new BiomeType[biomes.size()]));
    }

    public EntityChu(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(20) + 10;
        this.setType(ChuType.RED);
        this.setSize(1 << this.field_70146_Z.nextInt(3));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)1);
        this.field_70180_af.func_75682_a(17, (Object)((byte)ChuType.RED.ordinal()));
        this.field_70180_af.func_75682_a(18, (Object)0);
    }

    protected EntityChu createInstance() {
        return new EntityChu(this.field_70170_p);
    }

    public ChuType getType() {
        return ChuType.values()[this.field_70180_af.func_75683_a(17)];
    }

    public void setType(ChuType type) {
        this.field_70180_af.func_75692_b(17, (Object)((byte)type.ordinal()));
        this.applyTypeTraits();
    }

    @Override
    public EntityChu setType(int type) {
        this.setType(ChuType.values()[type % ChuType.values().length]);
        return this;
    }

    private void setTypeOnSpawn() {
        if (Config.areMobVariantsAllowed() && this.field_70146_Z.nextFloat() < Config.getMobVariantChance()) {
            this.setType(this.field_70146_Z.nextInt(ChuType.values().length));
        } else {
            BiomeGenBase biome = this.field_70170_p.func_72807_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            BiomeType biomeType = BiomeType.getBiomeTypeFor(biome);
            for (ChuType t : ChuType.values()) {
                if (t.favoredBiome != biomeType && t.secondBiome != biomeType) continue;
                this.setType(t);
                return;
            }
        }
    }

    private void applyTypeTraits() {
        ZSSEntityInfo info = ZSSEntityInfo.get((EntityLivingBase)this);
        info.removeAllBuffs();
        switch (this.getType()) {
            case RED: {
                info.applyBuff(Buff.RESIST_FIRE, Integer.MAX_VALUE, 75);
                break;
            }
            case BLUE: {
                info.applyBuff(Buff.RESIST_MAGIC, Integer.MAX_VALUE, 75);
                info.applyBuff(Buff.RESIST_COLD, Integer.MAX_VALUE, 100);
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 50);
                break;
            }
            case YELLOW: {
                info.applyBuff(Buff.RESIST_SHOCK, Integer.MAX_VALUE, 100);
                break;
            }
        }
    }

    protected boolean canChuTypeShock() {
        return this.getType() == ChuType.YELLOW || this.getType() == ChuType.BLUE && this.field_70146_Z.nextInt(80) == 0;
    }

    public int getShockTime() {
        return this.field_70180_af.func_75679_c(18);
    }

    public void setShockTime(int time) {
        this.field_70180_af.func_75692_b(18, (Object)time);
    }

    protected int getMaxStunTime() {
        return this.getSize() * this.field_70170_p.field_73013_u.func_151525_a() * 10;
    }

    protected int getShockInterval() {
        return this.getType() == ChuType.YELLOW ? 160 : 320;
    }

    public int getSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    protected void setSize(int size) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)size));
        this.func_70105_a(0.6f * (float)size, 0.6f * (float)size);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((size + 1) * (size + 1)));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = size + (this.getType().ordinal() + 1);
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected void func_70069_a(float f) {
    }

    public int func_70658_aO() {
        return this.getSize() + this.getType().ordinal() * 2;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (this.getSize() > 1) {
            int k = this.field_70146_Z.nextInt(4) - 2;
            if (looting > 0) {
                k += this.field_70146_Z.nextInt(looting + 1);
            }
            for (int l = 0; l < k; ++l) {
                this.func_70099_a(new ItemStack(ZSSItems.jellyChu, 1, this.getType().ordinal()), 0.0f);
            }
        }
    }

    protected void func_70600_l(int rarity) {
        switch (rarity) {
            case 1: {
                this.func_70099_a(new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.JELLY_BLOB.ordinal()), 0.0f);
                break;
            }
            default: {
                this.func_70099_a(new ItemStack(this.field_70146_Z.nextInt(3) == 1 ? Items.field_151166_bC : ZSSItems.smallHeart), 0.0f);
            }
        }
    }

    @Override
    public float getLootableChance(EntityPlayer player, IWhipBlock.WhipType whip) {
        return 0.2f;
    }

    @Override
    public ItemStack getEntityLoot(EntityPlayer player, IWhipBlock.WhipType whip) {
        if (this.field_70146_Z.nextFloat() < 0.1f * (float)(1 + whip.ordinal())) {
            return new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.JELLY_BLOB.ordinal());
        }
        return new ItemStack(ZSSItems.jellyChu, 1, this.getType().ordinal());
    }

    @Override
    public boolean onLootStolen(EntityPlayer player, boolean wasItemStolen) {
        return true;
    }

    @Override
    public boolean isHurtOnTheft(EntityPlayer player, IWhipBlock.WhipType whip) {
        return Config.getHurtOnSteal();
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSize() > 0;
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSize() > 1 ? "big" : "small");
    }

    protected boolean makesSoundOnLand() {
        return this.getSize() > 1;
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_72912_H().func_76067_t().handleSlimeSpawnReduction(this.field_70146_Z, this.field_70170_p)) {
            return false;
        }
        if (this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL) {
            if (this.field_70163_u > 50.0 && this.field_70146_Z.nextFloat() < 0.5f && this.field_70146_Z.nextFloat() < this.field_70170_p.func_130001_d() && this.field_70170_p.func_72957_l(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)) <= this.field_70146_Z.nextInt(8)) {
                return super.func_70601_bi();
            }
            Chunk chunk = this.field_70170_p.func_72938_d(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v));
            if (this.field_70146_Z.nextInt(10) == 0 && chunk.func_76617_a(432191789L).nextInt(10) == 0 && this.field_70163_u < 50.0) {
                return super.func_70601_bi();
            }
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76368_d) {
            return false;
        }
        if (this.getShockTime() > 0) {
            if (source instanceof EntityDamageSourceIndirect) {
                if (source.func_82725_o()) {
                    return super.func_70097_a(source, amount);
                }
                if (source.func_94541_c()) {
                    ZSSEntityInfo.get((EntityLivingBase)this).stun(20 + this.field_70146_Z.nextInt((int)(amount * 5.0f) + 1));
                    this.setShockTime(0);
                } else if (source instanceof IDamageSourceStun) {
                    this.setShockTime(0);
                }
            } else if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityPlayer && !source.field_76373_n.equals("thorns")) {
                source.func_76346_g().func_70097_a(this.getDamageSource(), this.getDamage());
                this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:shock", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.0f));
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    protected float getDamage() {
        return this.getSize() + this.getType().ordinal();
    }

    private DamageSource getDamageSource() {
        if (this.getShockTime() > 0) {
            return new DamageUtils.DamageSourceShock("shock", (Entity)this, this.getMaxStunTime(), this.getDamage());
        }
        switch (this.getType()) {
            case BLUE: {
                return new DamageUtils.DamageSourceIce("mob", (Entity)this, 50, this.getSize() > 2 ? 1 : 0);
            }
        }
        return new EntityDamageSource("mob", (Entity)this);
    }

    public void func_70100_b_(EntityPlayer player) {
        if (this.field_70724_aR > 0) {
            return;
        }
        double d = 0.36 * (double)(this.getSize() * this.getSize());
        if (this.func_70685_l((Entity)player) && this.func_70068_e((Entity)player) < d && player.func_70097_a(this.getDamageSource(), this.getDamage())) {
            int t;
            this.field_70724_aR = 20;
            this.func_85030_a("mob.slime.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            if (this.field_70146_Z.nextFloat() < 0.25f * (float)this.getSize()) {
                this.applySecondaryEffects(player);
            }
            if ((t = this.getShockTime()) > 0) {
                this.setShockTime(Math.max(0, t - this.field_70146_Z.nextInt(100) - 50));
            }
        }
    }

    private void applySecondaryEffects(EntityPlayer player) {
        switch (this.getType()) {
            case GREEN: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.ATTACK_DOWN, 200, 50);
                break;
            }
            case BLUE: {
                ZSSEntityInfo.get((EntityLivingBase)player).applyBuff(Buff.WEAKNESS_COLD, 200, 50);
                break;
            }
        }
    }

    public void func_70071_h_() {
        int time;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            if (this.field_70170_p.field_72995_K) {
                this.spawnParticlesOnLanding();
                if (this.makesSoundOnLand()) {
                    this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
                }
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            int i = this.getSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
        if ((time = this.getShockTime()) > 0) {
            this.setShockTime(time - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticlesOnLanding() {
        int i = this.getSize();
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        switch (this.getType()) {
            case RED: {
                r = 0.65f;
                g = 0.25f;
                b = 0.3f;
                break;
            }
            case BLUE: {
                r = 0.25f;
                g = 0.4f;
                b = 0.75f;
                break;
            }
            case YELLOW: {
                g = 0.65f;
                b = 0.0f;
                break;
            }
        }
        for (int j = 0; j < i * 8; ++j) {
            float f3;
            float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
            EntityBreakingFX particle = new EntityBreakingFX(this.field_70170_p, this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b, this.field_70161_v + (double)(f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1), Items.field_151123_aH);
            if (particle == null) continue;
            particle.func_70538_b(r, g, b);
            WorldUtils.spawnWorldParticles(this.field_70170_p, (EntityFX)particle);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (player != null) {
            this.func_70625_a((Entity)player, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (player != null) {
                this.slimeJumpDelay /= 3;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
        if (this.canChuTypeShock() && this.getShockTime() == 0 && !ZSSEntityInfo.get((EntityLivingBase)this).isBuffActive(Buff.STUN) && player != null && (this.field_70718_bc > 0 || this.field_70146_Z.nextInt(this.getShockInterval()) == 0)) {
            this.setShockTime(this.field_70146_Z.nextInt(this.getSize() * 50) + this.field_70170_p.field_73013_u.func_151525_a() * (this.field_70146_Z.nextInt(20) + 10));
        }
        if (this.getShockTime() % 8 > 5 && this.field_70146_Z.nextInt(4) == 0) {
            this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:shock", this.func_70599_aP(), 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.0f));
        }
        if (this.field_70122_E && this.timesMerged < 4) {
            this.attemptMerge();
        }
    }

    public void func_70106_y() {
        int i = this.getSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityChu chu = this.createInstance();
                chu.setSize(i / 2);
                chu.setType(this.getType());
                chu.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                chu.timesMerged = this.timesMerged;
                this.field_70170_p.func_72838_d((Entity)chu);
            }
        }
        super.func_70106_y();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(20) + 10;
    }

    private void attemptMerge() {
        int i = this.getSize();
        if (!this.field_70170_p.field_72995_K && i < 3 && this.func_110143_aJ() < this.func_110138_aP() / 2.0f && this.field_70146_Z.nextInt(16) == 0) {
            List list = this.field_70170_p.func_72872_a(EntityChu.class, this.field_70121_D.func_72314_b(2.0, 1.0, 2.0));
            for (EntityChu chu : list) {
                if (chu == this || chu.getSize() != this.getSize() || !(chu.func_110143_aJ() < chu.func_110138_aP() / 2.0f)) continue;
                this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:chu_merge", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.0f));
                EntityChu newChu = this.createInstance();
                newChu.setSize(i * 2);
                newChu.setType(this.getType().ordinal() < chu.getType().ordinal() ? chu.getType() : this.getType());
                newChu.func_70012_b((this.field_70165_t + chu.field_70165_t) / 2.0, this.field_70163_u + 0.5, (this.field_70161_v + chu.field_70161_v) / 2.0, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                newChu.timesMerged = this.field_70146_Z.nextInt(4) + 1 + this.timesMerged;
                this.field_70170_p.func_72838_d((Entity)newChu);
                chu.field_70128_L = true;
                this.field_70128_L = true;
                break;
            }
        }
    }

    @Override
    public Event.Result ingestBomb(IEntityBombIngestible bomb) {
        this.field_70170_p.func_72956_a((Entity)this, "zeldaswordskills:chu_merge", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.0f));
        return Event.Result.DEFAULT;
    }

    @Override
    public boolean onBombIndigestion(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public boolean doesIngestedBombExplode(IEntityBombIngestible bomb) {
        return true;
    }

    @Override
    public boolean isIngestedBombFatal(IEntityBombIngestible bomb) {
        return this.getSize() < 4;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.setTypeOnSpawn();
        return data;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Size", this.getSize() - 1);
        compound.func_74768_a("ChuType", this.getType().ordinal());
        compound.func_74768_a("timesMerged", this.timesMerged);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSize(compound.func_74762_e("Size") + 1);
        this.field_70180_af.func_75692_b(17, (Object)((byte)compound.func_74762_e("ChuType")));
        this.timesMerged = compound.func_74762_e("timesMerged");
    }

    public static enum ChuType {
        RED(BiomeType.RIVER, BiomeType.FIERY),
        GREEN(BiomeType.PLAINS, BiomeType.FOREST),
        BLUE(BiomeType.TAIGA, BiomeType.COLD),
        YELLOW(BiomeType.ARID, BiomeType.JUNGLE);

        public final BiomeType favoredBiome;
        public final BiomeType secondBiome;

        private ChuType(BiomeType favoredBiome, BiomeType secondBiome) {
            this.favoredBiome = favoredBiome;
            this.secondBiome = secondBiome;
        }
    }
}

