/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity.ai;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import zeldaswordskills.entity.player.ZSSPlayerSkills;

public class EntityAITeleport
extends EntityAIBase {
    public final EntityCreature entity;
    public final double range;
    public final double rangeSq;
    public final int minTeleportDelay;
    protected int teleportDelay;
    protected int delayTimer;
    protected int triggerTimer;
    public final boolean isGrounded;
    public final boolean randomTele;
    public final boolean approachTele;
    public final boolean fleeTele;
    public final boolean hurtTele;
    protected AxisAlignedBB teleBounds;
    protected boolean isTeleporting;

    public EntityAITeleport(EntityCreature entity, double teleRange, int delay, boolean grounded, boolean random, boolean approach, boolean flee, boolean hurt) {
        this.entity = entity;
        this.range = teleRange;
        this.rangeSq = teleRange * teleRange;
        this.minTeleportDelay = delay;
        this.isGrounded = grounded;
        this.randomTele = random;
        this.approachTele = approach;
        this.fleeTele = flee;
        this.hurtTele = hurt;
        this.func_75248_a(8);
    }

    public AxisAlignedBB getTeleBounds() {
        return this.teleBounds;
    }

    public void setTeleBounds(AxisAlignedBB newBounds) {
        this.teleBounds = newBounds;
    }

    public void scheduleNextTeleport(int ticks) {
        this.triggerTimer = this.triggerTimer > 0 ? Math.min(this.triggerTimer, Math.max(0, ticks)) : Math.max(0, ticks);
    }

    public boolean invalidateBounds(double rangeSq) {
        double z;
        double y;
        double x;
        if (this.teleBounds != null && this.entity.func_70092_e(x = this.teleBounds.field_72340_a + (this.teleBounds.field_72336_d - this.teleBounds.field_72340_a) / 2.0, y = this.teleBounds.field_72338_b + (this.teleBounds.field_72337_e - this.teleBounds.field_72338_b) / 2.0, z = this.teleBounds.field_72339_c + (this.teleBounds.field_72334_f - this.teleBounds.field_72339_c) / 2.0) > rangeSq) {
            this.setTeleBounds(null);
            return false;
        }
        return true;
    }

    public void func_75251_c() {
        this.delayTimer = 0;
        this.triggerTimer = 0;
        this.isTeleporting = false;
    }

    public boolean func_75250_a() {
        if (this.isTeleporting) {
            return false;
        }
        if (this.randomTele) {
            return this.entity.func_70089_S();
        }
        return this.entity.func_70638_az() != null;
    }

    public void func_75246_d() {
        boolean flag = false;
        EntityLivingBase target = this.entity.func_70638_az();
        ++this.delayTimer;
        if (this.triggerTimer > 0 && --this.triggerTimer == 0) {
            flag = true;
        } else if (this.randomTele && this.delayTimer > this.teleportDelay) {
            flag = true;
        } else if (this.fleeTele && this.delayTimer > this.teleportDelay / 2 && target != null && this.entity.func_70068_e((Entity)target) < this.range) {
            flag = true;
        } else if (this.hurtTele && this.entity.field_70172_ad > 10 && this.delayTimer > this.entity.field_70172_ad) {
            flag = true;
        } else if (this.approachTele && target != null && this.entity.func_70068_e((Entity)target) > this.rangeSq && (this.teleBounds == null || this.teleBounds.func_72318_a(Vec3.func_72443_a((double)target.field_70165_t, (double)target.field_70163_u, (double)target.field_70161_v))) && !this.entity.field_70170_p.field_72995_K) {
            this.isTeleporting = true;
            for (int i = 0; i < 64 && !EntityAITeleport.teleportToEntity(this.entity.field_70170_p, (EntityLivingBase)this.entity, (Entity)target); ++i) {
            }
        }
        if (flag && !this.entity.field_70170_p.field_72995_K) {
            this.teleportRandomly();
        }
    }

    public boolean teleportRandomly() {
        this.isTeleporting = true;
        for (int i = 0; i < 64; ++i) {
            if (!EntityAITeleport.teleportRandomly(this.entity.field_70170_p, (EntityLivingBase)this.entity, this.range, this.teleBounds, this.isGrounded)) continue;
            return true;
        }
        return false;
    }

    public boolean canTeleport() {
        return !this.isTeleporting && this.delayTimer > this.teleportDelay;
    }

    public boolean isTeleporting() {
        return this.isTeleporting;
    }

    public void setTeleporting() {
        this.isTeleporting = true;
    }

    public void onPostTeleport(double originX, double originY, double originZ) {
        this.teleportDelay = this.minTeleportDelay + this.entity.field_70170_p.field_73012_v.nextInt(this.minTeleportDelay * 2) - this.entity.field_70170_p.field_73012_v.nextInt(this.minTeleportDelay / 2 + 1);
        this.delayTimer = 0;
        this.triggerTimer = 0;
        this.isTeleporting = false;
    }

    public static boolean teleportRandomly(World world, EntityLivingBase entity, double range) {
        return EntityAITeleport.teleportRandomly(world, entity, range, null, true);
    }

    public static boolean teleportRandomly(World world, EntityLivingBase entity, double range, AxisAlignedBB restriction, boolean grounded) {
        int rangeY = (int)range;
        if (range < 1.0 || rangeY < 1) {
            return false;
        }
        double x = entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * range;
        double y = entity.field_70163_u + (double)(world.field_73012_v.nextInt(rangeY) - rangeY / 2);
        double z = entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * range;
        return EntityAITeleport.teleportTo(world, entity, x, y, z, restriction, grounded, true);
    }

    public static boolean teleportToEntity(World world, EntityLivingBase entity, Entity target) {
        return EntityAITeleport.teleportToEntity(world, entity, target, null, true);
    }

    public static boolean teleportToEntity(World world, EntityLivingBase entity, Entity target, AxisAlignedBB restriction, boolean grounded) {
        Vec3 vec3 = Vec3.func_72443_a((double)(entity.field_70165_t - target.field_70165_t), (double)(entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - target.field_70163_u + (double)target.func_70047_e()), (double)(entity.field_70161_v - target.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double x = entity.field_70165_t + (world.field_73012_v.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double y = entity.field_70163_u + (double)(world.field_73012_v.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double z = entity.field_70161_v + (world.field_73012_v.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return EntityAITeleport.teleportTo(world, entity, x, y, z, restriction, grounded, true);
    }

    public static boolean teleportTo(World world, EntityLivingBase entity, double x, double y, double z) {
        return EntityAITeleport.teleportTo(world, entity, x, y, z, null, true, true);
    }

    public static boolean teleportTo(World world, EntityLivingBase entity, double x, double y, double z, AxisAlignedBB restriction, boolean grounded, boolean noLiquid) {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = entity.field_70165_t;
        double d4 = entity.field_70163_u;
        double d5 = entity.field_70161_v;
        entity.field_70165_t = event.targetX;
        entity.field_70163_u = event.targetY;
        entity.field_70161_v = event.targetZ;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        if (entity.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)entity.field_70163_u), k = MathHelper.func_76128_c((double)entity.field_70161_v))) {
            boolean foundSolidBlock;
            boolean bl = foundSolidBlock = !grounded;
            if (grounded) {
                while (!foundSolidBlock && j > 0) {
                    Block block = entity.field_70170_p.func_147439_a(i, j - 1, k);
                    if (block.func_149688_o().func_76230_c()) {
                        foundSolidBlock = true;
                        continue;
                    }
                    entity.field_70163_u -= 1.0;
                    --j;
                }
            }
            if (foundSolidBlock) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (restriction != null && !restriction.func_72318_a(Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v))) {
                    flag = false;
                } else if (!(!world.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() || noLiquid && world.func_72953_d(entity.field_70121_D))) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            entity.func_70107_b(d3, d4, d5);
            return false;
        }
        if (entity instanceof EntityPlayer) {
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
        for (int l = 0; l < 128; ++l) {
            double d6 = (double)l / 127.0;
            float f = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (entity.field_70165_t - d3) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d8 = d4 + (entity.field_70163_u - d4) * d6 + world.field_73012_v.nextDouble() * (double)entity.field_70131_O;
            double d9 = d5 + (entity.field_70161_v - d5) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            entity.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        entity.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        MinecraftForge.EVENT_BUS.post((Event)new PostEnderTeleport(entity, d3, d4, d5, 0.0f));
        return true;
    }

    public static void disruptTargeting(EntityLivingBase entity) {
        if (entity.field_70170_p instanceof WorldServer) {
            Set players = ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers((Entity)entity);
            for (EntityPlayer player : players) {
                ZSSPlayerSkills skills = ZSSPlayerSkills.get(player);
                if (skills.getTargetingSkill() == null || skills.getTargetingSkill().getCurrentTarget() != entity) continue;
                skills.getTargetingSkill().setCurrentTarget(player, null);
            }
        }
    }

    public static class PostEnderTeleport
    extends EnderTeleportEvent {
        public PostEnderTeleport(EntityLivingBase entity, double originX, double originY, double originZ, float damage) {
            super(entity, originX, originY, originZ, damage);
        }
    }
}

