/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.entity.EntityFairy;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class EntityNavi
extends EntityFairy
implements IEntityOwnable {
    private static final int OWNER_INDEX = 17;
    private EntityPlayer owner;

    public EntityNavi(World world) {
        super(world);
        this.func_110163_bv();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)"");
    }

    @Override
    public void setFairyHome(double x, double y, double z) {
        super.setFairyHome(x, y, z);
        this.home = null;
    }

    @Override
    public boolean func_70692_ba() {
        return false;
    }

    @Override
    protected void func_82167_n(Entity entity) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getOwner() == null && this.field_70173_aa > 10) {
                this.func_70106_y();
            } else if (Config.getNaviRange() > 0 && this.field_70173_aa % Config.getNaviFrequency() == 0) {
                this.detectDungeons();
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (this.getOwner() != null && this.field_70173_aa % 30 == 0) {
            Vec3 look = this.owner.func_70040_Z();
            int x = MathHelper.func_76128_c((double)(this.owner.field_70165_t - look.field_72450_a));
            int y = MathHelper.func_76128_c((double)(this.owner.field_70163_u + (double)this.owner.func_70047_e()));
            int z = MathHelper.func_76128_c((double)(this.owner.field_70161_v - look.field_72449_c));
            this.home = new int[]{x, y + 1, z};
            if (this.owner.func_70068_e((Entity)this) > 144.0) {
                this.func_70012_b(this.owner.field_70165_t + look.field_72450_a, this.owner.field_70163_u + (double)this.owner.func_70047_e(), this.owner.field_70161_v + look.field_72449_c, this.field_70177_z, this.field_70125_A);
            }
        }
        super.func_70619_bc();
    }

    public String func_152113_b() {
        return this.field_70180_af.func_75681_e(17);
    }

    public void setOwnerUUID(String uuid) {
        this.field_70180_af.func_75692_b(17, (Object)uuid);
    }

    public EntityPlayer getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        try {
            UUID uuid = UUID.fromString(this.func_152113_b());
            if (uuid != null) {
                this.owner = this.field_70170_p.func_152378_a(uuid);
            }
            return this.owner;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player;
        this.setOwnerUUID(player.func_110124_au().toString());
    }

    private void detectDungeons() {
        int range = Config.getNaviRange();
        double r2 = range * range;
        int r = range + range / 2;
        int ry = MathHelper.func_76123_f((float)((float)r / 2.0f));
        int x = MathHelper.func_76128_c((double)(this.owner.field_70165_t + 0.5));
        int y = MathHelper.func_76128_c((double)(this.owner.field_70163_u + (double)this.owner.func_70047_e()));
        int z = MathHelper.func_76128_c((double)(this.owner.field_70161_v + 0.5));
        boolean search = true;
        for (int i = x - r; i <= x + r && search; ++i) {
            for (int j = y - ry; j <= y + ry && search; ++j) {
                for (int k = z - r; k <= z + r && search; ++k) {
                    double d;
                    if (!(this.field_70170_p.func_147439_a(i, j, k) instanceof BlockSecretStone) || !((d = this.owner.func_70092_e((double)i + 0.5, (double)j + 0.5, (double)k + 0.5)) <= r2)) continue;
                    float f = (float)(Math.sqrt(d) / (double)r);
                    PlayerUtils.playSound(this.owner, "zeldaswordskills:fairy_laugh", 0.6f - f / 2.0f, 1.0f);
                    search = false;
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        String uuid = this.func_152113_b();
        if (uuid != null && uuid.length() > 0) {
            compound.func_74778_a("OwnerUUID", uuid);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        String string = s = compound.func_150297_b("OwnerUUID", 8) ? compound.func_74779_i("OwnerUUID") : "";
        if (s.length() > 0) {
            this.setOwnerUUID(s);
        }
    }
}

