/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import zeldaswordskills.api.damage.DamageUtils;
import zeldaswordskills.api.damage.EnumDamageType;

public class EntityEtherLightning
extends EntityLightningBolt {
    private int lightningState;
    private int boltLivingTime;
    protected final EntityLivingBase thrower;
    protected EntityLivingBase target;

    public EntityEtherLightning(World world, EntityLivingBase thrower, EntityLivingBase target, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.thrower = thrower;
        this.target = target;
        this.func_70012_b(posX, posY, posZ, 0.0f, 0.0f);
        this.lightningState = 2;
        this.field_70264_a = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doFireTick") && (world.field_73013_u == EnumDifficulty.NORMAL || world.field_73013_u == EnumDifficulty.HARD) && this.field_70170_p.func_72873_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 10)) {
            this.extinguishFire(world);
        }
    }

    public void func_70071_h_() {
        super.func_70030_z();
        if (this.lightningState == 2) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.field_70264_a = this.field_70146_Z.nextLong();
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.field_73016_r = 2;
            } else if (this.target != null) {
                int strength = (this.field_70170_p.func_72896_J() ? 20 : 0) + (this.field_70170_p.func_72911_I() ? 30 : 0);
                float damage = 15.0f + (float)this.field_70146_Z.nextInt(11) + (float)strength * 0.2f;
                if (this.target.field_70122_E) {
                    damage /= 3.0f;
                }
                int time = 600 + (strength > 0 || !this.target.field_70122_E ? this.field_70146_Z.nextInt(10) + this.field_70146_Z.nextInt(Math.max(1, strength)) + 10 : 0);
                DamageSource source = new DamageUtils.DamageSourceBaseIndirect("lightningBolt", (Entity)this, (Entity)this.thrower, true, EnumDamageType.SHOCK).func_82726_p().func_76348_h();
                if (time > 0) {
                    ((DamageUtils.DamageSourceBaseIndirect)source).setStunDamage(time, 1, true);
                }
                this.target.func_70097_a(source, damage);
                if (!ForgeEventFactory.onEntityStruckByLightning((Entity)this.target, (EntityLightningBolt)this)) {
                    this.target.func_70077_a((EntityLightningBolt)this);
                }
                this.target = null;
            }
        }
    }

    private void extinguishFire(World world) {
        int dx = MathHelper.func_76128_c((double)this.field_70165_t);
        int dy = MathHelper.func_76128_c((double)this.field_70163_u);
        int dz = MathHelper.func_76128_c((double)this.field_70161_v);
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (world.func_147439_a(dx + i, dy + j, dz + k) != Blocks.field_150480_ab) continue;
                    world.func_147468_f(dx + i, dy + j, dz + k);
                }
            }
        }
    }
}

