/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.handler.BattlegearEvents;
import zeldaswordskills.item.ItemHeroBow;

@SideOnly(value=Side.CLIENT)
public class RenderItemCustomBow
implements IItemRenderer {
    private static final ItemStack vanillaArrow = new ItemStack(Items.field_151032_g);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], true);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedBow(item, (EntityLivingBase)data[1], false);
                break;
            }
        }
    }

    private void renderEquippedBow(ItemStack stack, EntityLivingBase entity, boolean firstPerson) {
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        if (entity instanceof EntityPlayer) {
            if (!firstPerson) {
                GL11.glRotated((double)15.0, (double)0.02, (double)0.01, (double)0.0);
                GL11.glTranslated((double)0.1, (double)-0.3, (double)0.2);
            }
            EntityPlayer player = (EntityPlayer)entity;
            IIcon icon = stack.func_77973_b().getIcon(stack, 0, player, player.func_71011_bu(), player.func_71052_bv());
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            int useDuration = player.func_71057_bx();
            if (useDuration > 0) {
                ItemStack quiverArrow;
                ItemStack arrowStack;
                int drawAmount = useDuration > 17 ? 2 : (useDuration > 13 ? 1 : 0);
                ItemStack itemStack = arrowStack = stack.func_77973_b() instanceof ItemHeroBow ? ((ItemHeroBow)stack.func_77973_b()).getArrow(player) : vanillaArrow;
                if (ZSSMain.isBG2Enabled && (quiverArrow = BattlegearEvents.getQuiverArrow(stack, player)) != null) {
                    arrowStack = quiverArrow;
                }
                if (arrowStack != null) {
                    icon = arrowStack.func_77954_c();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(-(-3.0f + (float)drawAmount) / 16.0f), (float)(-(-3.0f + (float)drawAmount) / 16.0f), (float)(firstPerson ? -0.03125f : 0.03125f));
                    ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94209_e(), (float)icon.func_94206_g(), (float)icon.func_94212_f(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                    GL11.glPopMatrix();
                }
            }
        } else {
            IIcon icon = stack.func_77973_b().getIcon(stack, 0);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
        GL11.glPopMatrix();
    }
}

