/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.render.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.entity.mobs.EntityChu;

@SideOnly(value=Side.CLIENT)
public class RenderEntityChu
extends RenderLiving {
    private static final ResourceLocation redChu = new ResourceLocation("zeldaswordskills", "textures/entity/chu_red.png");
    private static final ResourceLocation greenChu = new ResourceLocation("zeldaswordskills", "textures/entity/chu_green.png");
    private static final ResourceLocation blueChu = new ResourceLocation("zeldaswordskills", "textures/entity/chu_blue.png");
    private static final ResourceLocation blueChuShock = new ResourceLocation("zeldaswordskills", "textures/entity/chu_blue_shock.png");
    private static final ResourceLocation yellowChu = new ResourceLocation("zeldaswordskills", "textures/entity/chu_yellow.png");
    private static final ResourceLocation yellowChuShock = new ResourceLocation("zeldaswordskills", "textures/entity/chu_yellow_shock.png");
    private ModelBase scaleAmount = new ModelSlime(0);

    public RenderEntityChu() {
        super((ModelBase)new ModelSlime(16), 0.25f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getChuTexture((EntityChu)entity);
    }

    protected ResourceLocation getChuTexture(EntityChu chu) {
        switch (chu.getType()) {
            case RED: {
                return redChu;
            }
            case GREEN: {
                return greenChu;
            }
            case BLUE: {
                return chu.getShockTime() % 8 > 5 ? blueChuShock : blueChu;
            }
            case YELLOW: {
                return chu.getShockTime() % 8 > 5 ? yellowChuShock : yellowChu;
            }
        }
        return redChu;
    }

    protected int shouldChuRenderPass(EntityChu chu, int renderPass, float partialTick) {
        if (chu.func_82150_aj()) {
            return 0;
        }
        if (renderPass == 0) {
            this.func_77042_a(this.scaleAmount);
            GL11.glEnable((int)2977);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            return 1;
        }
        if (renderPass == 1) {
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return -1;
    }

    protected void scaleEntity(EntityChu chu, float partialTick) {
        float f1 = chu.getSize();
        float f2 = (chu.prevSquishFactor + (chu.squishFactor - chu.prevSquishFactor) * partialTick) / (f1 * 0.5f + 1.0f);
        float f3 = 1.0f / (f2 + 1.0f);
        GL11.glScalef((float)(f3 * f1), (float)(1.0f / f3 * f1), (float)(f3 * f1));
    }

    protected void func_77041_b(EntityLivingBase entity, float partialTick) {
        this.scaleEntity((EntityChu)entity, partialTick);
    }

    protected int func_77032_a(EntityLivingBase entity, int renderPass, float partialTick) {
        return this.shouldChuRenderPass((EntityChu)entity, renderPass, partialTick);
    }
}

