/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import zeldaswordskills.entity.mobs.EntityWizzrobe;

@SideOnly(value=Side.CLIENT)
public class ModelWizzrobe
extends ModelBase {
    private ModelRenderer hat;
    private ModelRenderer head;
    private ModelRenderer body;
    private ModelRenderer rightArm;
    private ModelRenderer leftArm;
    private ModelRenderer robe;
    private int maxCastTick;
    public boolean atPeak;
    private static final float[] rotX = new float[]{-0.5f, -1.35f, -2.0f, -2.5f};
    private static final float[] rotZ = new float[]{0.1f, 0.15f, 0.2f, 0.25f};

    public ModelWizzrobe() {
        this(0.0f, 0.0f);
    }

    public ModelWizzrobe(float f1, float f2) {
        this.field_78090_t = 64;
        this.field_78089_u = 128;
        this.head = new ModelRenderer((ModelBase)this, 0, 0).func_78787_b(this.field_78090_t, this.field_78089_u);
        this.head.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, f1);
        this.head.func_78793_a(0.0f, 0.0f + f2, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 0, 16).func_78787_b(this.field_78090_t, this.field_78089_u);
        this.body.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 8, 4, f1);
        this.body.func_78793_a(0.0f, 0.0f + f2, 0.0f);
        this.rightArm = new ModelRenderer((ModelBase)this, 32, 10).func_78787_b(this.field_78090_t, this.field_78089_u);
        this.rightArm.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, f1);
        this.rightArm.func_78793_a(-5.0f, 2.0f + f2, 0.0f);
        this.leftArm = new ModelRenderer((ModelBase)this, 32, 10).func_78787_b(this.field_78090_t, this.field_78089_u);
        this.leftArm.field_78809_i = true;
        this.leftArm.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, f1);
        this.leftArm.func_78793_a(5.0f, 2.0f + f2, 0.0f);
        this.robe = new ModelRenderer((ModelBase)this, 32, 0).func_78787_b(this.field_78090_t, this.field_78089_u);
        this.robe.func_78790_a(-4.0f, 0.0f, -3.0f, 8, 4, 6, f1);
        this.robe.func_78793_a(0.0f, 8.0f + f2, 0.0f);
        this.setRotation(this.robe, 0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.robe);
        ModelRenderer robeMid = new ModelRenderer((ModelBase)this, 0, 28).func_78787_b(this.field_78090_t, this.field_78089_u);
        robeMid.func_78790_a(-5.0f, 0.0f, -4.0f, 10, 6, 8, f1);
        robeMid.func_78793_a(0.0f, 4.0f + f2, 0.0f);
        this.setRotation(robeMid, 0.0f, 0.0f, 0.0f);
        this.robe.func_78792_a(robeMid);
        ModelRenderer robeLower = new ModelRenderer((ModelBase)this, 0, 42).func_78787_b(this.field_78090_t, this.field_78089_u);
        robeLower.func_78790_a(-6.0f, 0.0f, -5.0f, 12, 6, 10, f1);
        robeLower.func_78793_a(0.0f, 6.0f + f2, 0.0f);
        this.setRotation(robeLower, 0.0f, 0.0f, 0.0f);
        robeMid.func_78792_a(robeLower);
        this.hat = new ModelRenderer((ModelBase)this, 24, 58).func_78787_b(this.field_78090_t, this.field_78089_u);
        this.hat.func_78793_a(-5.0f, -10.03125f, -5.0f);
        this.hat.func_78789_a(0.0f, 0.0f, 0.0f, 10, 2, 10);
        this.head.func_78792_a(this.hat);
        ModelRenderer hatLayer1 = new ModelRenderer((ModelBase)this, 36, 31).func_78787_b(this.field_78090_t, this.field_78089_u);
        hatLayer1.func_78793_a(1.75f, -4.0f, 2.0f);
        hatLayer1.func_78789_a(0.0f, 0.0f, 0.0f, 7, 4, 7);
        hatLayer1.field_78795_f = -0.05235988f;
        hatLayer1.field_78808_h = 0.02617994f;
        this.hat.func_78792_a(hatLayer1);
        ModelRenderer hatLayer2 = new ModelRenderer((ModelBase)this, 48, 14).func_78787_b(this.field_78090_t, this.field_78089_u);
        hatLayer2.func_78793_a(1.75f, -4.0f, 2.0f);
        hatLayer2.func_78789_a(0.0f, 0.0f, 0.0f, 4, 4, 4);
        hatLayer2.field_78795_f = -0.10471976f;
        hatLayer2.field_78808_h = 0.05235988f;
        hatLayer1.func_78792_a(hatLayer2);
        ModelRenderer hatLayer3 = new ModelRenderer((ModelBase)this, 26, 18).func_78787_b(this.field_78090_t, this.field_78089_u);
        hatLayer3.func_78793_a(1.75f, -2.0f, 2.0f);
        hatLayer3.func_78790_a(0.0f, 0.0f, 0.0f, 1, 2, 1, 0.25f);
        hatLayer3.field_78795_f = -0.20943952f;
        hatLayer3.field_78808_h = 0.10471976f;
        hatLayer2.func_78792_a(hatLayer3);
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
        this.head.func_78785_a(f5);
        this.body.func_78785_a(f5);
        this.rightArm.func_78785_a(f5);
        this.leftArm.func_78785_a(f5);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void func_78086_a(EntityLivingBase entity, float par2, float par3, float par4) {
        this.setLivingAnimations((EntityWizzrobe)entity, par2, par3, par4);
    }

    private void setLivingAnimations(EntityWizzrobe entity, float par2, float par3, float par4) {
        int castTime = entity.getCurrentCastingTime();
        if (castTime > 0) {
            this.maxCastTick = entity.getMaxCastingTime() - 1;
            int i = 0;
            if (castTime == 1 || castTime == this.maxCastTick) {
                i = 0;
            } else if (castTime == 2 || castTime == this.maxCastTick - 1) {
                i = 1;
            } else if (castTime == 3 || castTime == this.maxCastTick - 2) {
                i = 2;
                this.atPeak = false;
            } else {
                i = 3;
                this.atPeak = true;
            }
            this.rightArm.field_78795_f = rotX[i];
            this.leftArm.field_78795_f = rotX[i];
            this.rightArm.field_78808_h = -rotZ[i];
            this.leftArm.field_78808_h = rotZ[i];
        } else {
            this.rightArm.field_78808_h = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
        }
    }

    public void func_78087_a(float f1, float f2, float f3, float f4, float f5, float f6, Entity entity) {
        super.func_78087_a(f1, f2, f3, f4, f5, f6, entity);
        this.head.field_78796_g = f4 / 57.295776f;
        if (((EntityWizzrobe)entity).getCurrentCastingTime() == 0) {
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f;
            this.atPeak = false;
        }
    }
}

