/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.client.RenderHelperQ;
import zeldaswordskills.client.gui.IGuiOverlay;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.Buff;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.ref.Config;

@SideOnly(value=Side.CLIENT)
public class GuiMagicMeter
extends Gui
implements IGuiOverlay {
    private static final ResourceLocation textureHorizontal = new ResourceLocation("zeldaswordskills", "textures/gui/magic_meter_horizontal.png");
    private static final ResourceLocation textureVertical = new ResourceLocation("zeldaswordskills", "textures/gui/magic_meter_vertical.png");
    private static int MAX_WIDTH;
    private static int NUM_INCREMENTS;
    private static float INCREMENT;
    public static final int METER_HEIGHT = 9;
    private final Minecraft mc;

    public static void setMaxWidth(int value) {
        MAX_WIDTH = MathHelper.func_76125_a((int)value, (int)25, (int)100);
        INCREMENT = (float)MAX_WIDTH / (float)NUM_INCREMENTS;
    }

    public static void setNumIncrements(int value) {
        NUM_INCREMENTS = MathHelper.func_76125_a((int)value, (int)1, (int)10);
        INCREMENT = (float)MAX_WIDTH / (float)NUM_INCREMENTS;
    }

    public static int getLeftX(ScaledResolution resolution) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return 0;
        }
        return (Config.isMagicMeterCenteredX ? resolution.func_78326_a() / 2 : (Config.isMagicMeterLeft ? 0 : resolution.func_78326_a() - (Config.isMagicMeterEnabled ? (Config.isMagicMeterHorizontal ? MAX_WIDTH : 9) : 0))) + Config.magicMeterOffsetX;
    }

    public static int getRightX(ScaledResolution resolution) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return 0;
        }
        int left = GuiMagicMeter.getLeftX(resolution);
        return Config.isMagicMeterEnabled ? (Config.isMagicMeterHorizontal ? left + MAX_WIDTH : left + 9) : left;
    }

    public static int getTopY(ScaledResolution resolution) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return 0;
        }
        int y = (Config.isMagicMeterTop ? 0 : resolution.func_78328_b() - (Config.isMagicMeterEnabled ? (Config.isMagicMeterHorizontal ? 9 : MAX_WIDTH + 6) : 0)) + Config.magicMeterOffsetY;
        if (Config.isMagicMeterTextEnabled && !Config.isMagicMeterTop) {
            y -= Minecraft.func_71410_x().field_71466_p.field_78288_b + (Config.isMagicMeterEnabled ? 2 : 0);
        }
        return y;
    }

    public static int getBottomY(ScaledResolution resolution) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return 0;
        }
        int y = (Config.isMagicMeterTop ? (Config.isMagicMeterEnabled ? (Config.isMagicMeterHorizontal ? 9 : MAX_WIDTH + 6) : 0) : resolution.func_78328_b()) + Config.magicMeterOffsetY;
        if (Config.isMagicMeterTextEnabled && Config.isMagicMeterTop) {
            y += Minecraft.func_71410_x().field_71466_p.field_78288_b + (Config.isMagicMeterEnabled ? 2 : 0);
        }
        return y;
    }

    public GuiMagicMeter(Minecraft mc) {
        this.mc = mc;
        GuiMagicMeter.setMaxWidth(Config.magicMeterWidth);
        GuiMagicMeter.setNumIncrements(Config.magicMeterIncrements);
    }

    @Override
    public boolean shouldRender() {
        if (this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            return false;
        }
        return (Config.isMagicMeterEnabled || Config.isMagicMeterTextEnabled) && ZSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g).getMaxMagic() > 0.0f;
    }

    @Override
    public void renderOverlay(ScaledResolution resolution) {
        ZSSPlayerInfo info = ZSSPlayerInfo.get((EntityPlayer)this.mc.field_71439_g);
        boolean unlimited = ZSSEntityInfo.get((EntityLivingBase)this.mc.field_71439_g).isBuffActive(Buff.UNLIMITED_MAGIC);
        float maxMana = info.getMaxMagic();
        int width = MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)(maxMana / 50.0f * INCREMENT)), (int)MathHelper.func_76141_d((float)INCREMENT), (int)MAX_WIDTH);
        int current = MathHelper.func_76141_d((float)(info.getCurrentMagic() / maxMana * (float)width));
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        if (unlimited) {
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)1.0f, (float)1.0f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int xPos = (Config.isMagicMeterCenteredX ? resolution.func_78326_a() / 2 : (Config.isMagicMeterLeft ? 0 : resolution.func_78326_a())) + Config.magicMeterOffsetX;
        int yPos = (Config.isMagicMeterTop ? 0 : resolution.func_78328_b()) + Config.magicMeterOffsetY;
        if (Config.isMagicMeterEnabled) {
            if (Config.isMagicMeterHorizontal) {
                int n = Config.isMagicMeterLeft ? 0 : width + 6;
                int n2 = Config.isMagicMeterTop ? 0 : 9;
                this.mc.func_110434_K().func_110577_a(textureHorizontal);
                RenderHelperQ.drawTexturedRect(xPos -= n, yPos -= n2, 0, 0, 3 + width, 9, 106, 12);
                RenderHelperQ.drawTexturedRect(xPos + 3 + width, yPos, 103, 0, 3, 9, 106, 12);
                RenderHelperQ.drawTexturedRect(xPos + 3 + (Config.isMagicMeterLeft ? 0 : width - current), yPos + 3, 0, 9, current, 3, 106, 12);
                xPos += Config.isMagicMeterLeft ? 0 : width + 6;
                yPos += Config.isMagicMeterTop ? 11 : -2;
            } else {
                int n = Config.isMagicMeterLeft ? 0 : 9;
                int n3 = Config.isMagicMeterTop ? 0 : width + 6;
                this.mc.func_110434_K().func_110577_a(textureVertical);
                RenderHelperQ.drawTexturedRect(xPos -= n, yPos -= n3, 0, 0, 9, 3 + width, 12, 106);
                RenderHelperQ.drawTexturedRect(xPos, yPos + 3 + width, 0, 103, 9, 3, 12, 106);
                RenderHelperQ.drawTexturedRect(xPos + 3, yPos + 3 + (width - current), 9, 0, 3, current, 12, 106);
                xPos += Config.isMagicMeterLeft ? 0 : 9;
                yPos += Config.isMagicMeterTop ? width + 8 : -(width + 8);
            }
        }
        if (Config.isMagicMeterTextEnabled) {
            String mp = "MP " + (int)Math.ceil(info.getCurrentMagic()) + "/" + (int)Math.ceil(info.getMaxMagic());
            this.mc.field_71466_p.func_85187_a(mp, xPos -= Config.isMagicMeterLeft ? 0 : this.mc.field_71466_p.func_78256_a(mp), yPos -= Config.isMagicMeterTop ? 0 : this.mc.field_71466_p.field_78288_b, 0xFFFFFF, true);
        }
        GL11.glPopAttrib();
    }

    static {
        NUM_INCREMENTS = 2;
    }
}

