/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import zeldaswordskills.client.gui.GuiMagicMeter;
import zeldaswordskills.client.gui.IGuiOverlay;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.buff.BuffBase;
import zeldaswordskills.ref.Config;

@SideOnly(value=Side.CLIENT)
public class GuiBuffBar
extends Gui
implements IGuiOverlay {
    private final Minecraft mc;
    private final ResourceLocation textures;
    private static final int ICON_SIZE = 18;
    public static final int ICON_SPACING = 20;
    private static final int ICONS_PER_ROW = 8;

    public GuiBuffBar(Minecraft mc) {
        this.mc = mc;
        this.textures = new ResourceLocation("zeldaswordskills", "textures/gui/bufficons.png");
    }

    @Override
    public boolean shouldRender() {
        return Config.isBuffBarEnabled && !ZSSEntityInfo.get((EntityLivingBase)this.mc.field_71439_g).getActiveBuffs().isEmpty();
    }

    @Override
    public void renderOverlay(ScaledResolution resolution) {
        int xPos = Config.isBuffBarLeft ? 2 : resolution.func_78326_a() - 22;
        int yPos = 2;
        if ((Config.isMagicMeterEnabled || Config.isMagicMeterTextEnabled) && Config.isMagicMeterTop && Config.isBuffBarLeft == Config.isMagicMeterLeft && (Config.isBuffBarLeft ? GuiMagicMeter.getLeftX(resolution) < 20 : GuiMagicMeter.getRightX(resolution) > xPos) && GuiMagicMeter.getBottomY(resolution) > yPos) {
            if (Config.isMagicMeterHorizontal) {
                yPos = GuiMagicMeter.getBottomY(resolution) + (Config.isMagicMeterTextEnabled ? 0 : 2);
            } else {
                xPos = Config.isBuffBarLeft ? GuiMagicMeter.getRightX(resolution) + (Config.isMagicMeterTextEnabled ? 0 : 2) : GuiMagicMeter.getLeftX(resolution) - 20;
            }
        }
        int offset = 0;
        int increment = Config.isBuffBarHorizontal && !Config.isBuffBarLeft ? -20 : 20;
        Collection<BuffBase> buffs = ZSSEntityInfo.get((EntityLivingBase)this.mc.field_71439_g).getActiveBuffs();
        if (!buffs.isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(this.textures);
            for (BuffBase buff : buffs) {
                if (buff.getBuff().hasIcon()) {
                    int index = buff.getIconIndex();
                    this.func_73729_b(xPos += Config.isBuffBarHorizontal ? offset : 0, yPos += Config.isBuffBarHorizontal ? 0 : offset, index % 8 * 18, index / 8 * 18, 18, 18);
                    if (buff.displayArrow()) {
                        this.func_73729_b(xPos, yPos, buff.isDebuff() ? 18 : 0, 0, 18, 18);
                    }
                }
                offset = increment;
            }
            GL11.glPopAttrib();
        }
    }
}

