/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import zeldaswordskills.client.gui.GuiMagicMeter;
import zeldaswordskills.client.gui.IGuiOverlay;
import zeldaswordskills.entity.ZSSEntityInfo;
import zeldaswordskills.entity.player.ZSSPlayerSkills;
import zeldaswordskills.item.ICyclableItem;
import zeldaswordskills.network.PacketDispatcher;
import zeldaswordskills.network.server.EndComboPacket;
import zeldaswordskills.ref.Config;
import zeldaswordskills.skills.Combo;
import zeldaswordskills.skills.ICombo;
import zeldaswordskills.skills.ILockOnTarget;
import zeldaswordskills.skills.SkillBase;

@SideOnly(value=Side.CLIENT)
public class ComboOverlay
extends Gui
implements IGuiOverlay {
    private final Minecraft mc;
    private Combo combo = null;
    private int lastComboSize = 0;
    private long displayStartTime;
    private static final long DISPLAY_TIME = 5000L;

    public ComboOverlay(Minecraft mc) {
        this.mc = mc;
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    public void renderOverlay(ScaledResolution resolution) {
        ZSSPlayerSkills skills = ZSSPlayerSkills.get((EntityPlayer)this.mc.field_71439_g);
        if (skills != null) {
            this.updateComboHUD(skills, resolution);
            ILockOnTarget skill = skills.getTargetingSkill();
            if (skill == null || skill.isLockedOn()) {
                // empty if block
            }
        }
    }

    private void updateComboHUD(ZSSPlayerSkills skills, ScaledResolution resolution) {
        ICombo iCombo = skills.getComboSkill();
        if (iCombo != null && iCombo.getCombo() != null && this.combo != iCombo.getCombo()) {
            this.combo = iCombo.getCombo();
            this.lastComboSize = this.combo.getNumHits();
            this.displayStartTime = Minecraft.func_71386_F();
            if (iCombo.getCombo().isFinished()) {
                iCombo.setCombo(null);
                PacketDispatcher.sendToServer(new EndComboPacket((SkillBase)((Object)iCombo)));
            }
        }
        if (this.combo != null && this.combo.getNumHits() > 0) {
            if (this.lastComboSize != this.combo.getNumHits()) {
                this.lastComboSize = this.combo.getNumHits();
                this.displayStartTime = Minecraft.func_71386_F();
            }
            if (Minecraft.func_71386_F() - this.displayStartTime < 5000L) {
                if (Config.isComboHudEnabled) {
                    this.displayComboText(resolution);
                }
                if (skills.getActiveSkill(SkillBase.endingBlow) != null && skills.getActiveSkill(SkillBase.endingBlow).canUse((EntityPlayer)this.mc.field_71439_g)) {
                    ICombo skill = skills.getComboSkill();
                    ILockOnTarget target = skills.getTargetingSkill();
                    if (skill != null && skill.isComboInProgress() && target != null && target.getCurrentTarget() == skill.getCombo().getLastEntityHit()) {
                        this.mc.field_71466_p.func_85187_a(StatCollector.func_74838_a((String)"combo.ending"), resolution.func_78326_a() / 2 - 15, 30, 0xFF0000, true);
                    }
                }
            }
        }
    }

    private void displayComboText(ScaledResolution resolution) {
        int xPos = 2;
        int yPos = 2;
        boolean flag = true;
        if ((Config.isMagicMeterEnabled || Config.isMagicMeterTextEnabled) && Config.isMagicMeterLeft) {
            if (Config.isMagicMeterHorizontal || Config.isMagicMeterTextEnabled) {
                flag = Config.isMagicMeterHorizontal;
                yPos += GuiMagicMeter.getBottomY(resolution) + (Config.isMagicMeterTextEnabled ? 0 : 2);
            } else {
                xPos = GuiMagicMeter.getRightX(resolution) + (Config.isMagicMeterTextEnabled ? 0 : 2);
            }
        }
        if (flag && Config.isBuffBarEnabled && Config.isBuffBarLeft && !ZSSEntityInfo.get((EntityLivingBase)this.mc.field_71439_g).getActiveBuffs().isEmpty()) {
            if (Config.isBuffBarHorizontal) {
                yPos += 20;
            } else {
                xPos += 20;
            }
        }
        if (flag && Config.isItemModeEnabled && Config.isItemModeTop && Config.isItemModeLeft && this.mc.field_71439_g.func_70694_bm() != null && this.mc.field_71439_g.func_70694_bm().func_77973_b() instanceof ICyclableItem) {
            yPos += 20;
        }
        String s = this.combo.isFinished() ? StatCollector.func_74838_a((String)"combo.finished") + "! " : StatCollector.func_74838_a((String)"combo.combo") + ": ";
        this.mc.field_71466_p.func_85187_a(s + this.combo.getLabel(), xPos, yPos, this.combo.isFinished() ? 9699539 : 0xEEEE00, true);
        this.mc.field_71466_p.func_85187_a(StatCollector.func_74838_a((String)"combo.size") + ": " + this.combo.getNumHits() + "/" + this.combo.getMaxNumHits(), xPos, yPos += this.mc.field_71466_p.field_78288_b, 0xFFFFFF, true);
        this.mc.field_71466_p.func_85187_a(StatCollector.func_74838_a((String)"combo.damage") + ": " + String.format("%.1f", Float.valueOf(this.combo.getDamage())), xPos, yPos += this.mc.field_71466_p.field_78288_b, 0xFFFFFF, true);
        List<Float> damageList = this.combo.getDamageList();
        for (int i = 0; i < damageList.size() && i < Config.getHitsToDisplay(); ++i) {
            this.mc.field_71466_p.func_85187_a(" +" + String.format("%.1f", damageList.get(damageList.size() - i - 1)), xPos, yPos += this.mc.field_71466_p.field_78288_b, 0xFFFFFF, true);
        }
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + height, zLevel, 0.0, 1.0);
        tessellator.func_78374_a(x + width, y + height, zLevel, 1.0, 1.0);
        tessellator.func_78374_a(x + width, y + 0.0, zLevel, 1.0, 0.0);
        tessellator.func_78374_a(x + 0.0, y + 0.0, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }
}

