/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.entity.player.ZSSPlayerSongs;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.songs.ZeldaSongs;
import zeldaswordskills.util.PlayerUtils;

public class TileEntityInscription
extends TileEntity {
    private AbstractZeldaSong song = ZeldaSongs.songTime;

    public boolean canUpdate() {
        return false;
    }

    public AbstractZeldaSong getSong() {
        return this.song;
    }

    public void setSong(AbstractZeldaSong song) {
        if (song != null && !song.canLearnFromInscription(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h, this.field_145847_g)) {
            ZSSMain.logger.warn(String.format("%s cannot be learned from inscriptions; coordinates: %d/%d/%d", song.getDisplayName(), this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return;
        }
        this.song = song;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void setNextSong() {
        List<String> songs = ZeldaSongs.getRegisteredNames();
        int i = Math.max(0, songs.indexOf(this.song) + 1);
        if (i == songs.size()) {
            i = 0;
        }
        this.song = null;
        boolean looped = false;
        while (this.song == null && i < songs.size()) {
            this.song = ZeldaSongs.getSongByName(songs.get(i));
            if (this.song.canLearnFromInscription(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h, this.field_145847_g)) continue;
            this.song = null;
            if (++i != songs.size() || looped) continue;
            looped = true;
            i = 0;
        }
        this.setSong(this.song);
    }

    public boolean onActivated(EntityPlayer player) {
        if (this.song == null) {
            ZSSMain.logger.warn(String.format("TileEntityInscription at %d/%d/%d does not have a valid song!", this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return false;
        }
        ItemStack stack = player.func_70694_bm();
        if (player.field_71075_bZ.field_75098_d) {
            if (player.func_70093_af()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.setNextSong();
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.song.inscription.new", new ChatComponentTranslation(this.song.getTranslationString(), new Object[0]));
                }
            } else if (!this.field_145850_b.field_72995_K) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.song.inscription.current", new ChatComponentTranslation(this.song.getTranslationString(), new Object[0]));
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() instanceof ItemInstrument) {
            if (this.field_145850_b.field_72995_K) {
                ZSSPlayerSongs.get((EntityPlayer)player).songToLearn = this.song;
                player.openGui((Object)ZSSMain.instance, 5, player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        if (this.field_145850_b.field_72995_K) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.song.inscription.fail", new Object[0]);
        }
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("SongName")) {
            this.song = ZeldaSongs.getSongByName(compound.func_74779_i("SongName"));
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.song != null) {
            compound.func_74778_a("SongName", this.song.getUnlocalizedName());
        }
    }
}

