/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.BlockWarpStone;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonBlock;
import zeldaswordskills.entity.IEntityVariant;
import zeldaswordskills.entity.mobs.EntityChu;
import zeldaswordskills.entity.mobs.EntityDarknut;
import zeldaswordskills.entity.mobs.EntityKeese;
import zeldaswordskills.entity.mobs.EntityOctorok;
import zeldaswordskills.entity.mobs.EntityWizzrobe;
import zeldaswordskills.entity.player.ZSSPlayerInfo;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.world.crisis.BossBattle;
import zeldaswordskills.world.gen.feature.FairySpawner;

public class TileEntityDungeonCore
extends TileEntityDungeonBlock {
    protected StructureBoundingBox box;
    private FairySpawner fairySpawner = null;
    private boolean isBossRoom = false;
    private BossType dungeonType;
    private BossBattle bossBattle = null;
    private boolean isOpened;
    private Block door = null;
    private int doorMeta = 0;
    private int doorSide;
    private boolean alreadyVerified = false;

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void setDungeonBoundingBox(StructureBoundingBox box) {
        this.box = box;
    }

    public StructureBoundingBox getDungeonBoundingBox() {
        return this.box;
    }

    public void setBossType(BossType type) {
        this.dungeonType = type;
        this.isBossRoom = true;
    }

    public BossType getBossType() {
        return this.dungeonType;
    }

    public void setDoor(Block block, int meta, int side) {
        this.door = block;
        this.doorMeta = meta;
        this.doorSide = side;
    }

    public boolean isSpawner() {
        return this.fairySpawner != null;
    }

    public void setSpawner() {
        if (this.box == null) {
            this.alreadyVerified = true;
            this.setDungeonBoundingBox(new StructureBoundingBox(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 3, this.field_145851_c + 3, this.field_145848_d + 4, this.field_145849_e + 3));
        }
        this.fairySpawner = new FairySpawner(this).setMaxFairies(this.field_145850_b.field_73012_v.nextInt(5) + 2);
    }

    public void scheduleItemUpdate(EntityPlayer player) {
        if (this.isSpawner()) {
            this.fairySpawner.scheduleItemUpdate(player);
        }
    }

    public boolean consumeRupees(int amount) {
        return this.isSpawner() && this.fairySpawner.consumeRupees(amount);
    }

    private boolean shouldUpdate() {
        return this.bossBattle == null && this.field_145850_b.func_82737_E() % 20L == 0L && this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 16.0) != null;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isBossRoom && this.bossBattle == null) {
            if (this.box == null) {
                ZSSMain.logger.warn(String.format("Boss room at %d/%d/%d missing structure bounding box - dungeon is being disabled", this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.verifyStructure(true);
                this.removeCoreBlock();
            } else {
                EntityPlayer closestPlayer = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)(this.box.func_78883_b() - 2) / 2.0);
                if (closestPlayer != null && this.box.func_78890_b(MathHelper.func_76128_c((double)closestPlayer.field_70165_t), MathHelper.func_76128_c((double)closestPlayer.field_70163_u), MathHelper.func_76128_c((double)closestPlayer.field_70161_v))) {
                    if (!this.isOpened) {
                        PlayerUtils.sendTranslatedChat(closestPlayer, "chat.zss.dungeon.sneak_in", new Object[0]);
                        this.verifyStructure(true);
                        this.alreadyVerified = true;
                    }
                    this.bossBattle = this.dungeonType.getBossBattle(this);
                    if (this.bossBattle != null) {
                        this.bossBattle.beginCrisis(this.field_145850_b);
                    }
                }
            }
        }
        if (this.bossBattle != null) {
            this.bossBattle.onUpdate(this.field_145850_b);
            if (this.bossBattle.isFinished()) {
                this.bossBattle = null;
                this.removeCoreBlock();
            }
        } else if (this.shouldUpdate()) {
            if (!this.alreadyVerified && this.box != null && !this.verifyStructure(false)) {
                this.verifyStructure(true);
                this.alreadyVerified = true;
                if (this.isBossRoom) {
                    this.isOpened = true;
                } else {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
                    this.removeCoreBlock();
                }
            } else if (this.isSpawner()) {
                this.fairySpawner.onUpdate();
            }
        }
    }

    protected void removeCoreBlock() {
        EntityPlayer player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.5, (double)this.field_145849_e + 0.5, 16.0);
        if (player != null) {
            ZSSPlayerInfo info = ZSSPlayerInfo.get(player);
            if (this.dungeonType != null) {
                this.clearDungeon();
                info.addStat(ZSSPlayerInfo.Stats.STAT_BOSS_ROOMS, 1 << this.dungeonType.ordinal());
                player.func_71029_a((StatBase)ZSSAchievements.bossBattle);
                if (info.getStat(ZSSPlayerInfo.Stats.STAT_BOSS_ROOMS) == 127) {
                    player.func_71029_a((StatBase)ZSSAchievements.bossComplete);
                }
                if (this.dungeonType == BossType.DESERT || this.dungeonType == BossType.OCEAN || this.dungeonType == BossType.HELL) {
                    player.func_71029_a((StatBase)ZSSAchievements.swordPendant);
                }
            } else {
                info.addStat(ZSSPlayerInfo.Stats.STAT_SECRET_ROOMS, 1);
                player.func_71029_a((StatBase)ZSSAchievements.bombsAway);
                if (info.getStat(ZSSPlayerInfo.Stats.STAT_SECRET_ROOMS) > 49) {
                    player.func_71029_a((StatBase)ZSSAchievements.bombJunkie);
                }
                if (this.field_145850_b.field_73012_v.nextFloat() < Config.getRoomSpawnMobChance()) {
                    this.spawnRandomMob();
                }
            }
        }
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.isSpawner()) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta & 0xFFFFFFF7, 2);
        } else {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockSecretStone.getBlockFromMeta(meta), 0, 2);
        }
    }

    public void removeHinderBlock() {
        int x = this.box.func_78881_e() + (this.doorSide == 3 ? 1 : (this.doorSide == 1 ? -1 : 0));
        int z = this.box.func_78891_g() + (this.doorSide == 0 ? 1 : (this.doorSide == 2 ? -1 : 0));
        int y = this.field_145850_b.func_147439_a(x, this.box.field_78895_b + 2, z) == ZSSBlocks.secretStone ? this.box.field_78895_b + 2 : this.box.field_78895_b + 3;
        this.field_145850_b.func_147468_f(x, y, z);
    }

    private void spawnRandomMob() {
        if (this.field_145850_b.field_72995_K || this.box == null || this.box.func_78883_b() < 5) {
            return;
        }
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        Object mob = null;
        int rarity = this.field_145850_b.field_73012_v.nextInt(64) - this.field_145850_b.field_73013_u.func_151525_a() * 2;
        int type = -1;
        if (block.func_149688_o() == Material.field_151586_h) {
            mob = new EntityOctorok(this.field_145850_b);
            type = rarity < 8 ? 1 : 0;
        } else if (block.func_149688_o() == Material.field_151587_i) {
            mob = new EntityKeese(this.field_145850_b).setSpawnSwarm(false);
            type = rarity > 7 ? EntityKeese.KeeseType.FIRE.ordinal() : EntityKeese.KeeseType.CURSED.ordinal();
        } else {
            mob = rarity > 50 ? new EntityZombie(this.field_145850_b) : (rarity > 40 ? new EntitySkeleton(this.field_145850_b) : (rarity > 30 ? (this.field_145850_b.field_73012_v.nextInt(8) > 1 ? new EntitySpider(this.field_145850_b) : new EntityCaveSpider(this.field_145850_b)) : (rarity > 20 ? new EntityCreeper(this.field_145850_b) : (rarity > 10 ? new EntityKeese(this.field_145850_b).setSpawnSwarm(false) : (rarity > 4 ? new EntityChu(this.field_145850_b) : (rarity > -2 ? new EntityWizzrobe(this.field_145850_b) : new EntityDarknut(this.field_145850_b)))))));
        }
        if (mob != null) {
            mob.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5);
            mob.func_110161_a(null);
            if (type > -1 && mob instanceof IEntityVariant) {
                ((IEntityVariant)mob).setType(type);
            }
            this.field_145850_b.func_72838_d((Entity)mob);
            mob.func_70642_aH();
        }
    }

    private void clearDungeon() {
        Integer meta;
        int x = this.box.func_78881_e();
        int z = this.box.func_78891_g();
        switch (this.doorSide) {
            case 0: {
                z = this.box.field_78892_f - 1;
                break;
            }
            case 2: {
                z = this.box.field_78896_c + 1;
                break;
            }
            case 3: {
                x = this.box.field_78893_d - 1;
                break;
            }
            case 1: {
                x = this.box.field_78897_a + 1;
            }
        }
        if (this.field_145850_b.func_147439_a(x, this.box.field_78895_b + 1, z) == Blocks.field_150321_G) {
            this.field_145850_b.func_147468_f(x, this.box.field_78895_b + 1, z);
        }
        if (this.field_145850_b.func_147439_a(x, this.box.field_78895_b + 2, z) == Blocks.field_150321_G) {
            this.field_145850_b.func_147468_f(x, this.box.field_78895_b + 2, z);
        }
        this.placeOpenDoor(this.field_145850_b.func_147439_a(x, this.box.field_78895_b + 1, z).func_149688_o().func_76224_d() ? 2 : 1);
        if (this.dungeonType.warpSong != null && (meta = BlockWarpStone.reverseLookup.get(this.dungeonType.warpSong)) != null) {
            this.field_145850_b.func_147465_d(x, this.box.field_78895_b, z, ZSSBlocks.warpStone, meta.intValue(), 2);
        }
    }

    private void placeOpenDoor(int dy) {
        int x = this.box.func_78881_e();
        int z = this.box.func_78891_g();
        switch (this.doorSide) {
            case 0: {
                z = this.box.field_78892_f;
                break;
            }
            case 2: {
                z = this.box.field_78896_c;
                break;
            }
            case 3: {
                x = this.box.field_78893_d;
                break;
            }
            case 1: {
                x = this.box.field_78897_a;
            }
        }
        this.field_145850_b.func_147468_f(x, this.box.field_78895_b + dy, z);
        this.field_145850_b.func_147468_f(x, this.box.field_78895_b + dy + 1, z);
    }

    private boolean verifyDoor() {
        int x = this.box.func_78881_e();
        int z = this.box.func_78891_g();
        switch (this.doorSide) {
            case 0: {
                z = this.box.field_78892_f;
                break;
            }
            case 2: {
                z = this.box.field_78896_c;
                break;
            }
            case 3: {
                x = this.box.field_78893_d;
                break;
            }
            case 1: {
                x = this.box.field_78897_a;
                break;
            }
            default: {
                ZSSMain.logger.warn(String.format("Verifying door in Dungeon Core with invalid door side at %d/%d/%d", this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
        for (int y = this.box.field_78895_b; y < this.box.field_78894_e; ++y) {
            if (this.field_145850_b.func_147439_a(x, y, z) != this.door) continue;
            return this.door instanceof IDungeonBlock ? ((IDungeonBlock)this.door).isSameVariant(this.field_145850_b, x, y, z, this.doorMeta) : true;
        }
        return false;
    }

    public void onBlockBroken() {
        if (!this.alreadyVerified) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, "zeldaswordskills:secret_medley", 1.0f, 1.0f);
            this.verifyStructure(true);
        }
        if (this.isSpawner()) {
            this.fairySpawner.onBlockBroken();
        }
    }

    protected boolean verifyStructure(boolean replace) {
        if (this.box != null && this.func_145830_o()) {
            if (!replace && this.door != null) {
                return this.verifyDoor();
            }
            int invalid = 0;
            for (int i = this.box.field_78897_a; i <= this.box.field_78893_d; ++i) {
                for (int j = this.box.field_78895_b; j <= this.box.field_78894_e; ++j) {
                    for (int k = this.box.field_78896_c; k <= this.box.field_78892_f; ++k) {
                        if (i != this.box.field_78897_a && i != this.box.field_78893_d && j != this.box.field_78895_b && j != this.box.field_78894_e && k != this.box.field_78896_c && k != this.box.field_78892_f) continue;
                        Block block = this.field_145850_b.func_147439_a(i, j, k);
                        if (replace) {
                            if (block != ZSSBlocks.secretStone) continue;
                            int meta = this.field_145850_b.func_72805_g(i, j, k);
                            this.field_145850_b.func_147465_d(i, j, k, BlockSecretStone.getBlockFromMeta(meta), 0, 2);
                            continue;
                        }
                        if (block instanceof IDungeonBlock || ++invalid <= 2) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("hasBB", this.box != null);
        if (this.box != null) {
            tag.func_74782_a("boxBounds", (NBTBase)this.box.func_151535_h());
        }
        tag.func_74757_a("verified", this.alreadyVerified);
        tag.func_74757_a("isBossRoom", this.isBossRoom);
        if (this.isBossRoom) {
            tag.func_74778_a("dungeonName", this.dungeonType.getUnlocalizedName());
            tag.func_74757_a("isOpened", this.isOpened);
            tag.func_74757_a("hasBossBattle", this.bossBattle != null);
            if (this.bossBattle != null) {
                this.bossBattle.writeToNBT(tag);
            }
        }
        tag.func_74757_a("hasDoor", this.door != null);
        if (this.door != null) {
            tag.func_74768_a("doorBlockId", Block.func_149682_b((Block)this.door));
            tag.func_74768_a("doorMeta", this.doorMeta);
            tag.func_74768_a("doorSide", this.doorSide);
        }
        if (this.isSpawner()) {
            this.fairySpawner.writeToNBT(tag);
        }
        compound.func_74782_a("ZSSDungeonCore", (NBTBase)tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagCompound tag = compound.func_74775_l("ZSSDungeonCore");
        if (tag.func_74764_b("boxBounds")) {
            this.box = new StructureBoundingBox(tag.func_74759_k("boxBounds"));
        }
        this.alreadyVerified = tag.func_74764_b("verified") ? tag.func_74767_n("verified") : false;
        boolean bl = this.isBossRoom = tag.func_74764_b("isBossRoom") ? tag.func_74767_n("isBossRoom") : tag.func_74767_n("isLocked");
        if (this.isBossRoom) {
            if (tag.func_74764_b("dungeonName")) {
                this.dungeonType = BossType.getBossType(tag.func_74779_i("dungeonName"));
            } else {
                ZSSMain.logger.warn(String.format("Detected old boss dungeon save format at %d/%d/%d - if you still see this message after saving and reloading near this location, please contact the mod author", this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.dungeonType = BossType.values()[tag.func_74762_e("dungeonType") % BossType.values().length];
            }
            this.isOpened = tag.func_74767_n("isOpened");
            if (this.dungeonType == null) {
                ZSSMain.logger.error(String.format("Error retrieving Boss Type from string %s while loading Dungeon Core from NBT at %d/%d/%d", tag.func_74779_i("dungeonName"), this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (tag.func_74767_n("hasBossBattle")) {
                this.bossBattle = this.dungeonType.getBossBattle(this);
                if (this.bossBattle != null) {
                    this.bossBattle.readFromNBT(tag);
                } else {
                    ZSSMain.logger.warn(String.format("Error retrieving Boss Battle while loading Dungeon Core from NBT at %d/%d/%d - returned NULL", this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
            }
        }
        if (tag.func_74767_n("hasDoor")) {
            int id = tag.func_74762_e("doorBlockId");
            this.door = id > 0 ? Block.func_149729_e((int)id) : null;
            this.doorMeta = tag.func_74762_e("doorMeta");
            this.doorSide = tag.func_74762_e("doorSide");
        }
        if (tag.func_74767_n("isSpawner")) {
            ZSSMain.logger.warn(String.format("Detected old fairy spawner save format at %d/%d/%d - if you still see this message after saving and reloading near this location, please contact the mod author", this.field_145851_c, this.field_145848_d, this.field_145849_e));
            NBTTagCompound spawnerData = new NBTTagCompound();
            spawnerData.func_74768_a("maxFairies", tag.func_74762_e("maxFairies"));
            spawnerData.func_74768_a("spawned", tag.func_74762_e("spawned"));
            spawnerData.func_74768_a("nextResetDate", tag.func_74762_e("nextResetDate"));
            spawnerData.func_74768_a("itemUpdate", tag.func_74762_e("itemUpdate"));
            spawnerData.func_74768_a("rupees", tag.func_74762_e("rupees"));
            spawnerData.func_74778_a("playerName", tag.func_74779_i("playerName"));
            tag.func_74782_a("FairySpawner", (NBTBase)spawnerData);
        }
        if (tag.func_74764_b("FairySpawner")) {
            this.fairySpawner = new FairySpawner(this);
            this.fairySpawner.readFromNBT(tag);
        }
    }
}

