/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.item.ISacredFlame;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.tileentity.TileEntitySacredFlame;
import zeldaswordskills.client.render.block.RenderSacredFlame;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class BlockSacredFlame
extends BlockContainer {
    public static final int DIN = 1;
    public static final int FARORE = 2;
    public static final int NAYRU = 4;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockSacredFlame() {
        super(ZSSBlockMaterials.sacredFlame);
        this.func_149649_H();
        this.func_149722_s();
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149715_a(1.0f);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySacredFlame();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149703_v() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderSacredFlame.renderId;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ISacredFlame) {
            if (((ISacredFlame)stack.func_77973_b()).onActivatedSacredFlame(stack, world, player, meta & 0xFFFFFFF7, (meta & 8) == 0)) {
                this.extinguishFlame(world, x, y, z);
                return true;
            }
        } else if (!world.field_72995_K) {
            PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.random", new Object[0]);
        }
        return false;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = player.func_70694_bm();
        if (stack != null) {
            boolean isActive;
            boolean bl = isActive = (meta & 8) == 0;
            if (stack.func_77973_b() instanceof ISacredFlame) {
                if (((ISacredFlame)stack.func_77973_b()).onClickedSacredFlame(stack, world, player, meta & 0xFFFFFFF7, isActive)) {
                    this.extinguishFlame(world, x, y, z);
                }
            } else if (!world.field_72995_K) {
                if (stack.func_77973_b() == Items.field_151032_g && isActive) {
                    int n = stack.field_77994_a;
                    player.func_70062_b(0, new ItemStack(meta == 1 ? ZSSItems.arrowFire : (meta == 4 ? ZSSItems.arrowIce : ZSSItems.arrowLight), n));
                    world.func_72956_a((Entity)player, "zeldaswordskills:success_magic", 1.0f, 1.0f);
                    if (Config.getArrowsConsumeFlame() && world.field_73012_v.nextInt(80) < n) {
                        this.extinguishFlame(world, x, y, z);
                    }
                } else if (stack.func_77973_b() == ZSSItems.crystalSpirit && isActive) {
                    switch (meta) {
                        case 1: {
                            player.func_70062_b(0, new ItemStack(ZSSItems.crystalDin));
                            break;
                        }
                        case 2: {
                            player.func_70062_b(0, new ItemStack(ZSSItems.crystalFarore));
                            break;
                        }
                        case 4: {
                            player.func_70062_b(0, new ItemStack(ZSSItems.crystalNayru));
                        }
                    }
                    world.func_72956_a((Entity)player, "zeldaswordskills:flame_absorb", 1.0f, 1.0f);
                    this.extinguishFlame(world, x, y, z);
                } else if (isActive) {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.random", new Object[0]);
                } else {
                    PlayerUtils.sendTranslatedChat(player, "chat.zss.sacred_flame.inactive", new Object[0]);
                }
            }
        }
    }

    protected void extinguishFlame(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (Config.getSacredFlameRefreshRate() > 0 && te instanceof TileEntitySacredFlame) {
            int meta = world.func_72805_g(x, y, z);
            world.func_72921_c(x, y, z, meta | 8, 3);
            ((TileEntitySacredFlame)te).extinguish();
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 4));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconArray = new IIcon[8];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a("zeldaswordskills:fire" + i / 2 + "_layer_" + i % 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFireIcon(int layer, int meta) {
        return this.iconArray[((meta & 8) == 8 ? 6 : (meta == 1 ? 0 : meta)) + layer];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconArray[(meta &= 0xFFFFFFF7) == 1 ? 0 : meta];
    }
}

