/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IQuakeBlock;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class BlockQuakeStone
extends Block
implements IDungeonBlock,
IQuakeBlock,
ISmashable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockQuakeStone() {
        super(Material.field_151576_e);
        this.func_149649_H();
        this.func_149722_s();
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    @Override
    public void handleQuakeEffect(World world, int x, int y, int z, EntityPlayer player) {
        world.func_147480_a(x, y, z, true);
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return Config.allowMegaSmashQuakeStone() && PlayerUtils.hasItem(player, ZSSItems.gauntletsGolden) ? BlockWeight.VERY_HEAVY : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return Event.Result.DEFAULT;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)EnumType.byMetadata(meta).getDroppedBlock());
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemPickaxe) {
            if (!world.field_72995_K) {
                world.func_72956_a((Entity)player, "random.break", 0.25f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
            } else if (Config.showSecretMessage) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.block.secret", new Object[0]);
            }
        }
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return world.func_72805_g(x, y, z) == expected;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumType type : EnumType.values()) {
            list.add(new ItemStack(item, 1, type.getMetadata()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconArray[meta % EnumType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String s = "zeldaswordskills:quake_stone_";
        this.iconArray = new IIcon[EnumType.values().length];
        for (EnumType type : EnumType.values()) {
            this.iconArray[type.ordinal()] = register.func_94245_a(s + type.getName());
        }
    }

    public static enum EnumType {
        COBBLE(0, "cobble"),
        MOSSY(1, "mossy");

        private final int meta;
        private final String unlocalizedName;

        private EnumType(int meta, String unlocalizedName) {
            this.meta = meta;
            this.unlocalizedName = unlocalizedName;
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public String getName() {
            return this.unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public Block getDroppedBlock() {
            switch (this) {
                case MOSSY: {
                    return Blocks.field_150341_Y;
                }
            }
            return Blocks.field_150347_e;
        }

        public static EnumType byMetadata(int meta) {
            return EnumType.values()[Math.max(0, meta) % EnumType.values().length];
        }
    }
}

