/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSAchievements;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.item.ISmashBlock;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.entity.projectile.EntityWhip;

public class BlockPeg
extends Block
implements IDungeonBlock,
IHookable,
ISmashable,
IWhipBlock {
    private final BlockWeight weight;
    private static final int MAX_STATE = 3;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBottom;

    public BlockPeg(Material material, BlockWeight weight) {
        super(material);
        this.weight = weight;
        this.func_149649_H();
        this.func_149675_a(true);
        this.func_149722_s();
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
    }

    private String getHitSound() {
        return this.field_149764_J == ZSSBlockMaterials.pegRustyMaterial ? "zeldaswordskills:hit_rusty" : "zeldaswordskills:hit_peg";
    }

    @Override
    public Event.Result canGrabBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        if (side == 0 || side == 1 || world.func_72805_g(x, y, z) > 0) {
            return Event.Result.DENY;
        }
        return type.getBaseType() == IHookable.HookshotType.MULTI_SHOT ? Event.Result.ALLOW : Event.Result.DEFAULT;
    }

    @Override
    public Event.Result canDestroyBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DENY;
    }

    @Override
    public Material getHookableMaterial(IHookable.HookshotType type, World world, int x, int y, int z) {
        return this.field_149764_J == ZSSBlockMaterials.pegWoodMaterial ? Material.field_151575_d : Material.field_151573_f;
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return this.weight;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        world.func_72908_a((double)x, (double)y, (double)z, this.getHitSound(), world.field_73012_v.nextFloat() * 0.4f + 0.5f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
        if (side == 1) {
            int meta = world.func_72805_g(x, y, z);
            int impact = 1 + ((ISmashBlock)stack.func_77973_b()).getSmashStrength(player, stack, this, meta).ordinal() - this.weight.ordinal();
            if (impact > 0) {
                boolean flag;
                boolean bl = flag = meta < 3;
                if ((meta += impact) >= 3) {
                    if (this == ZSSBlocks.pegRusty) {
                        player.func_71029_a((StatBase)ZSSAchievements.hardHitter);
                    } else if (this == ZSSBlocks.pegWooden) {
                        player.func_71029_a((StatBase)ZSSAchievements.hammerTime);
                    }
                }
                if (meta > 3 && impact > 1) {
                    flag = true;
                    world.func_147480_a(x, y, z, false);
                } else {
                    world.func_72921_c(x, y, z, Math.min(meta, 3), 3);
                }
                return flag ? Event.Result.ALLOW : Event.Result.DENY;
            }
        }
        return Event.Result.DENY;
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return false;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return side != 0 && side != 1 && world.func_72805_g(x, y, z) < 3;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        if (world.func_72805_g(x, y, z) >= 3) {
            whip.func_70106_y();
            return Event.Result.DENY;
        }
        return Event.Result.DEFAULT;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 0) {
            world.func_72921_c(x, y, z, meta - 1, 3);
        }
    }

    public int func_149738_a(World world) {
        return 60;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F + 0.5), (double)((double)z + this.field_149757_G));
        }
        if (meta >= 3) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = Math.min(world.func_72805_g(x, y, z), 3);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.8f - (float)meta * 0.2f, 0.75f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.8f, 0.75f);
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? this.iconBottom : (side == 1 ? this.iconTop : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("zeldaswordskills:" + this.func_149739_a().substring(9) + "_side");
        this.iconTop = register.func_94245_a("zeldaswordskills:" + this.func_149739_a().substring(9) + "_top");
        this.iconBottom = register.func_94245_a("zeldaswordskills:" + this.func_149739_a().substring(9) + "_bottom");
    }
}

