/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IHookable;
import zeldaswordskills.api.block.ILiftable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.api.block.ISongBlock;
import zeldaswordskills.block.ZSSBlockMaterials;
import zeldaswordskills.block.tileentity.TileEntityGossipStone;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.songs.AbstractZeldaSong;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.StringUtils;
import zeldaswordskills.util.TimedChatDialogue;

public class BlockGossipStone
extends Block
implements IHookable,
ILiftable,
ISmashable,
ISongBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;

    public BlockGossipStone() {
        super(ZSSBlockMaterials.adventureStone);
        this.func_149711_c(10.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityGossipStone();
    }

    @Override
    public Event.Result canDestroyBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DENY;
    }

    @Override
    public Event.Result canGrabBlock(IHookable.HookshotType type, World world, int x, int y, int z, int side) {
        return Event.Result.DEFAULT;
    }

    @Override
    public Material getHookableMaterial(IHookable.HookshotType type, World world, int x, int y, int z) {
        return Material.field_151576_e;
    }

    @Override
    public BlockWeight getLiftWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta == 0 ? BlockWeight.MEDIUM : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public void onLifted(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityGossipStone) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            String msg = ((TileEntityGossipStone)te).getMessage();
            stack.func_77978_p().func_74778_a("TegsMessage", msg);
        }
    }

    @Override
    public void onHeldBlockPlaced(World world, ItemStack stack, int x, int y, int z, int meta) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("TegsMessage")) {
            ZSSMain.logger.warn("Held GossipBlock stack had an invalid NBT tag: unable to set message.");
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityGossipStone) {
            String msg = stack.func_77978_p().func_74779_i("TegsMessage");
            ((TileEntityGossipStone)te).setMessage(msg);
        }
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta == 0 ? BlockWeight.VERY_HEAVY : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) == 0 ? Event.Result.DEFAULT : Event.Result.DENY;
    }

    @Override
    public boolean onSongPlayed(World world, int x, int y, int z, EntityPlayer player, AbstractZeldaSong song, int power, int affected) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof TileEntityGossipStone && ((TileEntityGossipStone)te).onSongPlayed(player, song, power, affected);
    }

    public int func_149692_a(int meta) {
        return 0;
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return world.func_72805_g(x, y, z) == 0;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.func_72805_g(x, y, z) == 0 ? this.func_149638_a(entity) : BlockWeight.getMaxResistance();
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 0 ? this.field_149782_v : -1.0f;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && te instanceof TileEntityGossipStone) {
            ItemStack helm = player.func_71124_b(4);
            if (helm != null && helm.func_77973_b() == ZSSItems.maskTruth) {
                String msg = ((TileEntityGossipStone)te).getMessage();
                if (msg.startsWith("chat.")) {
                    PlayerUtils.sendTranslatedChat(player, msg, new Object[0]);
                } else {
                    String[] messages = StringUtils.wrapString(msg, 64, 5);
                    new TimedChatDialogue(player, messages);
                }
            } else {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.block.gossip_stone.silent", new Object[0]);
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        if (PlayerUtils.isSword(player.func_70694_bm())) {
            long time = world.func_72820_D();
            long days = world.func_82737_E() / 24000L;
            long current = (time + 6000L) % 24000L;
            int h = (int)(current / 1000L);
            int m = (int)(current % 1000L * 3L / 50L);
            PlayerUtils.sendTranslatedChat(player, "chat.zss.block.gossip_stone.time", String.format("%02d", h), String.format("%02d", m), days);
        } else if (world.func_72805_g(x, y, z) > 0 && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemPickaxe) {
            world.func_72956_a((Entity)player, "random.break", 0.25f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return side < 2 ? this.topIcon : this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String s = "zeldaswordskills:" + this.func_149739_a().substring(9);
        this.field_149761_L = register.func_94245_a(s);
        this.topIcon = register.func_94245_a(s + "_top");
    }
}

