/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.ISmashable;
import zeldaswordskills.block.BlockSecretStone;
import zeldaswordskills.block.IDungeonBlock;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonBlock;
import zeldaswordskills.client.render.block.RenderTileDungeonBlock;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ItemDungeonBlock;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.PlayerUtils;

public class BlockDungeonStone
extends BlockContainer
implements IDungeonBlock,
IExplodable,
ISmashable {
    public BlockDungeonStone(Material material) {
        super(material);
        this.func_149722_s();
        this.func_149752_b(6.0f);
        this.func_149672_a(field_149769_e);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDungeonBlock();
    }

    public int func_149645_b() {
        return RenderTileDungeonBlock.renderId;
    }

    @Override
    public BlockWeight getSmashWeight(EntityPlayer player, ItemStack stack, int meta, int side) {
        return meta < 8 ? BlockWeight.VERY_HEAVY : BlockWeight.IMPOSSIBLE;
    }

    @Override
    public Event.Result onSmashed(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, int side) {
        return Event.Result.DEFAULT;
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return world.func_72805_g(x, y, z) < 8;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Block block = null;
        int blockMeta = 0;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDungeonBlock) {
            block = ((TileEntityDungeonBlock)te).getRenderBlock();
            blockMeta = ((TileEntityDungeonBlock)te).getRenderMetadata();
        }
        if (block != null) {
            drops.add(new ItemStack(block, 1, blockMeta));
        }
        return drops;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemPickaxe) {
            if (Config.showSecretMessage) {
                PlayerUtils.sendTranslatedChat(player, "chat.zss.block.secret", new Object[0]);
            }
            world.func_72956_a((Entity)player, "random.break", 0.25f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.5f));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityDungeonBlock stone;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDungeonBlock && (stone = (TileEntityDungeonBlock)te).getRenderBlock() == null) {
            stone.setRenderBlock(BlockSecretStone.getBlockFromMeta(world.func_72805_g(x, y, z)), 0);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityDungeonBlock && stack != null && stack.func_77973_b() instanceof ItemDungeonBlock) {
            Block block = ((ItemDungeonBlock)stack.func_77973_b()).getBlockFromStack(stack);
            if (block == ZSSBlocks.dungeonStone) {
                block = stack.func_77960_j() == 0 ? Blocks.field_150348_b : Blocks.field_150343_Z;
            } else if (block == ZSSBlocks.dungeonCore) {
                block = stack.func_77960_j() == 0 ? Blocks.field_150341_Y : Blocks.field_150417_aV;
            }
            int meta = ((ItemDungeonBlock)stack.func_77973_b()).getMetaFromStack(stack);
            ((TileEntityDungeonBlock)te).setRenderBlock(block, meta);
        }
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return world.func_72805_g(x, y, z) < 8 ? this.func_149638_a(entity) : BlockWeight.getMaxResistance();
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (world.func_72805_g(x, y, z) < 8) {
            super.onBlockExploded(world, x, y, z, explosion);
        }
    }

    @Override
    public boolean isSameVariant(World world, int x, int y, int z, int expected) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("stone");
    }
}

