/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import zeldaswordskills.api.block.BlockWeight;
import zeldaswordskills.block.tileentity.TileEntityChestLocked;
import zeldaswordskills.client.render.block.RenderChestLocked;
import zeldaswordskills.creativetab.ZSSCreativeTabs;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.WorldUtils;

public class BlockChestLocked
extends BlockContainer {
    private static boolean keepInventory;

    public BlockChestLocked() {
        super(Material.field_151575_d);
        this.func_149722_s();
        this.func_149752_b(BlockWeight.IMPOSSIBLE.weight);
        this.func_149672_a(field_149766_f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.func_149647_a(ZSSCreativeTabs.tabBlocks);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149656_h() {
        return 2;
    }

    public int func_149645_b() {
        return RenderChestLocked.renderId;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityChestLocked();
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!keepInventory) {
            WorldUtils.dropContainerBlockInventory(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IInventory)) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d && !player.func_70093_af()) {
            player.func_71007_a((IInventory)te);
            return true;
        }
        if (this.canUnlock(player)) {
            this.convertToChest((IInventory)te, world, x, y, z);
            WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_chest", 0.4f, 0.5f);
            return true;
        }
        WorldUtils.playSoundAtEntity((Entity)player, "zeldaswordskills:lock_rattle", 0.4f, 0.5f);
        return false;
    }

    protected void convertToChest(IInventory inv, World world, int x, int y, int z) {
        TileEntity chest;
        boolean isChest;
        int meta = world.func_72805_g(x, y, z);
        keepInventory = true;
        world.func_147449_b(x, y, z, (Block)Blocks.field_150486_ae);
        keepInventory = false;
        boolean bl = isChest = world.func_147439_a(x + 1, y, z) == Blocks.field_150486_ae;
        if (!isChest) {
            boolean bl2 = isChest = world.func_147439_a(x - 1, y, z) == Blocks.field_150486_ae;
        }
        if (!isChest) {
            boolean bl3 = isChest = world.func_147439_a(x, y, z + 1) == Blocks.field_150486_ae;
        }
        if (!isChest) {
            boolean bl4 = isChest = world.func_147439_a(x, y, z - 1) == Blocks.field_150486_ae;
        }
        if (!isChest) {
            world.func_72921_c(x, y, z, meta, 3);
        }
        if ((chest = world.func_147438_o(x, y, z)) instanceof TileEntityChest) {
            IInventory inv2 = (IInventory)chest;
            for (int i = 0; i < inv.func_70302_i_() && i < inv2.func_70302_i_(); ++i) {
                inv2.func_70299_a(i, inv.func_70301_a(i));
            }
        }
    }

    private boolean canUnlock(EntityPlayer player) {
        ItemStack key = player.func_70694_bm();
        if (key != null) {
            if (key.func_77973_b() == ZSSItems.keySmall) {
                return PlayerUtils.consumeHeldItem(player, ZSSItems.keySmall, 1);
            }
            if (key.func_77973_b() == ZSSItems.keySkeleton) {
                key.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        Block l = world.func_147439_a(x, y, z - 1);
        Block i1 = world.func_147439_a(x, y, z + 1);
        Block j1 = world.func_147439_a(x - 1, y, z);
        Block k1 = world.func_147439_a(x + 1, y, z);
        int meta = 3;
        if (l.func_149730_j() && !i1.func_149730_j()) {
            meta = 3;
        }
        if (i1.func_149730_j() && !l.func_149730_j()) {
            meta = 2;
        }
        if (j1.func_149730_j() && !k1.func_149730_j()) {
            meta = 5;
        }
        if (k1.func_149730_j() && !j1.func_149730_j()) {
            meta = 4;
        }
        world.func_72921_c(x, y, z, meta, 3);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int face = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        byte meta = (byte)(face == 0 ? 2 : (face == 1 ? 5 : (face == 2 ? 3 : 4)));
        world.func_72921_c(x, y, z, (int)meta, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("planks_oak");
    }
}

