/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.block;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import zeldaswordskills.api.block.IBoomerangBlock;
import zeldaswordskills.api.block.IExplodable;
import zeldaswordskills.api.block.IQuakeBlock;
import zeldaswordskills.api.block.IWhipBlock;
import zeldaswordskills.api.entity.BombType;
import zeldaswordskills.api.entity.CustomExplosion;
import zeldaswordskills.api.entity.IEntityBomb;
import zeldaswordskills.client.render.block.RenderSpecialCrop;
import zeldaswordskills.entity.projectile.EntityBomb;
import zeldaswordskills.entity.projectile.EntityBoomerang;
import zeldaswordskills.entity.projectile.EntityWhip;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.util.PlayerUtils;
import zeldaswordskills.util.TargetUtils;

public class BlockBombFlower
extends BlockCrops
implements IBoomerangBlock,
IExplodable,
IQuakeBlock,
IWhipBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public BlockBombFlower() {
        this.func_149647_a(null);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Cave;
    }

    protected Item func_149866_i() {
        return ZSSItems.bombFlowerSeed;
    }

    protected Item func_149865_P() {
        return ZSSItems.bombFlowerSeed;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    protected boolean func_149854_a(Block block) {
        return block.func_149688_o() == Material.field_151576_e;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        return this.func_149854_a(soil) && this.hasLava(world, x, y - 1, z);
    }

    private boolean hasLava(World world, int x, int y, int z) {
        boolean hasLava = world.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151587_i || world.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151587_i || world.func_147439_a(x, y, z - 1).func_149688_o() == Material.field_151587_i || world.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151587_i;
        return hasLava;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null || world.func_72805_g(x, y, z) != 7) {
            return false;
        }
        if (!world.field_72995_K) {
            player.func_70062_b(0, new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FLOWER.ordinal()));
            world.func_72921_c(x, y, z, 0, 2);
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.func_72805_g(x, y, z) == 7) {
            if (PlayerUtils.isHoldingWeapon(player)) {
                this.createExplosion(world, x, y, z, true);
            } else {
                this.disperseSeeds(world, x, y, z, true);
            }
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 7) {
            world.func_72921_c(x, y, z, 15, 2);
            world.func_147464_a(x, y, z, (Block)this, 5);
        } else if (meta < 7) {
            Entity exploder;
            Entity entity = exploder = explosion instanceof CustomExplosion ? ((CustomExplosion)explosion).field_77283_e : null;
            if (!(exploder instanceof IEntityBomb) || ((IEntityBomb)exploder).getType() != BombType.BOMB_FLOWER) {
                super.onBlockExploded(world, x, y, z, explosion);
            }
        }
    }

    @Override
    public boolean onBoomerangCollided(World world, int x, int y, int z, EntityBoomerang boomerang) {
        if (!world.field_72995_K && world.func_72805_g(x, y, z) == 7) {
            boolean captured = false;
            world.func_72921_c(x, y, z, 0, 2);
            EntityItem bomb = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FLOWER.ordinal()));
            world.func_72838_d((Entity)bomb);
            if (boomerang.captureItem(bomb)) {
                captured = true;
            } else {
                bomb.func_70106_y();
            }
            if (!captured) {
                this.createExplosion(world, x, y, z, true);
            }
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (world.func_72805_g(x, y, z) == 7 && entity instanceof IProjectile) {
            this.createExplosion(world, x, y, z, true);
        }
    }

    @Override
    public void handleQuakeEffect(World world, int x, int y, int z, EntityPlayer player) {
        if (world.func_72805_g(x, y, z) == 7) {
            this.createExplosion(world, x, y, z, true);
        }
    }

    @Override
    public boolean canBreakBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return this.getGrowthStage(world.func_72805_g(x, y, z)) < 2;
    }

    @Override
    public boolean canGrabBlock(IWhipBlock.WhipType whip, EntityLivingBase thrower, World world, int x, int y, int z, int side) {
        return side != 0 && world.func_72805_g(x, y, z) == 7;
    }

    @Override
    public Event.Result shouldSwing(EntityWhip whip, World world, int x, int y, int z, int ticksInGround) {
        if (ticksInGround > 30 && world.func_72805_g(x, y, z) == 7) {
            EntityLivingBase thrower = whip.func_85052_h();
            EntityItem bomb = new EntityItem(world, whip.field_70165_t, whip.field_70163_u + 1.0, whip.field_70161_v, new ItemStack(ZSSItems.bomb, 1, BombType.BOMB_FLOWER.ordinal()));
            double dx = thrower.field_70165_t - bomb.field_70165_t;
            double dy = thrower.field_70163_u + (double)thrower.func_70047_e() - bomb.field_70163_u;
            double dz = thrower.field_70161_v - bomb.field_70161_v;
            TargetUtils.setEntityHeading((Entity)bomb, dx, dy * 1.5, dz, 1.0f, 0.0f, true);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)bomb);
            }
            world.func_147468_f(x, y, z);
            whip.func_70106_y();
        }
        return Event.Result.DENY;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.func_149855_e(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (meta > 7) {
            this.createExplosion(world, x, y, z, true);
        } else if (meta < 7 && rand.nextInt(6) == 0) {
            world.func_72921_c(x, y, z, meta + 1, 2);
        } else if (meta == 7 && rand.nextInt(16) == 0) {
            this.disperseSeeds(world, x, y, z, false);
        }
    }

    private void createExplosion(World world, int x, int y, int z, boolean toAir) {
        if (!world.field_72995_K) {
            if (toAir) {
                world.func_147468_f(x, y, z);
            }
            CustomExplosion.createExplosion(world, x, y, z, 3.0f, BombType.BOMB_FLOWER);
        }
    }

    private void disperseSeeds(World world, int x, int y, int z, boolean isGriefing) {
        if (!world.field_72995_K) {
            world.func_72921_c(x, y, z, 0, 2);
            EntityBomb bomb = new EntityBomb(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).setType(BombType.BOMB_FLOWER).setFuseTime(64);
            if (!isGriefing) {
                bomb.setNoGrief();
            }
            world.func_72838_d((Entity)bomb);
        }
    }

    public int func_149645_b() {
        return RenderSpecialCrop.renderId;
    }

    private int getGrowthStage(int meta) {
        return (meta &= 7) == 6 ? 2 : meta >> 1;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int stage = this.getGrowthStage(world.func_72805_g(x, y, z));
        if (stage == 0) {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int stage = this.getGrowthStage(world.func_72805_g(x, y, z));
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.2f + (float)stage * 0.15f, 0.9f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iconArray[this.getGrowthStage(meta)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String s = "zeldaswordskills:" + this.func_149739_a().substring(9) + "_stage_";
        this.iconArray = new IIcon[4];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = register.func_94245_a(s + i);
        }
    }
}

