/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import zeldaswordskills.api.entity.IEntityCustomTarget;
import zeldaswordskills.api.entity.ai.EntityAIDynamic;
import zeldaswordskills.api.entity.ai.EntityAction;

public class EntityAIDynamicAction
extends EntityAIDynamic {
    protected Entity target;
    protected final float rangeSq;
    protected final boolean require_ground;
    protected final boolean require_sight;

    public <T extends EntityCreature> EntityAIDynamicAction(T entity, EntityAction action, float range, boolean require_ground) {
        this(entity, action, range, require_ground, true);
    }

    public <T extends EntityCreature> EntityAIDynamicAction(T entity, EntityAction action, float range, boolean require_ground, boolean require_sight) {
        super(entity, action, 0, 3);
        this.rangeSq = range * range;
        this.require_ground = require_ground;
        this.require_sight = require_sight;
    }

    protected Entity getTarget() {
        return this.entity.func_70638_az();
    }

    @Override
    public boolean func_75250_a() {
        this.target = this.getTarget();
        if (this.actor.getActionTime(this.action.id) > 0) {
            return true;
        }
        return this.canPerformAction() && super.func_75250_a();
    }

    @Override
    protected void updateActionState(int frame, int action_frame, float speed) {
        if (frame < action_frame && this.target != null) {
            this.entity.func_70671_ap().func_75651_a(this.target, 30.0f, 30.0f);
        }
    }

    @Override
    protected boolean canPerformAction() {
        if (this.target == null || !this.target.func_70089_S()) {
            return false;
        }
        if (this.require_ground && !this.entity.field_70122_E) {
            return false;
        }
        if (this.require_sight && !this.entity.func_70635_at().func_75522_a(this.target)) {
            return false;
        }
        return this.checkRange();
    }

    protected boolean checkRange() {
        return this.entity.func_70068_e(this.target) <= (double)this.rangeSq;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.target = null;
    }

    public static class EntityAIDynamicCustomTarget
    extends EntityAIDynamicAction {
        protected final IEntityCustomTarget targeting;

        public <T extends EntityCreature & IEntityCustomTarget> EntityAIDynamicCustomTarget(T entity, EntityAction action, float range, boolean require_ground) {
            this(entity, action, range, require_ground, true);
        }

        public <T extends EntityCreature & IEntityCustomTarget> EntityAIDynamicCustomTarget(T entity, EntityAction action, float range, boolean require_ground, boolean require_sight) {
            super(entity, action, range, require_ground, require_sight);
            this.targeting = entity;
        }

        @Override
        protected Entity getTarget() {
            return this.targeting.getCurrentTarget();
        }
    }
}

