/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.api.client.animation;

import net.minecraft.client.model.ModelRenderer;
import zeldaswordskills.api.client.animation.AnimationTimed;
import zeldaswordskills.api.client.animation.RotationAxis;

public class AnimationTargetPoint
extends AnimationTimed {
    protected final ModelRenderer part;
    protected final RotationAxis axis;
    protected final float targetPosition;

    public AnimationTargetPoint(ModelRenderer part, RotationAxis axis, float targetPosition, int startFrame, int endFrame) {
        this(part, axis, targetPosition, startFrame, endFrame, true);
    }

    public AnimationTargetPoint(ModelRenderer part, RotationAxis axis, float targetPosition, int startFrame, int endFrame, boolean relative) {
        super(startFrame, endFrame);
        this.part = part;
        this.axis = axis;
        this.targetPosition = relative ? this.getCurrentAmount() + targetPosition : targetPosition;
    }

    @Override
    public void apply(int frame, float partialTick, float speed, float multiplier, float offset, boolean invert) {
        multiplier = this.allowMultiplier ? multiplier : 1.0f;
        offset = this.allowOffset ? offset : 0.0f;
        speed = this.allowSpeed ? speed : 1.0f;
        float progress = this.getProgress(frame, partialTick, speed);
        this.apply(this.getOffsetAmount(progress, multiplier, offset, invert &= this.allowInvert));
    }

    protected void apply(float amount) {
        this.axis.addRotationPoint(this.part, amount);
    }

    protected float getOffsetAmount(float progress, float multiplier, float offset, boolean invert) {
        float target = invert ? -this.targetPosition : this.targetPosition;
        target = target + (invert ? -offset : offset) - this.getCurrentAmount();
        return multiplier * progress * target;
    }

    protected float getCurrentAmount() {
        return this.axis.getRotationPoint(this.part);
    }
}

