/**
    Copyright (C) <2015> <coolAlias>

    This file is part of coolAlias' Zelda Sword Skills Minecraft Mod; as such,
    you can redistribute it and/or modify it under the terms of the GNU
    General Public License as published by the Free Software Foundation,
    either version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package zeldaswordskills.api.item;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;

/**
 * 
 * Interface for items that require special handling when tossed from the
 * player's inventory
 *
 */
public interface IHandleToss {

	/**
	 * This method is called automatically when the item is tossed
	 * @param item the entity item that was thrown; setting this to dead will cancel the toss event
	 * @param player the player who threw the item
	 */
	void onItemTossed(EntityItem item, EntityPlayer player);

}
