/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.structure;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ChestGenHooks;
import zeldaswordskills.block.BlockDoorLocked;
import zeldaswordskills.block.BlockPeg;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.item.ItemInstrument;
import zeldaswordskills.item.ItemTreasure;
import zeldaswordskills.item.ZSSItems;
import zeldaswordskills.ref.Config;
import zeldaswordskills.util.BossType;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.util.WorldUtils;
import zeldaswordskills.world.gen.DungeonLootLists;
import zeldaswordskills.world.gen.structure.RoomBase;
import zeldaswordskills.world.gen.structure.ZSSMapGenBase;

public class RoomSecret
extends RoomBase {
    protected static final int MAX_HEIGHT = 5;
    private Block door = null;
    private int doorMeta;
    private int side;

    public RoomSecret(int chunkX, int chunkZ, int size, Block blockRequired) {
        super(chunkX, chunkZ, size, 5, blockRequired);
    }

    @Override
    public boolean generate(ZSSMapGenBase mapGen, World world, Random rand, int x, int y, int z) {
        int range;
        int worldHeight;
        if (y < this.bBox.maxY) {
            return false;
        }
        this.inNether = world.provider.isHellWorld;
        this.bBox.offset(x, y - this.bBox.maxY, z);
        int n = worldHeight = this.inNether ? 128 : world.getHeightValue(this.bBox.getCenterX(), this.bBox.getCenterZ());
        if (this.bBox.maxY > worldHeight) {
            this.bBox.offset(0, worldHeight - this.bBox.maxY - 1, 0);
        }
        if (!this.validateTopLayer(world) && !this.placeInOcean(world, true)) {
            return false;
        }
        if (this.inNether && this.submerged && !this.placeInNether(world)) {
            return false;
        }
        StructureGenUtils.adjustForAir(world, this, this.bBox);
        this.checkSpecialCases(world, rand);
        this.setMetadata(world, x, z);
        int n2 = this.inOcean ? Config.getMinOceanDistance() : (range = this.inNether ? Config.getNetherMinDistance() : Config.getMinLandDistance());
        if (!mapGen.areStructuresWithinRange(this, range) && this.isWellHidden(world) && this.canGenerate(world)) {
            this.doStandardRoomGen(world, rand);
            return true;
        }
        return false;
    }

    @Override
    protected void setMetadata(World world, int x, int z) {
        boolean inWater;
        BossType type = Config.areBossDungeonsRandom() ? null : BossType.getBossType(world, x, z);
        boolean bl = inWater = this.inOcean || StructureGenUtils.getNumBlocksOfMaterial(world, this.bBox, Material.water, 1) > 0;
        if (type != null) {
            switch (type) {
                case HELL: {
                    this.metadata = 2;
                    break;
                }
                case OCEAN: {
                    this.metadata = inWater ? 6 : 0;
                    break;
                }
                default: {
                    this.metadata = 0;
                    break;
                }
            }
        } else if (world.provider.isHellWorld) {
            this.metadata = 2;
        } else {
            int n = this.metadata = inWater ? 6 : 0;
        }
        if (this.door != null) {
            this.metadata |= 8;
        }
    }

    @Override
    protected void decorateDungeon(World world, Random rand) {
        if (this.door != null) {
            this.placeDoor(world, rand);
        }
        this.doChestGen(world, rand);
        this.placeDungeonCore(world);
        this.placeJars(world, rand);
    }

    @Override
    protected void placeDungeonCore(World world) {
        StructureGenUtils.setBlockAtPosition(world, this.bBox, this.bBox.getXSize() / 2, 0, this.bBox.getZSize() / 2, ZSSBlocks.dungeonCore, this.getMetadata() | 8);
        int x = StructureGenUtils.getXWithOffset(this.bBox, this.bBox.getXSize() / 2, this.bBox.getZSize() / 2);
        int y = StructureGenUtils.getYWithOffset(this.bBox, 0);
        int z = StructureGenUtils.getZWithOffset(this.bBox, this.bBox.getXSize() / 2, this.bBox.getZSize() / 2);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityDungeonCore) {
            ((TileEntityDungeonCore)te).setDungeonBoundingBox(this.bBox);
            if (this.door != null) {
                ((TileEntityDungeonCore)te).setDoor(this.door, this.doorMeta, this.side);
            }
            if (!this.inNether && this.submerged && !this.inLava && !this.inOcean && this.bBox.getXSize() > 4 && (this.inMountain || world.rand.nextFloat() < Config.getFairySpawnerChance())) {
                ((TileEntityDungeonCore)te).setSpawner();
            }
        }
    }

    private void checkSpecialCases(World world, Random rand) {
        boolean flag;
        BiomeGenBase biome = world.getBiomeGenForCoords(this.bBox.getCenterX(), this.bBox.getCenterZ());
        boolean bl = flag = !this.submerged && this.bBox.maxY > 64 && biome != null;
        if (this.inNether && !this.inLava) {
            if (rand.nextFloat() < 0.25f) {
                this.submerged = true;
                this.inLava = true;
            }
        } else if (flag && (biome.biomeName.toLowerCase().contains("hill") || biome.biomeName.toLowerCase().contains("mountain"))) {
            this.submerged = rand.nextFloat() < Config.getFairySpawnerChance();
            this.inMountain = true;
        }
        if (this.submerged && this.bBox.getXSize() > 3) {
            --this.bBox.minY;
        }
        if (this.bBox.getXSize() > 5 && rand.nextFloat() < Config.getBarredRoomChance()) {
            this.setDoor(rand);
            this.side = rand.nextInt(4);
        }
    }

    protected void setDoor(Random rand) {
        if (rand.nextInt(16) == 0) {
            if (this.submerged && rand.nextInt(3) == 0) {
                this.door = ZSSBlocks.doorLocked;
            } else {
                this.door = ZSSBlocks.timeBlock;
                this.doorMeta = rand.nextInt(2);
            }
        } else if (rand.nextInt(16) == 0) {
            this.door = ZSSBlocks.quakeStone;
            this.doorMeta = rand.nextInt(2);
        } else if (!this.submerged) {
            this.door = rand.nextInt(3) == 0 ? (rand.nextInt(3) == 0 ? ZSSBlocks.barrierHeavy : ZSSBlocks.pegRusty) : (rand.nextInt(3) == 0 ? ZSSBlocks.doorLocked : (rand.nextInt(3) == 0 ? ZSSBlocks.barrierLight : ZSSBlocks.pegWooden));
        }
    }

    private void doChestGen(World world, Random rand) {
        int rX = this.bBox.getXSize() - 2;
        int rY = this.inLava && this.bBox.getYSize() > 3 ? 2 : 1;
        int rZ = this.bBox.getZSize() - 2;
        if (this.door instanceof BlockPeg) {
            switch (this.side) {
                case 0: {
                    rX = 1;
                    break;
                }
                case 2: {
                    rZ = 1;
                    rX = 1;
                    break;
                }
                case 3: {
                    rZ = 1;
                    break;
                }
                case 1: {
                    rZ = 1;
                    rX = 1;
                }
            }
            this.generateChestContents(world, rand, rX, rY, rZ, true);
        } else {
            this.generateChestContents(world, rand, rand.nextInt(rX) + 1, rY, rand.nextInt(rZ) + 1, true);
            if (this.bBox.getXSize() > 5 && rand.nextFloat() < Config.getDoubleChestChance()) {
                this.generateChestContents(world, rand, rand.nextInt(rX) + 1, rY, rand.nextInt(rZ) + 1, false);
            }
        }
    }

    private boolean generateChestContents(World world, Random rand, int x, int y, int z, boolean first) {
        int k1;
        int j1;
        int i1 = StructureGenUtils.getXWithOffset(this.bBox, x, z);
        if (this.bBox.isVecInside(i1, j1 = StructureGenUtils.getYWithOffset(this.bBox, y), k1 = StructureGenUtils.getZWithOffset(this.bBox, x, z)) && !StructureGenUtils.isBlockChest(world, i1, j1, k1)) {
            Block chestBlock;
            Object object = chestBlock = rand.nextFloat() < Config.getLockedChestChance() ? ZSSBlocks.chestLocked : Blocks.chest;
            if (this.door != ZSSBlocks.timeBlock && !first && rand.nextFloat() < Config.getLockedChestChance()) {
                chestBlock = ZSSBlocks.chestInvisible;
            }
            world.setBlock(i1, j1, k1, chestBlock, 0, 2);
            TileEntity te = world.getTileEntity(i1, j1, k1);
            if (te instanceof IInventory) {
                IInventory chest = (IInventory)te;
                DungeonLootLists.generateChestContents(world, rand, chest, this, chestBlock != Blocks.chest);
                if ((first || chestBlock == ZSSBlocks.chestInvisible) && rand.nextFloat() < Config.getHeartPieceChance()) {
                    WorldUtils.addItemToInventoryAtRandom(rand, new ItemStack(ZSSItems.heartPiece), chest, 3);
                }
                if (this.door != null) {
                    ItemStack loot = ChestGenHooks.getInfo((String)DungeonLootLists.BOSS_LOOT).getOneItem(rand);
                    if (rand.nextFloat() < 0.0625f * (1.0f / Math.max(Config.getBarredRoomChance(), 0.1f))) {
                        if (this.door == ZSSBlocks.pegWooden) {
                            loot = new ItemStack(ZSSItems.gauntletsSilver);
                        } else if (this.door == ZSSBlocks.barrierLight) {
                            loot = new ItemStack(ZSSItems.hammerSkull);
                        } else if (this.door == ZSSBlocks.pegRusty) {
                            loot = new ItemStack(ZSSItems.gauntletsGolden);
                        } else if (this.door == ZSSBlocks.barrierHeavy) {
                            loot = new ItemStack(ZSSItems.hammerMegaton);
                        } else if (this.door == ZSSBlocks.timeBlock) {
                            loot = new ItemStack(ZSSItems.treasure, 1, ItemTreasure.Treasures.ZELDAS_LETTER.ordinal());
                        } else if (this.door == ZSSBlocks.quakeStone) {
                            loot = (rand.nextInt() & 1) > 0 ? new ItemStack(ZSSItems.instrument, 1, ItemInstrument.Instrument.OCARINA_TIME.ordinal()) : new ItemStack(ZSSItems.magicContainer);
                        }
                    }
                    if (loot != null) {
                        WorldUtils.addItemToInventoryAtRandom(rand, loot, chest, 3);
                    }
                }
            }
            if (world.getBlock(i1, j1 - 1, k1).getMaterial() == Material.lava && this.bBox.getYSize() > 3) {
                world.setBlock(i1, j1 - 1, k1, ZSSBlocks.secretStone, this.getMetadata(), 2);
            }
            return true;
        }
        return false;
    }

    private void placeDoor(World world, Random rand) {
        int x = this.bBox.getCenterX();
        int y = this.bBox.minY + (this.submerged ? 2 : 1);
        int z = this.bBox.getCenterZ();
        switch (this.side % 4) {
            case 0: {
                z = this.bBox.maxZ;
                break;
            }
            case 2: {
                z = this.bBox.minZ;
                break;
            }
            case 3: {
                x = this.bBox.maxX;
                break;
            }
            case 1: {
                x = this.bBox.minX;
            }
        }
        world.setBlock(x, y, z, this.door, this.doorMeta, 2);
        this.doorMeta = this.door instanceof BlockDoorLocked ? this.doorMeta | 8 : this.doorMeta;
        world.setBlock(x, y + 1, z, this.door instanceof BlockPeg ? Blocks.air : this.door, this.doorMeta, 2);
    }

    private void placeJars(World world, Random rand) {
        int size = this.bBox.getXSize();
        if (size > 4) {
            int n = rand.nextInt(size - 3);
            for (int i = 0; i < n; ++i) {
                int z;
                int y;
                int x = this.bBox.minX + rand.nextInt(size);
                Material m = world.getBlock(x, y = this.bBox.minY + 1, z = this.bBox.minZ + rand.nextInt(this.bBox.getZSize())).getMaterial();
                if (m != Material.air && !m.isLiquid()) continue;
                world.setBlock(x, y, z, ZSSBlocks.ceramicJar);
            }
        }
    }
}

