/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.feature;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import zeldaswordskills.block.ZSSBlocks;
import zeldaswordskills.block.tileentity.TileEntityGossipStone;
import zeldaswordskills.ref.Config;

public class WorldGenGossipStones {
    public static final WorldGenGossipStones INSTANCE = new WorldGenGossipStones();

    private WorldGenGossipStones() {
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP) && world.getBlock(x, y, z).getMaterial().isReplaceable() && world.canBlockSeeTheSky(x, y, z)) {
            world.setBlock(x, y, z, ZSSBlocks.gossipStone, 0, 2);
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof TileEntityGossipStone) {
                ((TileEntityGossipStone)te).setMessage("chat.zss.block.gossip_stone.hint." + rand.nextInt(12));
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onDecorate(PopulateChunkEvent.Post event) {
        if (!event.world.provider.isSurfaceWorld()) {
            return;
        }
        if (!Config.isGenEnabledAt(event.chunkX, event.chunkZ)) {
            return;
        }
        if (event.rand.nextFloat() < Config.getGossipStoneRate()) {
            int i = (event.chunkX << 4) + event.rand.nextInt(16);
            int k = (event.chunkZ << 4) + event.rand.nextInt(16);
            int j = event.world.getHeightValue(i, k);
            this.generate(event.world, event.rand, i, j, k);
        }
    }
}

