/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import zeldaswordskills.block.ZSSBlocks;

public class WorldGenBombFlowers
extends WorldGenerator {
    public WorldGenBombFlowers() {
        super(false);
    }

    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        int i = (chunkX << 4) + 8;
        int k = (chunkZ << 4) + 8;
        for (int n = 0; n < 6; ++n) {
            int j = world.getHeightValue(i, k);
            this.generateAt(world, rand, i, j, k);
            j = rand.nextInt(48) + rand.nextInt(48);
            this.generateAt(world, rand, i, j, k);
        }
    }

    private void generateAt(World world, Random rand, int x, int y, int z) {
        int n = 6;
        for (int l = 0; l < 64 && n > 0; ++l) {
            int k;
            int j;
            int i = x + rand.nextInt(8) - rand.nextInt(8);
            if (!this.generate(world, rand, i, j = y + rand.nextInt(4) - rand.nextInt(4), k = z + rand.nextInt(8) - rand.nextInt(8))) continue;
            --n;
        }
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        if (world.isAirBlock(x, y, z) && world.getBlock(x, y - 1, z) != Blocks.cobblestone && ZSSBlocks.bombFlower.canPlaceBlockAt(world, x, y, z)) {
            world.setBlock(x, y, z, ZSSBlocks.bombFlower, rand.nextInt(8), 2);
            return true;
        }
        return false;
    }
}

