/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.gen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hunternif.mc.atlas.api.AtlasAPI;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import zeldaswordskills.ZSSMain;
import zeldaswordskills.util.BossType;

public class AntiqueAtlasHelper {
    public static void placeCustomTile(World world, String tileName, int x, int y, int z) {
        AntiqueAtlasHelper.placeCustomTile(world, tileName, x >> 4, z >> 4);
    }

    public static void placeCustomTile(World world, String tileName, int chunkX, int chunkZ) {
        if (ZSSMain.isAtlasEnabled && !world.isRemote) {
            try {
                AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
            }
            catch (Exception e) {
                ZSSMain.logger.error("Unable to add Atlas data: " + e.getLocalizedMessage());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerTextures() {
        if (ZSSMain.isAtlasEnabled) {
            try {
                for (BossType type : BossType.values()) {
                    String name = "zss_dungeon" + type.ordinal();
                    AtlasAPI.getTileAPI().setCustomTileTexture(name, new ResourceLocation[]{new ResourceLocation("zeldaswordskills", "textures/atlas/" + name + ".png")});
                    AtlasAPI.getTileAPI().setCustomTileTexture(name + "_fin", new ResourceLocation[]{new ResourceLocation("zeldaswordskills", "textures/atlas/" + name + "_fin.png")});
                }
            }
            catch (Exception e) {
                ZSSMain.logger.error(e.getLocalizedMessage());
            }
        }
    }
}

