/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.crisis.BossBattle;

public class OceanBattle
extends BossBattle {
    public OceanBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        this.eventTimer = 6000 - 600 * this.difficulty;
        this.scheduleUpdateTick(-(1200 - this.eventTimer));
    }

    @Override
    protected void endCrisis(World world) {
        super.endCrisis(world);
        StructureGenUtils.replaceMaterialWith(world, this.box.minX + 1, this.box.maxX, this.box.minY + 1, this.box.maxY, this.box.minZ + 1, this.box.maxZ, Material.sand, Blocks.water, 0);
    }

    @Override
    protected void onUpdateTick(World world) {
        world.playSoundEffect((double)this.core.xCoord + 0.5, (double)this.box.getCenterY(), (double)this.core.zCoord + 0.5, "zeldaswordskills:rock_fall", 1.0f, 1.0f);
        StructureGenUtils.fillWithoutReplace(world, this.box.minX + 1, this.box.maxX, this.box.maxY - 1, this.box.maxY, this.box.minZ + 1, this.box.maxZ, (Block)Blocks.sand, 0, 3);
        this.scheduleUpdateTick(100 - this.difficulty * 20 + world.rand.nextInt(60));
    }
}

