/*
 * Decompiled with CFR 0.152.
 */
package zeldaswordskills.world.crisis;

import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import zeldaswordskills.block.tileentity.TileEntityDungeonCore;
import zeldaswordskills.util.StructureGenUtils;
import zeldaswordskills.world.crisis.BossBattle;

public class ForestBattle
extends BossBattle {
    public ForestBattle(TileEntityDungeonCore core) {
        super(core);
    }

    @Override
    public void beginCrisis(World world) {
        super.beginCrisis(world);
        this.scheduleUpdateTick(300 + world.rand.nextInt(300));
        StructureGenUtils.fillWithoutReplace(world, this.box.minX + 1, this.box.minX + 2, this.box.minY + 1, this.box.minY + 4, this.box.minZ + 1, this.box.maxZ, Blocks.web, 0, 3);
        StructureGenUtils.fillWithoutReplace(world, this.box.maxX - 1, this.box.maxX, this.box.minY + 1, this.box.minY + 4, this.box.minZ + 1, this.box.maxZ, Blocks.web, 0, 3);
        StructureGenUtils.fillWithoutReplace(world, this.box.minX + 2, this.box.maxX - 1, this.box.minY + 1, this.box.minY + 4, this.box.minZ + 1, this.box.minZ + 2, Blocks.web, 0, 3);
        StructureGenUtils.fillWithoutReplace(world, this.box.minX + 2, this.box.maxX - 1, this.box.minY + 1, this.box.minY + 4, this.box.maxZ - 1, this.box.maxZ, Blocks.web, 0, 3);
    }

    @Override
    protected void onUpdateTick(World world) {
        boolean flag = false;
        if (world.rand.nextInt(4) < 3) {
            flag = true;
            for (int i = 0; i < this.difficulty + 2; ++i) {
                this.setRandomBlockTo(world, Blocks.web, 0, "zeldaswordskills:web_splat");
            }
        }
        if (!flag || world.rand.nextInt(2) == 0) {
            this.destroyRandomPillar(world, this.difficulty == 3);
        }
        this.scheduleUpdateTick(100 + world.rand.nextInt(500));
    }
}

